/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.StatusUtil;
import com.bokesoft.yes.bpm.engine.data.row.RTransaction;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.item.ItemNode;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.TreeSet;
import org.json.JSONArray;

public class BatchStateActionCmd
extends BPMServiceCmd {
    public static final String TAG = "BatchStateAction";
    private TreeSet<Long> OIDTreeSet = new TreeSet();
    private String processKey;
    private String actionNodeKey;
    private int binaryResult;
    private String userInfo;

    @Override
    public void dealArguments(BPMContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        this.processKey = (String)stringHashMap.get((Object)"processKey");
        this.binaryResult = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"binaryResult"));
        this.userInfo = (String)stringHashMap.get((Object)"userInfo");
        this.actionNodeKey = (String)stringHashMap.get((Object)"actionNodeKey");
        object = TypeConvertor.toString((Object)stringHashMap.get((Object)"OIDListStr"));
        object = new JSONArray((String)object);
        for (int i2 = 0; i2 < object.length(); ++i2) {
            this.OIDTreeSet.add(object.getLong(i2));
        }
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        String string = "select  instanceID,ProcessKey from BPM_Instance where OID=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = bPMContext.getDBManager().preparedQueryStatement(string);
            for (Long l2 : this.OIDTreeSet) {
                Object object = -1L;
                preparedStatement.setLong(1, l2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next() && this.processKey.equals(resultSet.getString(2))) {
                    object = resultSet.getLong(1);
                }
                if ((Long)object <= 0L) continue;
                BPMContext bPMContext2 = BPMContext.getBPMContext(bPMContext, (Long)object);
                object = BPMInstanceFactory.getBPMInstance(bPMContext2, (Long)object);
                Object object2 = (MetaStateAction)((BPMInstance)object).getMainInstance().getMetaNodeByNodeKey(this.actionNodeKey);
                object2 = ((BPMInstance)object).getMainInstance().getInstanceData().getNode().getNodeData(object2.getStateNode().getID(), bPMContext.getDBManager()).getWorkitemID();
                if (object2.longValue() > 0L) {
                    this.commitWorkitem(bPMContext2, (Long)object2, (BPMInstance)object);
                }
                bPMContext2.getInstanceDataContainer().save();
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return null;
    }

    private void commitWorkitem(BPMContext bPMContext, Long object, BPMInstance bPMInstance) throws Throwable {
        if ((object = this.loadWorkitem(bPMContext, (Long)object)) == null) {
            return;
        }
        bPMContext.setUpdateWorkitem((Workitem)object);
        ExecNode execNode = bPMInstance.getNodeByID(((Workitem)object).getInlineNodeID(), ((Workitem)object).getNodeID());
        if (execNode instanceof ItemNode) {
            RTransaction rTransaction = new RTransaction(((Workitem)object).getInstanceID());
            rTransaction.setTransactionID(bPMInstance.getInstanceData().getInstance().getData().getTransactionID());
            rTransaction.setWorkitemID(((Workitem)object).getWorkItemID());
            rTransaction.setOperatorID(bPMContext.getCurUserID());
            rTransaction.setworkitemRevoke(execNode.getNodeModel().isWorkitemRevoke());
            rTransaction.setStatusValue(StatusUtil.getStatusValue(bPMContext));
            bPMInstance.getInstanceData().getTransaction().addRow(rTransaction);
            if (bPMInstance.getInstanceData().getWorkitemData().getWorkitemData(bPMContext, ((Workitem)object).getWorkItemID()).getWorkitemState() == 2) {
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)5, (Object[])new Object[0]);
            }
            ((ItemNode)((Object)execNode)).getItemProxy().updateWorkitem(bPMContext);
        }
    }

    private Workitem loadWorkitem(BPMContext bPMContext, Long object) throws Throwable {
        if ((object = WorkitemUtil.loadWorkitem(bPMContext, (Long)object)) == null) {
            return null;
        }
        ((Workitem)object).setAuditResult(this.binaryResult);
        ((Workitem)object).setUserID(bPMContext.getCurUserID());
        ((Workitem)object).setUserInfo(this.userInfo);
        ((Workitem)object).setOperationKey(this.actionNodeKey);
        ((Workitem)object).setWorkItemState(2);
        return object;
    }

    @Override
    public String getCmd() {
        return TAG;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new BatchStateActionCmd();
    }

    public void setOIDTreeSet(List<Long> list) {
        this.OIDTreeSet.addAll(list);
    }

    public void setProcessKey(String string) {
        this.processKey = string;
    }

    public void setActionNodeKey(String string) {
        this.actionNodeKey = string;
    }

    public void setBinaryResult(int n2) {
        this.binaryResult = n2;
    }

    public void setUserInfo(String string) {
        this.userInfo = string;
    }
}

