package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.bpm.meta.transform.graph.TransBPMGraph;
import com.bokesoft.yes.bpm.service.cmd.DownloadProcessGraphCmd;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

/**
 * 加载审批记录
 * 
 * @author guowj
 *
 */
public class LoadAuditRecord {

	public static final String PROCESS_KEY = "processKey";
	public static final String VERSION = "version";
	public static final String TRANS_PATH = "transPath";
	public static final String AUDIT_LOG = "auditLog";
	public static final String WORKITEM_ID = "workItemID";
	public static final String WORKITEM_NAME = "workitemName";
	public static final String CREATE_TIME = "createTime";
	public static final String FINISH_TIME = "finishTime";
	public static final String AUDIT_RESULT = "auditResult";
	public static final String USER_INFO = "userInfo";
	public static final String WORKITEM_STATE = "workitemState";
	public static final String OPERATOR_ID = "operatorID";
	public static final String INSTANCE_STATE = "instanceState";
	public static final String LOG_INDEX = "logIndex";
	
	private String processKey = "";
	private Integer verID = -1;
	private Long OID = -1l; 
	
	public LoadAuditRecord(String processKey, Integer verID, Long OID) {
		this.processKey = processKey;
		this.verID = verID;
		this.OID = OID;
	}
	
	public JSONObject load(DefaultContext context) throws Throwable{
		JSONObject graphAuditLog = new JSONObject();
		DownloadProcessGraphCmd cmd = new DownloadProcessGraphCmd();
		cmd.setProcessKey(processKey);
		cmd.setVerID(verID);
		cmd.setOID(OID);
		JSONObject graphJSON = (JSONObject)cmd.doCmd(context);
		graphAuditLog.put(PROCESS_KEY, graphJSON.optString(TransBPMGraph.tag_key));
		graphAuditLog.put(VERSION, graphJSON.optInt(TransBPMGraph.tag_version));
		// 加载流转图
		graphAuditLog.put(TRANS_PATH, graphJSON.optJSONObject("transpath"));
		// 加载流程日志
		graphAuditLog.put(AUDIT_LOG, loadBPMLog(context));
		return graphAuditLog;
	}
	
	private JSONArray loadBPMLog(DefaultContext context) throws Throwable{
		JSONArray bpmLog = new JSONArray();
		IDBManager DBManager = context.getDBManager();
		String sql = "select " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_LOG) + "." + DBManager.keyWordEscape(SystemDBField.WORKITEMID) + ","
				+ DBManager.keyWordEscape(SystemDBField.WORKITEMNAME) + ","
				+ DBManager.keyWordEscape(SystemDBField.CREATETIME) + ","
				+ DBManager.keyWordEscape(SystemDBField.FINISHTIME) + ","
				+ DBManager.keyWordEscape(SystemDBField.AUDITRESULT) + ","
				+ DBManager.keyWordEscape(SystemDBField.USERINFO) + ","
				+ DBManager.keyWordEscape(SystemDBField.WORKITEMSTATE) + ","
				+ DBManager.keyWordEscape(SystemDBField.BPM_LOG) + "." + DBManager.keyWordEscape(SystemDBField.OPERATORID) +","
				+ DBManager.keyWordEscape(SystemDBField.INSTANCESTATE) + ","
				+ DBManager.keyWordEscape(SystemDBField.LOGINDEX) 
				+ " from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_LOG) + " "
				+ "join " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_INSTANCE) 
				+ " on " + DBManager.keyWordEscape(SystemDBField.BPM_LOG) + "." + DBManager.keyWordEscape(SystemDBField.INSTANCEID) 
				+ "=" + DBManager.keyWordEscape(SystemDBField.BPM_INSTANCE) + "." + DBManager.keyWordEscape(SystemDBField.INSTANCEID) 
				+ " where " + DBManager.keyWordEscape(SystemDBField.WORKITEMID) + " in("
				+ "select " + DBManager.keyWordEscape(SystemDBField.WORKITEMID) + " from " + DBManager.keyWordEscape(SystemDBField.BPM_WORKITEMINFO) 
				+ " where " + DBManager.keyWordEscape(SystemDBField.INSTANCEID) + " in("
				+ "select " + DBManager.keyWordEscape(SystemDBField.INSTANCEID) + " from " + DBManager.keyWordEscape(SystemDBField.BPM_INSTANCE) 
				+ " where " + DBManager.keyWordEscape(SystemDBField.OID) + "=?))"
				+ "order by "
				+ DBManager.keyWordEscape(SystemDBField.LOGINDEX)
				+ " desc";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addLongArg(OID);
			rs = DBManager.executeQuery(ps, sql, args);
			while(rs.next()){
				JSONObject logItems = new JSONObject();
				logItems.put(WORKITEM_ID, rs.getLong(1));
				logItems.put(WORKITEM_NAME, rs.getString(2));
				Timestamp createTime = rs.getTimestamp(3);
				if(createTime != null){
					logItems.put(CREATE_TIME, createTime.toString());
				}
				Timestamp finishTime = rs.getTimestamp(4);
				if(finishTime != null){
					logItems.put(FINISH_TIME, finishTime.toString());
				}
				logItems.put(AUDIT_RESULT, rs.getInt(5));
				logItems.put(USER_INFO, rs.getString(6));
				logItems.put(WORKITEM_STATE, rs.getInt(7));
				logItems.put(OPERATOR_ID, rs.getLong(8));
				logItems.put(INSTANCE_STATE, rs.getInt(9));
				logItems.put(LOG_INDEX, rs.getInt(10));
				bpmLog.put(logItems);
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
		return bpmLog;
	}
}
