package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.mid.connection.IDBManager;

public class GetValidNodesIncludeInline {

	/** 节点ID*/
	private int nodeID = -1;
	
	/** 子节点ID*/
	private int subNodeID = -1;
	
	/** 流程标识*/
	private String processKey = "";
	
	/** 实例ID*/
	private long instanceID = -1L;
	
	/** 是否忽略节点深度，默认为false*/
	private boolean ignoreDeep = false;
	
	/** 流程版本*/
	private int version = -1;
	
	/**
	 * 构造函数
	 * @param nodeID 节点ID
	 * @param processKey 流程标识
	 * @param instanceID 实例ID
	 */
	public GetValidNodesIncludeInline(int nodeID, String processKey, long instanceID) {
		this.nodeID = nodeID;
		this.processKey = processKey;
		this.instanceID = instanceID;
	}
	
	/**
	 * 构造函数
	 * @param nodeID 节点ID
	 * @param processKey 流程标识
	 * @param instanceID 实例ID
	 * @param ignoreDeep 是否忽略节点深度
	 * @param version 流程版本
	 */
	public GetValidNodesIncludeInline(int nodeID, String processKey, long instanceID, boolean ignoreDeep, int version) {
		this.nodeID = nodeID;
		this.processKey = processKey;
		this.instanceID = instanceID;
		this.ignoreDeep = ignoreDeep;
		this.version = version;
	}
	
	public GetValidNodesIncludeInline(int nodeID, int subNodeID, long instanceID, boolean ignoreDeep) {
		this.nodeID = nodeID;
		this.subNodeID = subNodeID;
		this.instanceID = instanceID;
		this.ignoreDeep = ignoreDeep;
	}
	
	public GetValidNodesIncludeInline(int nodeID, long instanceID, boolean ignoreDeep) {
		this.nodeID = nodeID;
		this.instanceID = instanceID;
		this.ignoreDeep = ignoreDeep;
	}
	
	/**
	 * 获取可以驳回的有效节点集合
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public Map<String, List<Integer>> validNodes(BPMContext context)throws Throwable{
		MetaProcess process = null;
		if(processKey == null || processKey.length() == 0){
			calculateProcessKeyAndVersion(context, instanceID);
		}
		if (version == -1) {
			process = BPMUtil.getProcessDefinationByDeployKey(context.getVE(), processKey);
		}else {
			process = BPMUtil.getProcessDefinationBy(context.getVE(), processKey, version);
		}
		if (process == null) {
			return null;
		}
		return ProcessUtil.getValidSites(context, nodeID, subNodeID, process, instanceID, ignoreDeep);
	}
	
	private void calculateProcessKeyAndVersion(BPMContext context, long instanceID) throws Throwable{
		if (instanceID > 0) {
			PreparedStatement ps = null;
			ResultSet rs = null;
			try {
				IDBManager dbm = context.getDBManager();
				String sql = "select " 
						+ dbm.keyWordEscape(SystemDBField.PROCESSKEY) + ","
						+ dbm.keyWordEscape(SystemDBField.WF_VERID)
						+ " from " 
						+  dbm.keyWordEscape(SystemDBField.BPM_INSTANCE) 
						+ " where " 
						+ dbm.keyWordEscape(SystemDBField.INSTANCEID) + "=?";
				ps = context.getDBManager().preparedQueryStatement(sql);
				ps.setLong(1, instanceID);
				rs = ps.executeQuery();
				if (rs.next()) {
					processKey = rs.getString(1);
					version = rs.getInt(2);
				}
			} finally {
				if (rs != null)
					rs.close();
				if (ps != null)
					ps.close();
			}
		}
	}
}
