package com.bokesoft.yigo.bpm;

import java.util.List;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;

public class GetValidNodes {
	/** 节点ID*/
	private int nodeid = -1;
	
	/** 流程标识*/
	private String processKey = "";
	
	/** 实例ID*/
	private long instanceID = -1L;
	
	/** 是否忽略节点深度，默认为false*/
	private boolean ignoreDeep = false;
	
	/** 流程版本*/
	private int version = -1;
	
	/**
	 * 构造函数
	 * @param nodeID 节点ID
	 * @param processKey 流程标识
	 * @param instanceID 实例ID
	 */
	public GetValidNodes(int nodeID, String processKey, long instanceID) {
		this.nodeid = nodeID;
		this.processKey = processKey;
		this.instanceID = instanceID;
	}
	
	/**
	 * 构造函数
	 * @param nodeID 节点ID
	 * @param processKey 流程标识
	 * @param instanceID 实例ID
	 * @param ignoreDeep 是否忽略节点深度
	 * @param version 流程版本
	 */
	public GetValidNodes(int nodeID, String processKey, long instanceID, boolean ignoreDeep, int version) {
		this.nodeid = nodeID;
		this.processKey = processKey;
		this.instanceID = instanceID;
		this.ignoreDeep = ignoreDeep;
		this.version = version;
	}
	/**
	 * 获取可以驳回的有效节点集合
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public List <Integer> validNodes(BPMContext context)throws Throwable{
		MetaProcess process = null;
		if (version == -1) {
			process = BPMUtil.getProcessDefinationByDeployKey(context.getVE(), processKey);
		}else {
			process = BPMUtil.getProcessDefinationBy(context.getVE(), processKey, version);
		}
		if (process == null) {
			return null;
		}
		return ProcessUtil.getValidSites2(context, nodeid, process, instanceID, ignoreDeep);
	}
}
