/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.engine.data.row.REventLog;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.sql.Timestamp;
import org.json.JSONObject;

public class RecallInstanceCmd
extends BPMServiceCmd {
    public static final String TAG_NAME = "RecallInstance";
    private long instanceID = -1L;
    private long OID = -1L;
    private String userInfo = "";

    public void setInstanceID(long l2) {
        this.instanceID = l2;
    }

    public void setOID(long l2) {
        this.OID = l2;
    }

    public void setUserInfo(String string) {
        this.userInfo = string;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new RecallInstanceCmd();
    }

    @Override
    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        if (stringHashMap.get((Object)"instanceID") != null) {
            this.instanceID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"instanceID"));
        } else if (stringHashMap.get((Object)"OID") != null) {
            this.OID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"OID"));
        }
        this.userInfo = TypeConvertor.toString((Object)stringHashMap.get((Object)"userInfo"));
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        LogSvr.getInstance().debug("RecallInstanceCmd is called...");
        BPMInstance bPMInstance = null;
        if (this.instanceID > 0L) {
            bPMContext = BPMContext.getBPMContext(bPMContext, (Long)this.instanceID);
            bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, this.instanceID);
        } else if (this.OID > 0L) {
            bPMInstance = BPMInstanceFactory.getBPMInstanceByOID(bPMContext, this.OID, false);
            bPMContext = BPMContext.getBPMContext(bPMContext, bPMInstance.getInstanceID());
        }
        REventLog rEventLog = new REventLog(this.instanceID);
        rEventLog.setLogID(bPMInstance.getInstanceData().getInstance().applyNewEventID());
        rEventLog.setEventTime(new Timestamp(bPMContext.getDBManager().getCurTime()));
        rEventLog.setActiveType(6);
        rEventLog.setName("\u53ec\u56de\u6d41\u7a0b");
        rEventLog.setsOperator(bPMContext.getVE().getEnv().getUserID());
        rEventLog.setUserinfo(this.userInfo);
        bPMInstance.getInstanceData().getEventLog().addRow(rEventLog);
        bPMInstance.recallInstance(bPMContext);
        bPMContext.getInstanceDataContainer().save();
        bPMContext = new JSONObject();
        bPMContext.put("result", true);
        return bPMContext;
    }

    @Override
    public String getCmd() {
        return TAG_NAME;
    }
}

