/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.data.InstanceData;
import com.bokesoft.yes.bpm.engine.data.table.TAttachment;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecDataMap;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SaveBPMDataMapProcess
implements IServiceProcess<DefaultContext> {
    private Long instanceID = -1L;
    private Integer inlineNodeID = -1;
    private Integer nodeID = -1;

    SaveBPMDataMapProcess() {
    }

    public void process(DefaultContext defaultContext) throws Throwable {
        if (!BPMUtil.checkBPMProcess(defaultContext)) {
            return;
        }
        if (this.processRegisterAttachment(defaultContext)) {
            return;
        }
        this.processMapData(defaultContext);
    }

    private boolean searchData(Long l2, DefaultContext defaultContext) throws Throwable {
        Object object = defaultContext.getDBManager();
        object = "select " + object.keyWordEscape("InstanceID") + "," + object.keyWordEscape("InlineNodeID") + "," + object.keyWordEscape("NodeID") + " from " + object.keyWordEscape("BPM_WorkitemInfo") + " where " + object.keyWordEscape("WorkitemID") + "=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = defaultContext.getDBManager().preparedQueryStatement((String)object);
            preparedStatement.setLong(1, l2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.instanceID = resultSet.getLong(1);
                this.inlineNodeID = resultSet.getInt(2);
                this.nodeID = resultSet.getInt(3);
                return true;
            }
            return false;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private boolean processMapData(DefaultContext object) throws Throwable {
        Document document = object.getDocument();
        Object object2 = document.getExpandData("SaveBPMMap");
        if (object2 == null) {
            return false;
        }
        document.removeExpandData("SaveBPMMap");
        object2 = (Long)object2;
        if (!this.searchData((Long)object2, (DefaultContext)object)) {
            return false;
        }
        object2 = BPMContext.getBPMContext((DefaultContext)object, this.instanceID);
        Object object3 = BPMInstanceFactory.getBPMInstance((BPMContext)((Object)object2), this.instanceID);
        if (object3 != null) {
            if ((object3 = ((BPMInstance)object3).getNodeByID(this.inlineNodeID, this.nodeID)) == null) {
                return false;
            }
            if (((ExecNode)((Object)object3)).getNodeType() != 13) {
                throw BPMError.getBPMError((ILocale)object.getEnv(), (int)46, (Object[])new Object[0]);
            }
            object3 = (ExecDataMap)object3;
            BPMContext bPMContext = new BPMContext((DefaultContext)object);
            object = ((ExecDataMap)object3).signSubInstanceData(bPMContext, document, object.getFormKey());
            if (bPMContext.getContextContainer() != null) {
                bPMContext.getContextContainer().putContext(((InstanceData)object).getInstanceID(), BPMContext.TYPE, (IServiceContext)bPMContext);
            }
            ((InstanceData)object).commit(bPMContext);
            ((ExecDataMap)object3).updateInstance((BPMContext)((Object)object2), ((InstanceData)object).getInstanceID());
        }
        return true;
    }

    private boolean processRegisterAttachment(DefaultContext defaultContext) throws Throwable {
        Document document = defaultContext.getDocument();
        if (!document.isNew()) {
            return false;
        }
        Object object = document.getExpandData("RegisterAttachment");
        if (object == null) {
            return false;
        }
        document.remove("RegisterAttachment");
        object = (Long)object;
        if (!this.searchData((Long)object, defaultContext)) {
            return false;
        }
        object = BPMContext.getBPMContext(defaultContext, this.instanceID);
        Object object2 = BPMInstanceFactory.getBPMInstance((BPMContext)((Object)object), this.instanceID);
        if (object2 != null) {
            TAttachment tAttachment = ((BPMInstance)object2).getInstanceData().getAttachment();
            object2 = ((BPMInstance)object2).getNodeByID(this.inlineNodeID, this.nodeID).getNodeModel().getNodeAttachment().getKey();
            tAttachment.updateInfo((String)object2, document.getOID(), "", "", defaultContext.getDBManager());
            ((BPMContext)((Object)object)).getInstanceDataContainer().save();
        }
        return true;
    }
}

