/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.instance;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.data.row.RLog;
import com.bokesoft.yes.bpm.engine.data.virtual.VirtualInstanceData;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.NodeSet;
import com.bokesoft.yes.bpm.engine.node.ExecDataMap;
import com.bokesoft.yes.bpm.engine.node.ExecInline;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.ExecSub;
import com.bokesoft.yes.bpm.interpreter.INode;
import com.bokesoft.yes.bpm.interpreter.NodeFactoryProxy;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.bpm.workitem.data.WorkitemDataContainer;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.expand.MetaExpand;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.Iterator;

public class VirtualInstance
implements Iterable<ExecNode> {
    private BPMInstance BPMInstance = null;
    private NodeSet nodeSet = null;
    private VirtualInstanceData instanceData = null;
    private ExecInline inlineNode = null;
    private boolean isInlineInstance = false;
    private String definationKey = null;
    private int verID = -1;
    private MetaExpand expand = null;

    public VirtualInstance(MetaProcess metaProcess, NodeFactoryProxy nodeFactoryProxy, VirtualInstanceData virtualInstanceData, BPMInstance bPMInstance, BPMContext bPMContext) throws Throwable {
        this.instanceData = virtualInstanceData;
        this.BPMInstance = bPMInstance;
        this.definationKey = metaProcess.getKey();
        this.verID = metaProcess.getVersion();
        this.expand = metaProcess.getExpand();
        this.nodeSet = new NodeSet(this, metaProcess, nodeFactoryProxy, bPMContext);
    }

    public void checkAndCreateNodeData(IDBManager iDBManager) throws Throwable {
        Iterator<ExecNode> iterator = this.nodeSet.iterator();
        while (iterator.hasNext()) {
            iterator.next().checkAndCreateNodeData(iDBManager);
        }
    }

    public void startInstance(BPMContext bPMContext) throws Throwable {
        this.nodeSet.startInstance(bPMContext);
    }

    public void syncInstance(BPMContext bPMContext, int n2, Long l2) throws Throwable {
        ExecNode execNode = this.getNodeByID(n2);
        if (execNode instanceof ExecSub) {
            ((ExecSub)execNode).sync(bPMContext, l2);
            return;
        }
        if (execNode instanceof ExecDataMap) {
            ((ExecDataMap)execNode).sync(bPMContext, l2);
        }
    }

    public int applyNewStepID() {
        return this.BPMInstance.getInstanceData().getInstance().applyNewStepID();
    }

    public int applyNewTokenID() {
        return this.BPMInstance.getInstanceData().getInstance().applyNewTokenID();
    }

    public int applyNewLogID() {
        return this.BPMInstance.getInstanceData().getInstance().applyNewLogID();
    }

    public int applyNewLogIndexID() {
        return this.BPMInstance.getInstanceData().getInstance().applyNewLogIndexID();
    }

    public VirtualInstanceData getInstanceData() {
        return this.instanceData;
    }

    public long getInstanceID() {
        return this.BPMInstance.getInstanceID();
    }

    public void end(BPMContext bPMContext) throws Throwable {
        if (this.instanceData.getInlineNodeID() > 0) {
            this.inlineNode.embedInstanceEnd(bPMContext);
            return;
        }
        this.BPMInstance.end(bPMContext);
    }

    public ExecNode getNodeByID(int n2) {
        return this.nodeSet.getNodeByID(n2);
    }

    public ExecNode getNodeByKey(String string) {
        return this.nodeSet.getNodeByKey(string);
    }

    public BPMInstance getBPMInstance() {
        return this.BPMInstance;
    }

    public void setInlineNode(ExecInline execInline) {
        this.isInlineInstance = true;
        this.inlineNode = execInline;
    }

    @Override
    public Iterator<ExecNode> iterator() {
        return this.nodeSet.iterator();
    }

    public String getDefinationKey() {
        return this.definationKey;
    }

    public int getVersion() {
        return this.verID;
    }

    public MetaExpand getExpand() {
        return this.expand;
    }

    public WorkitemDataContainer getWorkitemData() {
        return this.BPMInstance.getInstanceData().getWorkitemData();
    }

    public RLog addNewWorkitemDataAndCreateLog(RWorkitem rWorkitem) {
        this.getWorkitemData().addNewWorkitemData(rWorkitem);
        RLog rLog = this.getBPMInstance().getInstanceData().getLog().copyDataFromWorkitem(rWorkitem, this.applyNewLogID(), this.applyNewLogIndexID());
        rWorkitem.setLogID(rLog.getLogID());
        return rLog;
    }

    public RLog addNewWorkitemDataAndCreateLog(RWorkitem rWorkitem, IDBManager iDBManager) throws Throwable {
        if (rWorkitem.getInlineNodeID() > 0) {
            RLog rLog;
            boolean bl = false;
            Iterator iterator = this.getBPMInstance().getInstanceData().getLog().iterator();
            while (iterator.hasNext()) {
                rLog = (RLog)iterator.next();
                if (rLog.getNodeID().intValue() != rWorkitem.getInlineNodeID() || rLog.getWorkitemID() >= -2L) continue;
                rWorkitem.setPartentWorkitemID(rLog.getWorkitemID());
                bl = true;
            }
            if (!bl) {
                this.getBPMInstance().getInstanceData().getLog().load(iDBManager);
                iterator = this.getBPMInstance().getInstanceData().getLog().iterator();
                while (iterator.hasNext()) {
                    rLog = (RLog)iterator.next();
                    if (rLog.getNodeID().intValue() != rWorkitem.getInlineNodeID() || rLog.getWorkitemID() >= -2L || rLog.getWorkitemID() >= rWorkitem.getPartentWorkitemID()) continue;
                    rWorkitem.setPartentWorkitemID(rLog.getWorkitemID());
                }
            }
        }
        return this.addNewWorkitemDataAndCreateLog(rWorkitem);
    }

    public RLog createLogAndUpdateWorkitemState(RWorkitem rWorkitem, boolean bl) {
        RLog rLog = this.getBPMInstance().getInstanceData().getLog().copyDataFromWorkitem(rWorkitem, this.applyNewLogID(), this.applyNewLogIndexID());
        rLog.setWorkitemState(2);
        if (bl) {
            rWorkitem.setLogID(rLog.getLogID());
        }
        return rLog;
    }

    public RLog createLogAndUpdateWorkitemState(RWorkitem rWorkitem, boolean bl, IDBManager iDBManager) throws Throwable {
        this.getParentWorkitemID(rWorkitem, iDBManager);
        return this.createLogAndUpdateWorkitemState(rWorkitem, bl);
    }

    public RLog createLogForWorkitem(RWorkitem rWorkitem) throws Throwable {
        if (rWorkitem == null) {
            return null;
        }
        RLog rLog = this.getBPMInstance().getInstanceData().getLog().copyDataFromWorkitem(rWorkitem, this.applyNewLogID(), this.applyNewLogIndexID());
        int n2 = rLog.getLogID();
        rWorkitem.setLogID(n2);
        return rLog;
    }

    public RLog createLogForWorkitem(RWorkitem rWorkitem, IDBManager iDBManager) throws Throwable {
        this.getParentWorkitemID(rWorkitem, iDBManager);
        return this.createLogForWorkitem(rWorkitem);
    }

    public void getParentWorkitemID(RWorkitem rWorkitem, IDBManager iDBManager) throws Throwable {
        if (rWorkitem.getInlineNodeID() > 0) {
            RLog rLog;
            boolean bl = false;
            Iterator iterator = this.getBPMInstance().getInstanceData().getLog().iterator();
            while (iterator.hasNext()) {
                rLog = (RLog)iterator.next();
                if (rLog.getNodeID().intValue() != rWorkitem.getInlineNodeID() || rLog.getWorkitemID() >= -2L) continue;
                rWorkitem.setPartentWorkitemID(rLog.getWorkitemID());
                bl = true;
            }
            if (!bl) {
                this.getBPMInstance().getInstanceData().getLog().load(iDBManager);
                iterator = this.getBPMInstance().getInstanceData().getLog().iterator();
                while (iterator.hasNext()) {
                    rLog = (RLog)iterator.next();
                    if (rLog.getNodeID().intValue() != rWorkitem.getInlineNodeID() || rLog.getWorkitemID() >= -2L || rLog.getWorkitemID() >= rWorkitem.getPartentWorkitemID()) continue;
                    rWorkitem.setPartentWorkitemID(rLog.getWorkitemID());
                }
            }
        }
    }

    public boolean isInlineInstance() {
        return this.isInlineInstance;
    }

    public MetaEnd getEndNode() {
        return this.nodeSet.getEndNode();
    }

    public MetaBegin getBeginNode() {
        return this.nodeSet.getBeginNode();
    }

    public void putNodeIDMap(int n2, ExecNode execNode) {
        this.nodeSet.putNodeIDMap(n2, execNode);
    }

    public void putNodeKeyMap(String string, ExecNode execNode) {
        this.nodeSet.putNodeKeyMap(string, execNode);
    }

    public MetaNode getMetaNodeByNodeKey(String string) {
        return this.nodeSet.getMetaNodeByNodeKey(string);
    }

    public MetaNode getMetaNodeByID(Integer n2) {
        return this.nodeSet.getMetaNodeByID(n2);
    }

    public void buildAssistanceNodeMap(ExecNode execNode) {
        this.nodeSet.buildAssistanceNodeMap(execNode);
    }

    public ExecNode createNode(MetaNode metaNode) throws BPMError {
        return this.nodeSet.createNode(metaNode);
    }

    public INode getProxyNode(ExecNode execNode) {
        return this.nodeSet.getProxyNode(execNode);
    }
}

