/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.data.table;

import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.engine.data.row.RToken;
import com.bokesoft.yes.bpm.engine.data.table.BPMTable;
import com.bokesoft.yes.bpm.engine.data.table.SplitTable;
import com.bokesoft.yes.bpm.engine.data.virtual.table.VTToken;
import com.bokesoft.yes.bpm.workitem.data.SqlHelper;
import com.bokesoft.yes.mid.cache.RowKey;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.HashMap;

public class TToken
extends BPMTable<RToken>
implements SplitTable<VTToken> {
    private HashMap<Integer, VTToken> vTTokenMap = new HashMap();

    public TToken(Long l2, OIDRef oIDRef) {
        super(l2, oIDRef);
    }

    @Override
    public String getDataSourceSql(IDBManager iDBManager) {
        return "select * from  " + iDBManager.keyWordEscape("BPM_Token") + " where " + iDBManager.keyWordEscape("InstanceID") + "=?";
    }

    @Override
    public String getDeleteSql(IDBManager iDBManager) {
        return "delete  from  " + iDBManager.keyWordEscape("BPM_Token") + " where " + iDBManager.keyWordEscape("InstanceID") + "=?   and " + iDBManager.keyWordEscape("TokenID") + "=?";
    }

    @Override
    public String getUpdateSql(IDBManager iDBManager) {
        return "update  " + iDBManager.keyWordEscape("BPM_Token") + "  set " + iDBManager.keyWordEscape("NodeID") + "=? ," + iDBManager.keyWordEscape("InlineNodeID") + "=?," + iDBManager.keyWordEscape("AssistTransactionID") + "=? where " + iDBManager.keyWordEscape("InstanceID") + "=?  and " + iDBManager.keyWordEscape("TokenID") + "=?";
    }

    @Override
    public String getInsertSql(IDBManager iDBManager) {
        return "insert into  " + iDBManager.keyWordEscape("BPM_Token") + "  (" + iDBManager.keyWordEscape("InstanceID") + "," + iDBManager.keyWordEscape("OID") + "," + iDBManager.keyWordEscape("TokenID") + "," + iDBManager.keyWordEscape("NodeID") + "," + iDBManager.keyWordEscape("InlineNodeID") + "," + iDBManager.keyWordEscape("TransactionID") + "," + iDBManager.keyWordEscape("AssistTransactionID") + ") values(?,?,?,?,?,?,?)";
    }

    @Override
    protected String getDeleteAllSql(IDBManager iDBManager) {
        return "delete from " + iDBManager.keyWordEscape("BPM_Token") + "  where " + iDBManager.keyWordEscape("InstanceID") + "=?";
    }

    public QueryArguments getDeletePSArgs(IDBManager iDBManager, RToken rToken) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(Integer.valueOf(rToken.getTokenID()));
        return pSArgs;
    }

    public QueryArguments getUpdatePSArgs(IDBManager iDBManager, RToken rToken) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addIntArg(Integer.valueOf(rToken.getNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getInlineNodeID()));
        pSArgs.addIntArg(rToken.getAssistTransactionID());
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(Integer.valueOf(rToken.getTokenID()));
        return pSArgs;
    }

    @Override
    public QueryArguments getInsertPSArgs(RToken rToken) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addLongArg(this.instanceID);
        pSArgs.addLongArg(Long.valueOf(this.OID.get()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getTokenID()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rToken.getInlineNodeID()));
        pSArgs.addIntArg(rToken.getTransactionID());
        pSArgs.addIntArg(rToken.getAssistTransactionID());
        return pSArgs;
    }

    public void removeAll(IDBManager object) throws Throwable {
        this.loadData((IDBManager)object);
        object = this.visableRows().iterator();
        while (object.hasNext()) {
            ((RToken)object.next()).setDeleted();
        }
    }

    public void deleteTokenByNodeID(int n2, IDBManager object) throws Throwable {
        this.loadData((IDBManager)object);
        for (RToken rToken : this.visableRows()) {
            if (rToken.getNodeID() != n2) continue;
            rToken.setDeleted();
        }
    }

    public void deleteInlineNodeTokenID(int n2, IDBManager iDBManager) throws Throwable {
        this.loadData(iDBManager);
        Object object = this.vTTokenMap.get(n2);
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                ((RToken)object.next()).setDeleted();
            }
        }
    }

    public void deleteToken(int n2, IDBManager iDBManager) throws Throwable {
        RowKey rowKey = new RowKey();
        rowKey.put((Object)this.instanceID);
        rowKey.put((Object)n2);
        RToken rToken = (RToken)this.getRow(rowKey);
        if (rToken == null) {
            this.loadData(iDBManager);
            rToken = (RToken)this.getRow(rowKey);
        }
        if (rToken != null) {
            rToken.setDeleted();
        }
    }

    @Override
    public RToken createEmptyRow() {
        return new RToken(this.instanceID);
    }

    @Override
    public VTToken split(int n2) {
        TToken tToken = this;
        VTToken vTToken = new VTToken(tToken, tToken.instanceID, n2);
        this.vTTokenMap.put(n2, vTToken);
        return vTToken;
    }

    private void loadData(IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        object = this.iterator();
        while (object.hasNext()) {
            RToken rToken = (RToken)object.next();
            this.vTTokenMap.get(rToken.getInlineNodeID()).internalAddRow(rToken);
        }
    }
}

