/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.data.table;

import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.engine.data.row.RNode;
import com.bokesoft.yes.bpm.engine.data.table.BPMTable;
import com.bokesoft.yes.bpm.engine.data.table.SplitTable;
import com.bokesoft.yes.bpm.engine.data.virtual.table.VTNode;
import com.bokesoft.yes.bpm.workitem.data.SqlHelper;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.HashMap;
import java.util.Iterator;

public class TNode
extends BPMTable<RNode>
implements SplitTable<VTNode> {
    private HashMap<Integer, VTNode> vTNodeMap = new HashMap();

    public TNode(Long l2, OIDRef oIDRef) {
        super(l2, oIDRef);
    }

    @Override
    public String getDataSourceSql(IDBManager iDBManager) {
        return "select * from  " + iDBManager.keyWordEscape("BPM_Node") + " where " + iDBManager.keyWordEscape("InstanceID") + "=?";
    }

    @Override
    public String getUpdateSql(IDBManager iDBManager) {
        return "update  " + iDBManager.keyWordEscape("BPM_Node") + "  set " + iDBManager.keyWordEscape("SubInstanceID") + " =?," + iDBManager.keyWordEscape("Result") + "=?," + iDBManager.keyWordEscape("WorkitemID") + "=?," + iDBManager.keyWordEscape("BPMState") + "=?," + iDBManager.keyWordEscape("AssistTransactionID") + "=?," + iDBManager.keyWordEscape("CountSeed") + "=?," + iDBManager.keyWordEscape("InputDatas") + "=?," + iDBManager.keyWordEscape("MessageCount") + "=?," + iDBManager.keyWordEscape("InlineProcessKey") + "=? where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("InlineNodeID") + "=? and " + iDBManager.keyWordEscape("NodeID") + "=?";
    }

    @Override
    public String getInsertSql(IDBManager iDBManager) {
        return "insert into  " + iDBManager.keyWordEscape("BPM_Node") + "  (" + iDBManager.keyWordEscape("InstanceID") + "," + iDBManager.keyWordEscape("OID") + "," + iDBManager.keyWordEscape("InlineNodeID") + "," + iDBManager.keyWordEscape("NodeID") + "," + iDBManager.keyWordEscape("NodeType") + "," + iDBManager.keyWordEscape("Result") + "," + iDBManager.keyWordEscape("InlineVersion") + "," + iDBManager.keyWordEscape("WorkitemID") + "," + iDBManager.keyWordEscape("BPMState") + "," + iDBManager.keyWordEscape("CountSeed") + "," + iDBManager.keyWordEscape("TransactionID") + "," + iDBManager.keyWordEscape("AssistTransactionID") + "," + iDBManager.keyWordEscape("SubInstanceID") + "," + iDBManager.keyWordEscape("InputDatas") + "," + iDBManager.keyWordEscape("MessageCount") + "," + iDBManager.keyWordEscape("InlineProcessKey") + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    @Override
    public String getDeleteSql(IDBManager iDBManager) {
        return "delete from " + iDBManager.keyWordEscape("BPM_Node") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("InlineNodeID") + "=? and " + iDBManager.keyWordEscape("NodeID") + "=?";
    }

    @Override
    protected String getDeleteAllSql(IDBManager iDBManager) {
        return "delete from " + iDBManager.keyWordEscape("BPM_Node") + "  where " + iDBManager.keyWordEscape("InstanceID") + "=?";
    }

    public QueryArguments getDeletePSArgs(IDBManager iDBManager, RNode rNode) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(Integer.valueOf(rNode.getInlineNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rNode.getNodeID()));
        return pSArgs;
    }

    public QueryArguments getUpdatePSArgs(IDBManager iDBManager, RNode rNode) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addLongArg(rNode.getSubInstanceID());
        pSArgs.addIntArg(rNode.getResult());
        pSArgs.addLongArg(rNode.getWorkitemID());
        pSArgs.addIntArg(Integer.valueOf(rNode.getBPMState()));
        pSArgs.addIntArg(rNode.getAssistTransactionID());
        pSArgs.addIntArg(Integer.valueOf(rNode.getCountSeed()));
        pSArgs.addStringArg(rNode.getInputDatas().length() == 0 ? null : rNode.getInputDatas().toString());
        pSArgs.addIntArg(Integer.valueOf(rNode.getMessageCount()));
        pSArgs.addStringArg(rNode.getInlineProcessKey());
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(Integer.valueOf(rNode.getInlineNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rNode.getNodeID()));
        return pSArgs;
    }

    @Override
    public QueryArguments getInsertPSArgs(RNode rNode) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addLongArg(this.instanceID);
        pSArgs.addLongArg(Long.valueOf(this.OID.get()));
        pSArgs.addIntArg(Integer.valueOf(rNode.getInlineNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rNode.getNodeID()));
        pSArgs.addIntArg(Integer.valueOf(rNode.getNodeType()));
        pSArgs.addIntArg(rNode.getResult());
        pSArgs.addIntArg(Integer.valueOf(rNode.getInlineVersion()));
        pSArgs.addLongArg(rNode.getWorkitemID());
        pSArgs.addIntArg(Integer.valueOf(rNode.getBPMState()));
        pSArgs.addIntArg(Integer.valueOf(rNode.getCountSeed()));
        pSArgs.addIntArg(rNode.getTransactionID());
        pSArgs.addIntArg(rNode.getAssistTransactionID());
        pSArgs.addLongArg(rNode.getSubInstanceID());
        pSArgs.addStringArg(rNode.getInputDatas().length() == 0 ? null : rNode.getInputDatas().toString());
        pSArgs.addIntArg(Integer.valueOf(rNode.getMessageCount()));
        pSArgs.addStringArg(rNode.getInlineProcessKey());
        return pSArgs;
    }

    @Override
    public RNode createEmptyRow() {
        return new RNode(this.instanceID);
    }

    public void resetData4Restart() {
        Iterator iterator = this.rowList.iterator();
        while (iterator.hasNext()) {
            ((RNode)iterator.next()).setResult(-1);
        }
    }

    private void loadData(IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        object = this.iterator();
        while (object.hasNext()) {
            RNode rNode = (RNode)object.next();
            this.vTNodeMap.get(rNode.getInlineNodeID()).internalAddRow(rNode);
        }
    }

    @Override
    public VTNode split(int n2) {
        TNode tNode = this;
        VTNode vTNode = new VTNode(tNode, tNode.instanceID, n2);
        this.vTNodeMap.put(n2, vTNode);
        return vTNode;
    }
}

