package com.bokesoft.yigo.bpm.common;

import org.json.JSONObject;

import com.bokesoft.yes.bpm.engine.common.Result;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.meta.transform.WorkitemInfo;
import com.bokesoft.yes.bpm.workitem.TransitData;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.mid.base.DefaultMidVEFactory;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;

/**
 * 消息发送的帮助类
 * 
 * @author wubh
 *
 */
public class MessageUtil {
	
	private static final String INSTANCEID = "instanceID";
	private static final String NODEID = "nodeID";
	private static final String INLINENODEID = "inlineNodeID";
	private static final String WORKITEM_INFO = "workitemInfo";
	private static final String ADDITIONALINFO = "additionalInfo";
	private static final String OPERATIONTYPE = "operationType";
	private static final String ACTIVE_TOKENID = "activeTokenID";
	private static final String NEW_WORKITEM_ID = "newWorkitemID";
	private static final String ACTIVE_PARTICIPATOR = "activeParticipator";
	private static final String DEFAULT_CHECK = "defaultCheck";
	private static final String UPDATE_CHECKER_FIELD = "updateCheckerField";
	private static final String TRANSITDATA ="transitData";
	private static final String WORKITEMID ="workitemID";
	private static final String KEEPPARTS = "keepParts";
	/**
	 * 获取默认的标记信息,包含：
	 * <ul>
	 * <li>instanceID: 流程实例ID</li>
	 * <li>nodeID: 消息节点ID</li>
	 * <li>inlineNodeID:嵌入节点ID</li>
	 * <li></li>
	 * </ul>
	 * 
	 * @param context
	 *            上下文
	 * @param node
	 *            发送消息的节点
	 * @return
	 */
	public static JSONObject getDefaultTokenInfo(BPMContext context, MetaNode node) throws Throwable {

		JSONObject tokenInfo = new JSONObject();

		// instanceID
		long instanceID = -1L;
		BPMInstance instance = context.getActiveBPMInstance();
		if (instance != null) {
			instanceID = instance.getInstanceID();
		}
		tokenInfo.put(INSTANCEID, instanceID);

		// nodeID
		int nodeID = node.getID();
		tokenInfo.put(NODEID, nodeID);

		// inlineNodeID
		tokenInfo.put(INLINENODEID, -1);

		// workitemInfo
		WorkitemInfo info = getWorkitemInfo(context);
		if (info != null) {
			tokenInfo.put(WORKITEM_INFO, info.toJSON());
		}

		// additionalInfo
		JSONObject additionInfo = getAdditionInfo(context);
		tokenInfo.put(ADDITIONALINFO, additionInfo);

		return tokenInfo;
	}

	/**
	 * 从标记信息中恢复上下文
	 * 
	 * @return 上下文
	 * @throws Throwable
	 */
	public static BPMContext getContextFromTokenInfo(JSONObject tokenObj) throws Throwable {
		
		// 初始化上下文
		DefaultMidVEFactory veFactory = new DefaultMidVEFactory();
		BPMContext context = new BPMContext(veFactory.createVE());
		
		long instanceID = -1l;
		int nodeID = -1;
		if (tokenObj.has(INSTANCEID)) {
			instanceID = tokenObj.getLong(INSTANCEID);
		}
		if (tokenObj.has(NODEID)) {
			nodeID = tokenObj.getInt(NODEID);
		}
		if (instanceID == -1 || nodeID == -1) {
			return null;
		}
		context = BPMContext.getBPMContext(context, instanceID);
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(context, instanceID);
		if (instance == null) {
			return null;
		}
		
		if (tokenObj.has(WORKITEM_INFO)) {
			WorkitemInfo workitemInfo = new WorkitemInfo();
			workitemInfo.fromJSON(tokenObj.getJSONObject(WORKITEM_INFO));
			recoverWorkitemInfo(context, workitemInfo);
		}
		
		if (tokenObj.has(ADDITIONALINFO)) {
			JSONObject additionInfo = tokenObj.getJSONObject(ADDITIONALINFO);
			recoverAdditionInfo(context, additionInfo);
		}
		
		return context;
	}

	/**
	 * 获取工作项信息
	 * 
	 * @param context
	 *            上下文
	 * @return 工作项信息
	 */
	private static WorkitemInfo getWorkitemInfo(BPMContext context) {
		Workitem workitem = context.getUpdateWorkitem();
		if (workitem == null) {
			return null;
		}
		WorkitemInfo info = new WorkitemInfo();
		info.setWorkitemID(workitem.getWorkItemID());
		info.setAuditResult(workitem.getAuditResult());
		info.setUserInfo(workitem.getUserInfo());
		info.setOperationKey(workitem.getOperationKey());
		info.setNextOpStr(workitem.getNextOpStr());
		info.setSrcOperator(context.getSrcOperator());
		if (context.getBackSite() != null && context.getBackSite().length() > 0) {
			info.setBackSite(context.getBackSite());
			info.setBackSiteOpt(context.getBackSiteOpt());
		}
		return info;
	}
	/**
	 * 还原工作项信息
	 * @param context 上下文
	 * @param workitemInfo 工作项信息
	 * @throws Throwable
	 */
	private static void recoverWorkitemInfo(BPMContext context, WorkitemInfo workitemInfo)throws Throwable {
		Workitem workitem = WorkitemUtil.loadWorkitem(context, workitemInfo.getWorkitemID());
		if (workitem == null) {
			return ;
		}
		workitem.setAuditResult(workitemInfo.getAuditResult());
		workitem.setUserInfo(workitemInfo.getUserInfo());
		workitem.setResultInfo(Result.parseToString(workitemInfo.getAuditResult()));
		workitem.setOperationKey(workitemInfo.getOperationKey());
		workitem.setNextOpStr(workitemInfo.getNextOpStr());
		
		context.setSrcOperator(workitemInfo.getSrcOperator());
		if (workitemInfo.getBackSite() != null && workitemInfo.getBackSite().length() > 0) {
			context.setBackSite(workitemInfo.getBackSite());
			context.setTransitTo(workitem.getNodeID());
			context.setBackSiteWorkitemID(workitemInfo.getWorkitemID());//提交驳回的工作项ID
			context.setBackSiteOpt(workitemInfo.getBackSiteOpt());
		}
		
		context.setUpdateWorkitem(workitem);
	}
	
	

	/**
	 * 获取用于恢复上下文的额外信息
	 * 
	 * @param context
	 *            上下文
	 * @return
	 * @throws Throwable
	 */
	private static JSONObject getAdditionInfo(BPMContext context) throws Throwable {

		JSONObject info = new JSONObject();
		info.put(OPERATIONTYPE, context.getOperationType());
		info.put(ACTIVE_TOKENID, context.getActiveTokenID());
		info.put(NEW_WORKITEM_ID, context.getNewWorkitemID());
		info.put(ACTIVE_PARTICIPATOR, context.getActiveParticipator());
		info.put(UPDATE_CHECKER_FIELD, context.updateCheckerField());
		TransitData transitData = context.getTransitData();
		if (transitData != null) {
			JSONObject transitInfo = new JSONObject();
			transitInfo.put(WORKITEMID, transitData.getWorkitemID());
			transitInfo.put(NODEID, transitData.getNodeID());
			transitInfo.put(KEEPPARTS, transitData.keepParts());
			info.put(TRANSITDATA, transitInfo.toString());
		}
		return info;
	}
	/**
	 * 还原上下文信息
	 * @param context 上下文
	 * @param additionInfo 额外的信息
	 * @throws Throwable
	 */
	private static void recoverAdditionInfo(BPMContext context, JSONObject info)throws Throwable{
		if (info == null) {
			return;
		}
		if (info.has(OPERATIONTYPE)) {
			context.setOperationType(info.getInt(OPERATIONTYPE));
		}
		if (info.has(ACTIVE_TOKENID)) {
			context.setActiveTokenID(info.getInt(ACTIVE_TOKENID));
		}
		if (info.has(NEW_WORKITEM_ID)) {
			context.setNewWorkitemID(info.getLong(NEW_WORKITEM_ID));
		}
		if (info.has(ACTIVE_PARTICIPATOR)) {
			context.setActiveParticipator(info.getLong(ACTIVE_PARTICIPATOR));
		}
		if (info.has(UPDATE_CHECKER_FIELD)) {
			context.setUpdateCheckerField(info.getBoolean(UPDATE_CHECKER_FIELD));
		}
		if (info.has(TRANSITDATA)) {
			JSONObject data = info.getJSONObject(TRANSITDATA);
			long workitemID = data.getLong(WORKITEMID);
			int nodeID = data.getInt(NODEID);
			TransitData transitData = new TransitData(nodeID, workitemID);
			boolean keepParts = data.getBoolean(KEEPPARTS);
			transitData.setKeepParts(keepParts);;
			context.setTransitData(transitData);
		}
	}
}
