package com.bokesoft.yigo.bpm.common;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.parser.IExecutor;
/**
 * 流程中间层二次开发函数的抽象基类
 * @author wbh
 *
 */
public abstract class BaseBPMMidFunctionImpl extends BaseMidFunctionImpl {
	/**
	 * 
	 * @param name 函数名
	 * @param context 流程上下文
	 * @param args 参数列表
	 * @param executor 执行器
	 * @return
	 * @throws Throwable
	 */
	public abstract Object evalBPMImpl(String name, BPMContext context, Object[] args, IExecutor executor) throws Throwable;

	@Override
	public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor) throws Throwable {
		if (context instanceof BPMContext) {
			BPMContext bc = (BPMContext) context;
			return evalBPMImpl(name, bc, args, executor);
		}
		throw BPMError.getBPMError(context.getEnv(), BPMError.NO_BPM_CONTEXT, name);
	}
}
