package com.bokesoft.yigo.bpm.analysis;

/**
 * 默认分析模式
 * 
 * @author guowj
 *
 */
public class DefaultAnalysisMode {
	
	public static final int Undefined = -1;
	public static final int Default_InstanceDuration = 1;
	public static final int Default_WorkitemDuration = 2;
	
	public static final String S_Default_InstanceDuration = "InstanceDuration";
	public static final String S_Default_WorkitemDuration = "WorkitemDuration";
	
	public static String toString(int analysisType) {
		String s = null;
		switch (analysisType) {
		case Default_InstanceDuration:
			s = S_Default_InstanceDuration;
			break;
		case Default_WorkitemDuration:
			s = S_Default_WorkitemDuration;
			break;
		}
		return s;
	}
	
	public static int parse(String s) {
		int dbType = DefaultAnalysisMode.Undefined;
		if ( S_Default_InstanceDuration.equalsIgnoreCase(s) ) {
			dbType = Default_InstanceDuration;
		} else if ( S_Default_WorkitemDuration.equalsIgnoreCase(s) ) {
			dbType = Default_WorkitemDuration;
		} 
		return dbType;
	}

}
