package com.bokesoft.yigo.bpm;

import java.util.ArrayList;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.workitem.WorkitemState;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.bpm.workitem.data.WorkitemDataContainer;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 查询流程关联的所有活动工作项集合
 * @author zhanght
 *
 */
public class QueryWorkitemsByInstaceID {

	private long instanceID;
	
	/**
	 * 通过instanceID构建查询类
	 * @param instanceID
	 */
	public QueryWorkitemsByInstaceID(long instanceID) {
		this.instanceID = instanceID;
	}
	
	/**
	 * 查询当前流程实例下所有活动工作项标识
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public ArrayList<Long> query(DefaultContext context) throws Throwable{
		ArrayList<Long> list = new ArrayList<>();
		BPMContext bpmContext = BPMContext.getBPMContext(context,instanceID);
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(bpmContext, instanceID);
		WorkitemDataContainer workitemdata = instance.getInstanceData().getWorkitemData();
		ArrayList<RWorkitem> wlist = workitemdata.getWorkitemList();
		for(RWorkitem rw : wlist){
			if (rw.getWorkitemState() == WorkitemState.NEW) {
				list.add(rw.getWorkItemID());
			}
		}
		return list;
	}
}
