package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.participator.PPUtil;
import com.bokesoft.yes.bpm.meta.transform.InstanceState;
import com.bokesoft.yes.gop.bpm.participator.delegate.ParticipatorData;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.document.Document;

public class CalculateParticipator {
	
	private int nodeID = -1;
	
	private int verID = -1;
	
	public CalculateParticipator(int nodeID){
		this.nodeID = nodeID;
	}
	
	public CalculateParticipator(int nodeID, int verID){
		this(nodeID);
		this.verID = verID;
	}
	
	public void setNodeID(int nodeID) {
		this.nodeID = nodeID;
	}
	
	public int getNodeID() {
		return nodeID;
	}
	
	public void setVerID(int verID) {
		this.verID = verID;
	}
	
	public int getVerID() {
		return verID;
	}
	
	public List<ParticipatorData> calculateParticipator(DefaultContext context) throws Throwable{
		List<ParticipatorData> ppList = null;
		
		Document doc = context.getDocument();
		if (doc == null) {
			return null;
		}
		MetaTable mainTable = doc.getMetaDataObject().getMainTable();
		if (mainTable == null)
			return null;
		MetaColumn ic = mainTable.getINSTANCEIDColumn();
		Long instanceID = -1L;
		Integer instanceState = -1;
		String processKey = "";
		IDBManager dbm = context.getDBManager();
		// 存在INSTANCEID系统字段的情况
		if (ic != null) {
			instanceID = (Long) doc.get(mainTable.getKey()).getObject(0, ic.getKey());
			if (instanceID == null)
				instanceID = -1L;
			if (instanceID > 0) {
				PreparedStatement ps = null;
				ResultSet rs = null;
				try {
					String sql = "select " 
							+ dbm.keyWordEscape(SystemDBField.INSTANCESTATE) + "," 
							+ dbm.keyWordEscape(SystemDBField.PROCESSKEY) 
							+ " from " 
							+ dbm.keyWordEscape(SystemDBField.BPM_INSTANCE) 
							+ " where " 
							+ dbm.keyWordEscape(SystemDBField.INSTANCEID) + "=?";
					ps = context.getDBManager().preparedQueryStatement(sql);
					ps.setLong(1, instanceID);
					rs = ps.executeQuery();
					if (rs.next()) {
						instanceState = rs.getInt(1);
						processKey = rs.getString(2);
						if (instanceState == InstanceState.END || instanceState == InstanceState.KILLED || instanceState == InstanceState.PAUSE)
							return null;
					}
				} finally {
					if (rs != null)
						rs.close();
					if (ps != null)
						ps.close();
				}
			}
		}
		if (instanceID < 0) {
			PreparedStatement ps = null;
			ResultSet rs = null;
			try {
				String sql = "select " 
						+ dbm.keyWordEscape(SystemDBField.INSTANCESTATE) + ","
						+ dbm.keyWordEscape(SystemDBField.INSTANCEID) + ","
						+ dbm.keyWordEscape(SystemDBField.PROCESSKEY )
						+ " from "
						+ dbm.keyWordEscape(SystemDBField.BPM_INSTANCE) 
						+ " where " 
						+ dbm.keyWordEscape(SystemDBField.OID) + "=?";
				ps = context.getDBManager().preparedQueryStatement(sql);
				ps.setLong(1, doc.getOID());
				rs = ps.executeQuery();
				if (rs.next()) {
					instanceState = rs.getInt(1);
					instanceID = rs.getLong(2);
					processKey = rs.getString(3);
					if (instanceState == InstanceState.END || instanceState == InstanceState.KILLED || instanceState == InstanceState.PAUSE)
						return null;
				}
			} finally {
				if (rs != null)
					rs.close();
				if (ps != null)
					ps.close();
			}
		}
		
		if(processKey == null || processKey.length() == 0) {
			return null;
		}
		MetaProcess metaProcess = null;
		if(verID > 0) {
			metaProcess = BPMUtil.getProcessDefinationBy(context.getVE(), processKey, verID);
		}else {
			metaProcess = BPMUtil.getProcessDefinationByDeployKey(context.getVE(), processKey);
		}
		if(metaProcess == null) {
			return null;
		}
		
		BPMContext bpmContext = new BPMContext(context);
		MetaNode metaNode = BPMUtil.getNode(context.getVE(), metaProcess, nodeID);
		if(instanceID < 0){
			return null;
		}
		BPMInstance bpmInstance = BPMInstanceFactory.getBPMInstance(bpmContext, instanceID);
		ExecNode node = null;
		try{
			node = bpmInstance.getNodeByID(-1, nodeID);
		}catch(Throwable e){
			// 如果还未流转到当前节点，构造ExecNode用于计算参与者
			node = bpmInstance.getMainInstance().createNode(metaNode);
		}
		bpmContext.setActiveNode(node);
		
		if(metaNode instanceof MetaUserTask) {
			MetaUserTask userTask = (MetaUserTask)metaNode;
			ppList = PPUtil.calculateParticpator(userTask.getParticipatorCollection(), bpmContext);
		}
		return ppList;
	}
}
