package com.bokesoft.yigo.bpm;

import java.util.Date;

import com.bokesoft.yes.bpm.delegate.DelegateProxy;
import com.bokesoft.yigo.mid.base.DefaultContext;
/**
 * 提供添加一条代理记录的API
 * 若批量添加代理记录，通过循环实现。
 * 供二次开发使用
 * 
 * @author guowj
 *
 */
public class AddDelegateData {
	
	/**
	 * 添加一条代理记录
	 * @param context
	 * @param delegateType 代理类型，int属性，1为授权：目标操作员和当前操作员均可以提交工作项，2为代理：仅目标操作员可以提交工作项
	 * @param srcOperatorID 源操作员
	 * @param tgtOperatorID 目标操作员
	 * @param objectType 代理区域类别，int属性，分别为：1操作员，2流程，3流程节点，4数据对象，5自定义
	 * @param objectKey 对象标识，区域类别为流程时即为流程标识，区域类别为数据对象是即为数据对象标识
	 * @param nodeKey 区域类别为流程节点的流程节点标识
	 * @param startTime 开始时间
	 * @param alwaysValid 代理是否永久有效
	 * @param endTime 结束时间
	 * @param userInfo 代理意见
	 * @throws Throwable
	 */
	public void addDelegateData(DefaultContext context, Integer delegateType, Long srcOperatorID, Long tgtOperatorID, Integer objectType, String objectKey, String nodeKey, Date startTime, boolean alwaysValid, Date endTime,String userInfo) throws Throwable {
		DelegateProxy.addDelegateData(context, delegateType, srcOperatorID, tgtOperatorID, objectType, objectKey, nodeKey, startTime, alwaysValid, endTime,userInfo);
	}
}
