/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.meta.json.MetaProcessJsonSerializer;
import com.bokesoft.yes.meta.json.MetaProcessJsonUnserializer;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.IJsonUnserializer;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.tools.ve.IVEHost;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.json.JSONObject;

public class SaveProcessToDB {
    private MetaProcess metaProcess = null;

    public SaveProcessToDB() {
    }

    public SaveProcessToDB(MetaProcess metaProcess) {
        this.metaProcess = metaProcess;
    }

    public void setProcess(MetaProcess metaProcess) {
        this.metaProcess = metaProcess;
    }

    public MetaProcess getProcess() {
        return this.metaProcess;
    }

    public void save(DefaultContext defaultContext, boolean bl) throws Throwable {
        if (this.metaProcess == null) {
            return;
        }
        this.saveProcess(defaultContext, this.metaProcess, bl);
    }

    public void saveNewVersion(DefaultContext defaultContext) throws Throwable {
        if (this.metaProcess == null) {
            return;
        }
        MetaProcess metaProcess = (MetaProcess)this.metaProcess.clone();
        String string = metaProcess.getKey();
        int n2 = 1;
        PSArgs pSArgs = new PSArgs();
        pSArgs.addStringArg(string);
        IDBManager iDBManager = defaultContext.getDBManager();
        iDBManager.setRowLock("BPM_Process", iDBManager.keyWordEscape("ProcessKey") + "=?", (QueryArguments)pSArgs);
        int n3 = this.getVersion(defaultContext, string);
        if (n3 > 0) {
            n2 = n3 + 1;
        }
        metaProcess.setVersion(Integer.valueOf(n2));
        this.saveProcess(defaultContext, metaProcess, false);
    }

    private void saveProcess(DefaultContext defaultContext, MetaProcess metaProcess, boolean bl) throws Throwable {
        Object object;
        Object object2;
        String string = metaProcess.getKey();
        String string2 = metaProcess.getCaption();
        int n2 = metaProcess.getVersion();
        String string3 = "";
        if ((metaProcess = new MetaProcessJsonSerializer(metaProcess, (IVEHost)new MidVEHost((IServiceContext)defaultContext)).serialize()) != null) {
            string3 = metaProcess.toString();
        }
        if (!bl && this.checkDeployExist(defaultContext, string, n2)) {
            throw BPMError.getBPMError((ILocale)defaultContext.getEnv(), (int)56, (Object[])new Object[]{string, n2});
        }
        IDBManager iDBManager = defaultContext.getDBManager();
        PreparedStatement preparedStatement = null;
        if (this.checkDBExist(defaultContext, string, n2)) {
            object2 = "update " + iDBManager.keyWordEscape("BPM_Process") + " set " + iDBManager.keyWordEscape("Defination") + "=? where " + iDBManager.keyWordEscape("ProcessKey") + "=? and " + iDBManager.keyWordEscape("WFVerID") + "=?";
            try {
                preparedStatement = iDBManager.preparedUpdateStatement((String)object2);
                object = new PSArgs();
                object.addStringArg(string3);
                object.addStringArg(string);
                object.addIntArg(Integer.valueOf(n2));
                iDBManager.executeUpdate(preparedStatement, (String)object2, (QueryArguments)object);
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        object2 = defaultContext.applyNewOID();
        object = "insert into " + iDBManager.keyWordEscape("BPM_Process") + " (" + iDBManager.keyWordEscape("ProcessKey") + "," + iDBManager.keyWordEscape("WFVerID") + "," + iDBManager.keyWordEscape("Caption") + "," + iDBManager.keyWordEscape("Defination") + "," + iDBManager.keyWordEscape("AlreadyDeploy") + "," + iDBManager.keyWordEscape("OID") + ") values (?,?,?,?,?,?)";
        try {
            preparedStatement = iDBManager.preparedUpdateStatement((String)object);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg(string);
            pSArgs.addIntArg(Integer.valueOf(n2));
            pSArgs.addStringArg(string2);
            pSArgs.addStringArg(string3);
            pSArgs.addIntArg(Integer.valueOf(0));
            pSArgs.addLongArg((Long)object2);
            iDBManager.executeUpdate(preparedStatement, (String)object, (QueryArguments)pSArgs);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        object2 = defaultContext.getVE().getMetaFactory();
        object = new ProcessDefinitionProfile();
        object.setKey(string);
        object.setCaption(string2);
        object.setVersion(n2);
        object.setDefinationJson((JSONObject)metaProcess);
        object.setJsonUnserializer((IJsonUnserializer)new MetaProcessJsonUnserializer());
        object.setSourceType("DB");
        object2.getMetaBPM().getProfileMap().put(string + "_V" + n2, object);
    }

    private int getVersion(DefaultContext object, String string) throws Throwable {
        int n2 = -1;
        IDBManager iDBManager = object.getDBManager();
        String string2 = "select " + iDBManager.keyWordEscape("WFVerID") + " from " + iDBManager.keyWordEscape("BPM_Process") + " where " + iDBManager.keyWordEscape("ProcessKey") + " = ? order by " + iDBManager.keyWordEscape("WFVerID") + " desc";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = iDBManager.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg(string);
            resultSet = iDBManager.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        for (String string3 : object.getVE().getMetaFactory().getMetaBPM().getProfileMap().keySet()) {
            int n3;
            if (!string3.split("_V")[0].equalsIgnoreCase(string) || (n3 = TypeConvertor.toInteger((Object)string3.split("_V")[1]).intValue()) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private boolean checkDeployExist(DefaultContext defaultContext, String string, int n2) throws Throwable {
        IDBManager iDBManager = defaultContext.getDBManager();
        String string2 = "select " + iDBManager.keyWordEscape("AlreadyDeploy") + " from " + iDBManager.keyWordEscape("BPM_Process") + " where " + iDBManager.keyWordEscape("ProcessKey") + " = ? and " + iDBManager.keyWordEscape("WFVerID") + " = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = iDBManager.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg(string);
            pSArgs.addIntArg(Integer.valueOf(n2));
            resultSet = iDBManager.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            if (resultSet.next() && resultSet.getInt(1) == 1) {
                return true;
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        defaultContext = defaultContext.getVE().getMetaFactory().getMetaBPM();
        return defaultContext.getMetaBPMDeployInfoCollection().containsKey(string) && n2 == ((MetaProcessDeployInfo)defaultContext.getMetaBPMDeployInfoCollection().get(string)).getVersion();
    }

    private boolean checkDBExist(DefaultContext defaultContext, String string, int n2) throws Throwable {
        defaultContext = defaultContext.getDBManager();
        String string2 = "select * from " + defaultContext.keyWordEscape("BPM_Process") + " where " + defaultContext.keyWordEscape("ProcessKey") + " = ? and " + defaultContext.keyWordEscape("WFVerID") + " = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = defaultContext.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg(string);
            pSArgs.addIntArg(Integer.valueOf(n2));
            resultSet = defaultContext.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                return true;
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return false;
    }
}

