/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.engine.common.StatusUtil;
import com.bokesoft.yes.bpm.engine.data.row.REventLog;
import com.bokesoft.yes.bpm.engine.data.row.RInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.util.SysTopicUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.Timestamp;

public class ReviveInstanceCmd
extends BPMServiceCmd {
    private long instanceID;
    private String userinfo = "";

    public ReviveInstanceCmd() {
    }

    public ReviveInstanceCmd(long l2, String string) {
        this.instanceID = l2;
        this.userinfo = string;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new ReviveInstanceCmd();
    }

    @Override
    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.instanceID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"InstanceID"));
        this.userinfo = TypeConvertor.toString((Object)stringHashMap.get((Object)"userInfo"));
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        bPMContext = BPMContext.getBPMContext(bPMContext, (Long)this.instanceID);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, this.instanceID);
        RInstance rInstance = bPMInstance.getInstanceData().getInstance().getData();
        REventLog rEventLog = new REventLog(this.instanceID);
        rEventLog.setLogID(bPMInstance.getInstanceData().getInstance().applyNewEventID());
        rEventLog.setEventTime(new Timestamp(bPMContext.getDBManager().getCurTime()));
        rEventLog.setActiveType(5);
        rEventLog.setName("\u6062\u590d\u6d41\u7a0b");
        rEventLog.setsOperator(bPMContext.getVE().getEnv().getUserID());
        rEventLog.setUserinfo(this.userinfo);
        bPMInstance.getInstanceData().getEventLog().addRow(rEventLog);
        if (rInstance.getDocState() != -1) {
            int n2 = rInstance.getDocState();
            StatusUtil.changeStatusValue(bPMContext, n2);
            Document document = bPMContext.getDocument();
            SysTopicUtil.assignSysTopic(bPMContext);
            new SaveData(document.getMetaDataObject(), null, document).midLaunchSave((DefaultContext)bPMContext);
            document.setNormal();
            rInstance.setDocState(-1);
        }
        bPMInstance.revive(bPMContext);
        bPMContext.getInstanceDataContainer().save();
        return Boolean.TRUE;
    }

    public void setInstanceID(long l2) {
        this.instanceID = l2;
    }

    public long getInstanceID() {
        return this.instanceID;
    }

    public void setUserinfo(String string) {
        this.userinfo = string;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    @Override
    public String getCmd() {
        return "ReviveInstance";
    }
}

