package com.bokesoft.yigo.bpm.message;

import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;

public class HeadInfo implements JSONSerializable {

	private String id = "";
	private long timestamp = -1l;
	private String tag = "";
	
	public void setId(String id) {
		this.id = id;
	}
	
	public String getId() {
		return id;
	}
	
	public void setTimestamp(long timestamp) {
		this.timestamp = timestamp;
	}
	
	public long getTimestamp() {
		return timestamp;
	}
	
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	public String getTag() {
		return tag;
	}
	
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		json.put("id", id);
		json.put("timestamp", timestamp);
		json.put("tag", tag);
		return json;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		id = jsonObj.optString("id", "");
		timestamp = jsonObj.optLong("timestamp", -1l);
		tag = jsonObj.optString("tag", "");
	}

}
