package com.bokesoft.yigo.bpm.message;

import org.json.JSONObject;

import com.bokesoft.yigo.mq.listener.IMQListener;

public class BPMMessageListener implements IMQListener {

	@Override
	public boolean onMessageReceived(String queue, String message) throws Throwable {
		try {
			JSONObject body = new JSONObject(message);
			
			if (!body.has(MessageConstants.BPM_BASIC)) {
				throw new Exception("not have bpm-basic!");
			}
			//基本信息
			JSONObject basicJson = body.getJSONObject(MessageConstants.BPM_BASIC);
			BasicInfo basicInfo = new BasicInfo();
			basicInfo.fromJSON(basicJson);
			long instanceID = basicInfo.getInstanceID();
			int inlineNodeID = basicInfo.getInlineNodeID();
			int sourceNodeID = basicInfo.getSourceNodeID();
			int targetNodeID = basicInfo.getTargetNodeID();
			if (instanceID <= 0 || sourceNodeID <= 0) {
				throw new Exception("invalid instanceID or nodeID!");
			}
			if (targetNodeID <= 0) {
				throw new Exception("not have targetNodeID!");
			}
			
			String usrMsg = body.optString(MessageConstants.USER_MSG);
			MessageReceiveImpl mrImpl = new MessageReceiveImpl(instanceID, inlineNodeID, targetNodeID);
			mrImpl.receiveMessage(usrMsg);
			return true;
		}catch(Throwable e) {
			e.printStackTrace();
			return false;
		}
		
	}
	
}
