package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemState;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class TransferTask {

	private Long workitemID;

	private Long operatorID;

	private boolean createRecord;
	
	private String userinfo;
	
	private int auditResult;
	
	private long srcOperator;
	
	private int transferType;
	
	public TransferTask() {
	}
	
	/**
	 * 获取工作项标识
	 * @return
	 */
	public Long getWorkitemID() {
		return workitemID;
	}

	/**
	 * 设置工作项标识
	 * @param workitemID
	 */
	public void setWorkitemID(Long workitemID) {
		this.workitemID = workitemID;
	}

	/**
	 * 获取操作员ID
	 * @return
	 */
	public Long getOperatorID() {
		return operatorID;
	}

	/**
	 * 设置操作员ID
	 * @param operatorID
	 */
	public void setOperatorID(Long operatorID) {
		this.operatorID = operatorID;
	}

	/**
	 * 是否创建单独记录
	 * @return
	 */
	public boolean isCreateRecord() {
		return createRecord;
	}

	/**
	 * 设置是否创建单独记录
	 * @param createRecord
	 */
	public void setCreateRecord(boolean createRecord) {
		this.createRecord = createRecord;
	}

	/**
	 * 获取用户信息
	 * @return
	 */
	public String getUserinfo() {
		return userinfo;
	}

	/**
	 * 设置用户信息
	 * @param userinfo
	 */
	public void setUserinfo(String userinfo) {
		this.userinfo = userinfo;
	}

	/**
	 * 获取审批结果
	 * @return
	 */
	public int getAuditResult() {
		return auditResult;
	}

	/**
	 * 设置审批结果
	 * @param auditResult
	 */
	public void setAuditResult(int auditResult) {
		this.auditResult = auditResult;
	}

	/**
	 * 获取源操作员ID
	 * @return
	 */
	public long getSrcOperator() {
		return srcOperator;
	}

	/**
	 * 设置源操作员ID
	 * @param srcOperator
	 */
	public void setSrcOperator(long srcOperator) {
		this.srcOperator = srcOperator;
	}

	/**
	 * 获取自定义转交类型
	 * @return
	 */
	public int getTransferType() {
		return transferType;
	}

	/**
	 * 设置自定义转交类型
	 * @param transferType
	 */
	public void setTransferType(int transferType) {
		this.transferType = transferType;
	}
	
	/**
	 * 转交一个任务到指定操作员
	 * @param context
	 * @param workitemID
	 * @param userinfo
	 * @throws Throwable
	 */
	public void transferTask(DefaultContext context, long workitemID, String userinfo) throws Throwable {
		if (!(context instanceof BPMContext)) {
			return;
		}
		BPMContext bpmContext = (BPMContext)context;
		Workitem workitem = WorkitemUtil.loadWorkitem(bpmContext, workitemID);
		if (workitem == null)
			return;
		bpmContext = BPMContext.getBPMContext(bpmContext, workitem.getInstanceID());
		long optID = srcOperator > 0?srcOperator:bpmContext.getCurUserID();
		bpmContext.setUpdateWorkitem(workitem);
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(bpmContext, workitem.getInstanceID());
		if (null == instance)
			throw BPMError.getBPMError(context.getEnv(), BPMError.NO_INSTANCE_DATA);
		String processKey = bpmContext.getProcesskey();
		int verID = bpmContext.getVerID();
		if (!workitem.getParticipatorList().contains(optID) && !ProcessUtil.isProcessAdministrator(bpmContext, optID, processKey, verID)) {
			throw BPMError.getBPMError(context.getEnv(), BPMError.COMMIT_RIGHT_ERROR);
		}
		if (createRecord) {
			workitem.setWorkItemState(WorkitemState.FINISH);
			workitem.setAuditResult(auditResult);
			workitem.setUserInfo(userinfo);
		} else {
			workitem.setWorkItemState(WorkitemState.NEW);
		}
		workitem.setTransferType(transferType);
		
		bpmContext.setSrcOperator(srcOperator);
		ExecNode node = instance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID());
		node.transferTask(bpmContext, operatorID, createRecord);
		
		bpmContext.getInstanceDataContainer().save();
	}
}
