package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.engine.common.StatusUtil;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.meta.transform.InstanceState;
import com.bokesoft.yes.bpm.util.SysTopicUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.track.TrackDetail;

/**
 * 结束流程,不另起独立事务
 * @author wbh
 *
 */
public class EndInstance {
	
	/**
	 * 给定流程实例ID，结束流程
	 * @param context 中间层上下文
	 * @param instanceID 流程实例ID，不允许为-1
	 * @return 操作是否成功
	 * @throws Throwable
	 */
	public boolean endInstanceByInstanceID(DefaultContext context, long instanceID)throws Throwable {
		BPMContext bpmContext = BPMContext.getBPMContext(context, instanceID);
		BPMInstance instance = BPMInstanceFactory.getBPMInstance(bpmContext, instanceID);
		bpmContext.setActiveBPMInstance(instance);
		return end(bpmContext, instance,context.getDocument());
	}
	/**
	 * 给定单据OID，结束流程
	 * @param context 中间层上下文
	 * @param oid 单据OID，不允许为-1
	 * @return 操作是否成功
	 * @throws Throwable
	 */
	public boolean endInstanceByOID(DefaultContext context, long oid)throws Throwable{
		BPMContext bpmContext = new BPMContext(context);
		BPMInstance instance = BPMInstanceFactory.getBPMInstanceByOID(bpmContext, oid, true);
		bpmContext.setActiveBPMInstance(instance);
		//这里应该从defaultcontext中获取document,因为bpmcontext中可能无doc
		return end(bpmContext, instance,context.getDocument());
	}
	
	private boolean end(BPMContext bpmContext, BPMInstance instance, Document doc)throws Throwable{
		if (instance == null) {
			return false;
		}
		
		//只有运行或暂停状态下的流程才能结束
		if (bpmContext.getInstanceState() != InstanceState.PROCESSING && bpmContext.getInstanceState() != InstanceState.PAUSE) {
			return false;
		}
		
		//中间层保存不执行
		if (doc.getDocumentTrack().contains(TrackDetail.MID_SAVE, "") ) {
			return false;
		}
		
		//保存结束前的单据状态，便于复活流程时正确设置单据状态
		MetaTable table = doc.getMetaDataObject().getMainTable();
		MetaColumn statusColumn = table.getSTATUSColumn();
		Integer oldValue = (Integer)doc.get(table.getKey()).getObject(0, statusColumn.getKey());
		instance.getInstanceData().getInstance().getData().setDocState(oldValue);
		
		//结束流程
		MetaEnd end = instance.end(bpmContext);
		
		if (end != null && end.getStatus().length() > 0) {
			//修改单据状态，立即保存
			StatusUtil.changeStatusValue(bpmContext, end.getStatus());
			SysTopicUtil.assignSysTopic(bpmContext);
			SaveData save = new SaveData(doc.getMetaDataObject(), null, doc);
			save.midLaunchSave(bpmContext);
			doc.setNormal();
		}
		
		bpmContext.getInstanceDataContainer().save();
		return true;
	}
	
}
