package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.meta.transform.InstanceState;
import com.bokesoft.yes.bpm.rights.BPMRightsUtil;
import com.bokesoft.yes.bpm.schema.PermInfo;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.bpm.dev.Spoon;
import com.bokesoft.yigo.bpm.dev.Template;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaPermConfiguration;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.base.RightsContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.rights.RightsObject;
import com.bokesoft.yigo.struct.datatable.DataTable;

/**
 * 默认的流程权限载入类
 * @author 陈瑞
 *
 */
public class DefaultBPMRightsLoader {
	
	public RightsObject loadRights(RightsContext context) throws Throwable {

		// 加载表单流程绑定映射
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaPermConfiguration permConfiguration = context.getVE().getMetaFactory().getPermConfiguration();
		MetaSetting solutionSetting = metaFactory.getSetting();
		MetaBPMSetting setting = solutionSetting != null ? solutionSetting.getBPMSetting() : null;
		if (setting != null && setting.getRecordFormRights()) {
			// 从序时簿打开时也需加载工作流权限    merge.erp.revision:59073
			if(context.getWorkitemID().compareTo(0L) <= 0){
				this.getWorkItemID(context);
			}
			
			MetaProcessMap map = BPMRightsUtil.getProcessMap(context);
			if (map == null)
				return null;

			// 判断流程状态
			loadInstanceInfo(context);

			MetaPerm perm = null;
			MetaProcess process = null;
			// 如果当前表单为新增单据
			if (instanceState == -1) {
				perm = BPMRightsUtil.getInitiatorPerm(context, BPMUtil.getProcessDefinationByMapInfo(context, map), permConfiguration);
			} else if (instanceState == InstanceState.SIGN) {
				Workitem workitem = null;
				if (context.getWorkitemID() > 0) {
					workitem = WorkitemUtil.loadWorkitem(context, context.getWorkitemID());
				} else {
					return null;
				}
				process = metaFactory.getProcessDefinationBy(processKey, version);
				if(workitem.getInlineNodeID() > 0){
					MetaInline inlineNode = (MetaInline) BPMUtil.getNode(context.getVE(), process, workitem.getInlineNodeID());
					String inlineProcessKey = BPMUtil.getInlineProcessKey(inlineNode, context, workitem.getInstanceID());
					process = BPMUtil.getProcessDefinationByDeployKey(context.getVE(), inlineProcessKey);
				}
				if (process == null) {
					return null;
				}

				MetaNode node = null;
				if (workitem != null) {
					node = process.getNodeByID(workitem.getNodeID());
					if (node == null)
						return null;
				}
				if (node instanceof MetaBegin) {
					perm = BPMRightsUtil.getInitiatorPerm(context, BPMUtil.getProcessDefinationByMapInfo(context, map), permConfiguration);
				} else if (node instanceof MetaUserTask) {
					perm = BPMRightsUtil.getNodePerm(context, process, permConfiguration, node.getKey());

					Template template = BPMUtil.getTemplate(context.getVE());
					if (template != null) {
						Spoon sp = new Spoon();
						if(workitem.getInlineNodeID() > 0){
							context.setIsInline(true);
						}
						MetaPerm pperm = template.getPerm(context, process, node, sp);
						if (sp.isMarked()) {
							perm = pperm;
						}
					}
				}
			} else if (instanceState == InstanceState.PROCESSING || instanceState == InstanceState.PAUSE) {
				Workitem workitem = null;
				if (context.getWorkitemID() > 0) {
					workitem = WorkitemUtil.loadWorkitem(context, context.getWorkitemID());
				} else {
					return null;
				}

				process = metaFactory.getProcessDefinationBy(processKey, version);
				if(workitem.getInlineNodeID() > 0){
					MetaInline inlineNode = (MetaInline) BPMUtil.getNode(context.getVE(), process, workitem.getInlineNodeID());
					String inlineProcessKey = BPMUtil.getInlineProcessKey(inlineNode, context, workitem.getInstanceID());
					process = BPMUtil.getProcessDefinationByDeployKey(context.getVE(), inlineProcessKey);
				}
				if (process == null) {
					return null;
				}

				MetaNode node = process.getNodeByID(workitem.getNodeID());
				if (node == null || !(node instanceof MetaUserTask))
					return null;
				perm = BPMRightsUtil.getNodePerm(context, process, permConfiguration, node.getKey());

				Template template = BPMUtil.getTemplate(context.getVE());
				if (template != null) {
					Spoon sp = new Spoon();
					if(workitem.getInlineNodeID() > 0){
						context.setIsInline(true);
					}
					MetaPerm pperm = template.getPerm(context, process, node, sp);
					if (sp.isMarked()) {
						perm = pperm;
					}
				}
			} else {
				return null;
			}
			if (perm == null)
				return null;

			PermInfo info = BPMRightsUtil.getPerm(perm);
			RightsObject rights = null;
			if (info != null && !info.isEmpty()) {
				rights = new RightsObject(context.getFormKey());
				rights.addOptRights(info.getOptList());
				rights.addVisibleRights(info.getVisibleList());
				rights.addEnableRights(
						BPMRightsUtil.convertRights(context, context.getFormKey(), info.getEnableList()));
				rights.setNeedCache(false);
			}
			return rights;
		} else {
			return null;
		}
	}
	
	private void getWorkItemID(RightsContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(context.getFormKey());
		MetaDataSource dataSource = metaForm.getDataSource();
		if(dataSource == null || context.getDocument() == null){
			return;
		}
		MetaDataObject dataObject = null;
		if(dataSource.isRefObject()){
			dataObject = metaFactory.getDataObject(dataSource.getRefObjectKey());
		}else{
			dataObject = dataSource.getDataObject();
		}
		context.getDocument().setMetaDataObject(dataObject);
		
		boolean hasBPMProcess = BPMUtil.checkBPMProcess(context);
		if(hasBPMProcess){
			Long userID = context.getEnv().getUserID();
			IDBManager dbm = context.getDBManager();
			String sql = "select "
					+ dbm.keyWordEscape(SystemDBField.WF_WORKITEM) + "." + dbm.keyWordEscape(SystemDBField.WORKITEMID)
					+ " as workItemID from "
					+ dbm.keyWordEscape(SystemDBField.WF_WORKITEM)
					+ " join "
					+ dbm.keyWordEscape(SystemDBField.WF_PARTICIPATOR)
					+ " on "
					+ dbm.keyWordEscape(SystemDBField.WF_WORKITEM) + "." + dbm.keyWordEscape(SystemDBField.WORKITEMID)
					+ "="
					+ dbm.keyWordEscape(SystemDBField.WF_PARTICIPATOR) + "." + dbm.keyWordEscape(SystemDBField.WORKITEMID)
					+ " join "
					+ dbm.keyWordEscape(SystemDBField.BPM_LOG)
					+ " on "
					+ dbm.keyWordEscape(SystemDBField.WF_WORKITEM) + "." + dbm.keyWordEscape(SystemDBField.WORKITEMID)
					+ "="
					+ dbm.keyWordEscape(SystemDBField.BPM_LOG) + "." + dbm.keyWordEscape(SystemDBField.WORKITEMID)
					+ " join "
					+ dbm.keyWordEscape(SystemDBField.BPM_INSTANCE)
					+ " on "
					+ dbm.keyWordEscape(SystemDBField.BPM_LOG) + "." + dbm.keyWordEscape(SystemDBField.INSTANCEID)
					+ "="
					+ dbm.keyWordEscape(SystemDBField.BPM_INSTANCE) + "." + dbm.keyWordEscape(SystemDBField.INSTANCEID)
					+ " where "
					+ dbm.keyWordEscape(SystemDBField.WF_PARTICIPATOR) + "." + dbm.keyWordEscape(SystemDBField.OPERATORID)
					+ "=? and "
					+ dbm.keyWordEscape(SystemDBField.WF_WORKITEM) + "." + dbm.keyWordEscape(SystemDBField.WORKITEMSTATE)
					+ "=? and "
					+ dbm.keyWordEscape(SystemDBField.BPM_INSTANCE) + "." + dbm.keyWordEscape(SystemDBField.OID)
					+ " = ? and "
					+ dbm.keyWordEscape(SystemDBField.BPM_INSTANCE) + "." + dbm.keyWordEscape(SystemDBField.FORMKEY)
					+ " = ?";

			List<Object> params = new ArrayList<>();
			params.add(userID);
			params.add(1);
			params.add(context.getOID());
			params.add(context.getFormKey());

			DataTable dataTable = context.getDBManager().execPrepareQuery(sql, params);
			if (dataTable != null && dataTable.size() > 0) {
				Long workItemID = dataTable.getLong(0, "workItemID");
				if(workItemID.compareTo(0L)>0){
					context.setWorkitemID(workItemID);
				}
			}
		}
	}


	private String processKey = null;
	private int version = -1;
	private int instanceState = -1;
	/**
	 * 加载流程的部分信息
	 * @param context
	 * @throws Throwable
	 */
	private void loadInstanceInfo(RightsContext context)throws Throwable{
		long OID = context.getOID();
		IDBManager dbm = context.getDBManager();
		String sql = "select " 
				+ dbm.keyWordEscape(SystemDBField.INSTANCESTATE) + "," 
				+ dbm.keyWordEscape(SystemDBField.WF_VERID) + "," 
				+ dbm.keyWordEscape(SystemDBField.PROCESSKEY)
				+ " from " 
				+ dbm.keyWordEscape(SystemDBField.BPM_INSTANCE) 
				+ " where " 
				+ dbm.keyWordEscape(SystemDBField.OID) + "=?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		IDBManager db = context.getDBManager();
		try{
			ps = db.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addLongArg(OID);
			rs = db.executeQuery(ps, sql, args);
			if(rs.next()) {
				instanceState = rs.getInt(1);
				version = rs.getInt(2);
				processKey = rs.getString(3);
			}
		} finally {
			if (ps != null) {
				ps.close();
			}
			if (rs != null) {
				rs.close();
			}
		}
	}
	
}
