package com.bokesoft.yes.bpm.extend.service;

import org.json.JSONObject;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.meta.transform.PPObject;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemState;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.util.TypeConvertor;

public class LaunchTaskCmd extends BPMServiceCmd {

	public static final String TAG = "LaunchTask";

	private long workitemID;

	private String nodeKey;

	private PPObject ppObject;

	private String launchInfo;

	private boolean hideActiveWorkitem;

	public LaunchTaskCmd(Long WID, String nodeKey, PPObject ppObject, String launchInfo, boolean hideActiveWorkitem) {
		workitemID = WID;
		this.nodeKey = nodeKey;
		this.ppObject = ppObject;
		this.launchInfo = launchInfo;
		this.hideActiveWorkitem = hideActiveWorkitem;
	}

	public LaunchTaskCmd() {
	}

	@Override
	public void dealArguments(BPMContext context, StringHashMap<Object> arguments) throws Throwable {
		workitemID = TypeConvertor.toLong(arguments.get("WorkitemID"));
		nodeKey = (String) arguments.get("NodeKey");
		launchInfo = (String) arguments.get("LaunchInfo");
		hideActiveWorkitem = TypeConvertor.toBoolean(arguments.get("HideActiveWorkitem"));
		ppObject = new PPObject();
		ppObject.fromJSON(new JSONObject(arguments.get("PPObject").toString()));
	}

	public String getCmd() {
		return "";
	}

	@Override
	public Object doCmd(BPMContext context) throws Throwable {

		Workitem workitem = WorkitemUtil.loadWorkitem(context, workitemID);
		if (workitem == null)
			return "";
		if (hideActiveWorkitem) {
			workitem.setWorkItemState(WorkitemState.HIDE);
			workitem.setHideActiveWorkitem(hideActiveWorkitem);
		}else
			workitem.setWorkItemState(WorkitemState.NEW);
		workitem.setLaunchInfo(launchInfo);
		
		context = BPMContext.getBPMContext(context, workitem.getInstanceID());
		
		context.setUpdateWorkitem(workitem);

		BPMInstance instance = BPMInstanceFactory.getBPMInstance(context, workitem.getInstanceID());
		if (instance != null) {
			ExecNode node = instance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID());
			if (node instanceof ExecUserTask) {
				ExecUserTask eut = (ExecUserTask) node;
				eut.launchTask(context, workitemID, nodeKey, ppObject);
			}
		}

		context.getInstanceDataContainer().save();
		JSONObject result = new JSONObject();
		result.put("result", true);
		return result;
	}

	@Override
	public IServiceCmd<BPMContext> newInstance() {
		return new LaunchTaskCmd();
	}

}
