package com.bokesoft.yes.bpm.meta.transform.graph;

import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.bpm.meta.transform.elements.ElementState;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMAnchor;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMAssociation;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMAudit;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMBegin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMBranchEnd;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMComplexJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMCountersign;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMDataMap;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMDecision;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMEnd;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMEvent;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMExceptionFlow;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMExclusiveFork;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMExclusiveJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMFork;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMInline;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMManualTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMessageReceive;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMessageSend;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMultiAudit;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMultiUserTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMNode;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMObject;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMSequenceFlow;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMServiceTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMState;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMStateAction;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMSubProcess;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMSwimline;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMTimer;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMTransition;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMUserTask;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineSize;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.NodeType;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;

public class BPMCompleteGraphConvertor {

	public BPMCompleteGraphConvertor() {
		// TODO Auto-generated constructor stub
	}
	
	public JSONObject toJSON(MetaProcess definition, TransBPMPath transBPMPath) throws Throwable {
		JSONObject json = new JSONObject();
		json.put(TransBPMGraph.tag_key, definition.getKey());
		json.put(TransBPMGraph.tag_caption, definition.getCaption());
		json.put(TransBPMGraph.tag_version, definition.getVersion());
		if ( !definition.isEmpty() ) {
			JSONArray jsonArray = new JSONArray();
			JSONArray jsonArraySwims = new JSONArray();
			Iterator<Entry<String, MetaNode>> it = definition.entryIterator();
			MetaSwimlineCollection swimlineCollection = definition.getSwimlineCollection();
			Iterator<Entry<String, MetaSwimline>> swimIt = swimlineCollection.entryIterator();
			Entry<String, MetaNode> entry = null;
			MetaNode node = null;
			Entry<String, MetaSwimline> swim_entry = null;
			MetaSwimline swimLine = null;
			while ( it.hasNext() ) {
				entry = it.next();
				node = entry.getValue();
				jsonArray.put(node2JSON(node,transBPMPath));
			}
			while ( swimIt.hasNext() ) {
				swim_entry = swimIt.next();
				swimLine = swim_entry.getValue();
				jsonArraySwims.put(swim2JSON(swimLine));
			}
			json.put(TransBPMGraph.tag_nodes, jsonArray);
			json.put(TransBPMGraph.tag_swims, jsonArraySwims);
			if (transBPMPath != null) {
				json.put("transpath", transBPMPath.toJSON());
			}
		}
		return json;
	}
	
	private JSONObject transition2JSON(MetaNode node, MetaTransition transition, TransBPMPath transBPMPath) {
		JSONObject json = new JSONObject();
		MetaTransitionGraphic graph = transition.getGraphic();
		json.put(TransBPMObject.tag_id, transition.getID());
		json.put(TransBPMObject.tag_key, transition.getKey());
		json.put(TransBPMTransition.tag_line_style, graph.getLineStyle());
		json.put(TransBPMTransition.tag_target_node_key, transition.getTargetNodeKey()); 
		json.put(TransBPMNode.tag_style, graph.getStyle());
		if(transition.getTargetNode() != null) {
			json.put(TransBPMTransition.tag_target_node_id, transition.getTargetNode().getID());
			if (transBPMPath != null && transBPMPath.containPath(node.getID(), transition.getTargetNode().getID())) {
				json.put(TransBPMObject.tag_state, ElementState.INPATH);
			}
		}
		if ( transition instanceof MetaAssociation ) {
			json.put(TransBPMObject.tag_tag_name, TransBPMAssociation.TAG_NAME);
		} else if ( transition instanceof MetaExceptionFlow ) {
			json.put(TransBPMObject.tag_tag_name, TransBPMExceptionFlow.TAG_NAME);
		} else if ( transition instanceof MetaSequenceFlow ) {
			json.put(TransBPMObject.tag_tag_name, TransBPMSequenceFlow.TAG_NAME);
		}
		return json;
	}
	
	private JSONObject node2JSON(MetaNode node, TransBPMPath transBPMPath) {
		JSONObject json = new JSONObject();
		json.put(TransBPMObject.tag_id, node.getID());
		json.put(TransBPMObject.tag_key, node.getKey());
		
		MetaNodeGraphic graph = node.getNodeGraphic();
		json.put(TransBPMNode.tag_x, graph.getX());
		json.put(TransBPMNode.tag_y, graph.getY());
		json.put(TransBPMNode.tag_width, graph.getWidth());
		json.put(TransBPMNode.tag_height, graph.getHeight());
		json.put(TransBPMNode.tag_image, graph.getImage());
		json.put(TransBPMNode.tag_pastimage, graph.getPastImage());
		json.put(TransBPMNode.tag_lastimage, graph.getLastImage());
		json.put(TransBPMNode.tag_caption, node.getCaption());
		json.put(TransBPMNode.tag_style, graph.getStyle());
//		json.put(TransBPMNode.tag_inpath, transBPMPath.getLast().contains(node.getID()));
		if (transBPMPath != null && transBPMPath.getLast().contains(node.getID())) {
			json.put(TransBPMObject.tag_state, ElementState.LAST);
		}
		
		int nodeType = node.getNodeType();
		switch ( nodeType ) {
		case NodeType.BEGIN:
			json.put(TransBPMObject.tag_tag_name, TransBPMBegin.TAG_NAME);
			break;
		case NodeType.END:
			json.put(TransBPMObject.tag_tag_name, TransBPMEnd.TAG_NAME);
			break;
		case NodeType.USER_TASK:
			json.put(TransBPMObject.tag_tag_name, TransBPMUserTask.TAG_NAME);
			break;
		case NodeType.AUDIT:
			json.put(TransBPMObject.tag_tag_name, TransBPMAudit.TAG_NAME);
			break;
		case NodeType.COUNTERSIGN:
			json.put(TransBPMObject.tag_tag_name, TransBPMCountersign.TAG_NAME);
			break;
		case NodeType.DECISION:
			json.put(TransBPMObject.tag_tag_name, TransBPMDecision.TAG_NAME);
			break;
		case NodeType.SUB_PROCESS:
			json.put(TransBPMObject.tag_tag_name, TransBPMSubProcess.TAG_NAME);
			break;
		case NodeType.FORK:
			json.put(TransBPMObject.tag_tag_name, TransBPMFork.TAG_NAME);
			break;
		case NodeType.JOIN:
			json.put(TransBPMObject.tag_tag_name, TransBPMJoin.TAG_NAME);
			break;
		case NodeType.EVENT:
			json.put(TransBPMObject.tag_tag_name, TransBPMEvent.TAG_NAME);
			break;
		case NodeType.STATE:
			json.put(TransBPMObject.tag_tag_name, TransBPMState.TAG_NAME);
			break;
		case NodeType.TIMER:
			json.put(TransBPMObject.tag_tag_name, TransBPMTimer.TAG_NAME);
			break;
		case NodeType.INLINE:
			json.put(TransBPMObject.tag_tag_name, TransBPMInline.TAG_NAME);
			break;
		case NodeType.DATAMAP:
			json.put(TransBPMObject.tag_tag_name, TransBPMDataMap.TAG_NAME);
			break;
		case NodeType.COMPLEX_JOIN:
			json.put(TransBPMObject.tag_tag_name, TransBPMComplexJoin.TAG_NAME);
			break;
		case NodeType.MANUAL_TASK:
			json.put(TransBPMObject.tag_tag_name, TransBPMManualTask.TAG_NAME);
			break;
		case NodeType.EXCLUSIVE_FORK:
			json.put(TransBPMObject.tag_tag_name, TransBPMExclusiveFork.TAG_NAME);
			break;
		case NodeType.SERVICE_TASK:
			json.put(TransBPMObject.tag_tag_name, TransBPMServiceTask.TAG_NAME);
			break;
		case NodeType.BRANCH_END:
			json.put(TransBPMObject.tag_tag_name, TransBPMBranchEnd.TAG_NAME);
			break;
		case NodeType.STATE_ACTION:
			json.put(TransBPMObject.tag_tag_name, TransBPMStateAction.TAG_NAME);
			break;
		case NodeType.MULTI_USER_TASK:
			json.put(TransBPMObject.tag_tag_name, TransBPMMultiUserTask.TAG_NAME);
			break;
		case NodeType.MULTI_AUDIT:
			json.put(TransBPMObject.tag_tag_name, TransBPMMultiAudit.TAG_NAME);
			break;
		case NodeType.MESSAGE_SEND:
			json.put(TransBPMObject.tag_tag_name, TransBPMMessageSend.TAG_NAME);
			break;
		case NodeType.MESSAGE_RECEIVE:
			json.put(TransBPMObject.tag_tag_name, TransBPMMessageReceive.TAG_NAME);
			break;
		case NodeType.ANCHOR:
			json.put(TransBPMObject.tag_tag_name, TransBPMAnchor.TAG_NAME);
			break;
		case NodeType.EXCLUSIVE_JOIN:
			json.put(TransBPMObject.tag_tag_name, TransBPMExclusiveJoin.TAG_NAME);
			break;
		}
		json.put("nodeType", nodeType);
		
		MetaTransitionCollection transitions = node.getTransitionCollection();
		if ( transitions != null && !transitions.empty() ) {
			JSONArray jsonArray = new JSONArray();
			Iterator<MetaTransition> it = transitions.iterator();
			MetaTransition transition = null;
			while ( it.hasNext() ) {
				transition = it.next();
				jsonArray.put(transition2JSON(node, transition, transBPMPath));
				if(transBPMPath != null && transition.getTargetNode() != null && transBPMPath.containPath(node.getID(), transition.getTargetNode().getID())) {
					json.put(TransBPMObject.tag_state, ElementState.INPATH);
				}
			}
			json.put(TransBPMNode.tag_transitions, jsonArray);
		}
		
		return json;
	}
	
	private JSONObject swim2JSON(MetaSwimline swim) {
		JSONObject json = new JSONObject();
		json.put(TransBPMObject.tag_id, swim.getID());
		json.put(TransBPMObject.tag_key, swim.getKey());
		MetaSwimlinePosition position = swim.getPosition();
		json.put(TransBPMSwimline.tag_x, position.getX());
		json.put(TransBPMSwimline.tag_y, position.getY());
		MetaSwimlineSize size = swim.getSize();
		json.put(TransBPMSwimline.tag_width, size.getWidth());
		json.put(TransBPMSwimline.tag_height, size.getHeight());
		json.put(TransBPMSwimline.tag_caption, swim.getCaption());
		json.put(TransBPMSwimline.tag_direction, swim.getDirection());
		return json;
	}
}
