package com.bokesoft.yes.bpm.meta.transform.elements;

import java.util.ArrayList;
import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;

public abstract class TransBPMNode extends TransBPMObject {
	/** 节点的X轴坐标 */
	private int x = 0;

	/** 节点的轴坐标 */
	private int y = 0;

	/** 节点的宽度 */
	private int width = 100;

	/** 节点的高度 */
	private int height = 40;
	
	private int nodeType = -1;
	
	/** 节点文本  */
	private String caption = null;
	
	private int elementState = ElementState.NORMAL;
	
	/** 节点用图片显示 */
	private String image = "";
	
	private String lastImage = "";
	
	private String pastImage = "";
	
	private String style = "";
	
	private String tiptop = "";
	
	/** 连接线集合 */
	private ArrayList<TransBPMTransition> transitionArray = null;
	
	public void addTransition(TransBPMTransition transition) {
		if ( this.transitionArray == null ) {
			this.transitionArray = new ArrayList<TransBPMTransition>();
		}
		this.transitionArray.add(transition);
	}
	
	public int getTransitionCount() {
		return this.transitionArray == null ? 0 : this.transitionArray.size();
	}
	
	public TransBPMTransition getTransition(int index) {
		return this.transitionArray.get(index);
	}
	
	public void setX(int x) {
		this.x = x;
	}
	
	public int getX() {
		return this.x;
	}
	
	public void setY(int y) {
		this.y = y;
	}
	
	public int getY() {
		return this.y;
	}
	
	public void setWidth(int width) {
		this.width = width;
	}
	
	public int getWidth() {
		return this.width;
	}
	
	public void setHeight(int height) {
		this.height = height;
	}
	
	public int getHeight() {
		return this.height;
	}
	
	public void setNodeType(int nodeType) {
		this.nodeType = nodeType;
	}
	
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public String getCaption() {
		return this.caption;
	}
	
	public void setImage(String image) {
		this.image = image;
	}
	
	public String getImage() {
		return this.image;
	}
	
	public void setLastImage(String lastImage) {
		this.lastImage = lastImage;
	}
	
	public String getLastImage() {
		return this.lastImage;
	}
	
	public void setPastImage(String pastImage) {
		this.pastImage = pastImage;
	}
	
	public String getPastImage() {
		return this.pastImage;
	}
	
	public void setTiptop(String tiptop) {
		this.tiptop = tiptop;
	}
	
	public String getTiptop() {
		return tiptop;
	}
	
	public void setStyle(String style) {
		this.style = style;
	}
	
	public String getStyle() {
		return style;
	}
	
	public void setElementState(int elementState) {
		this.elementState = elementState;
	}
	
	public int getElementState() {
		return elementState;
	}
	
	
	/**
	 * 取得节点类型
	 * @return 节点类型，由派生类实现
	 */
	public abstract int getNodeType();
	
	public static final String tag_x = "x";
	public static final String tag_y = "y";
	public static final String tag_width = "width";
	public static final String tag_height = "height";
	public static final String tag_caption = "caption";
	public static final String tag_image = "image";
	public static final String tag_pastimage = "image_past";
	public static final String tag_lastimage = "image_last";
//	public static final String tag_inpath = "inpath";
//	public static final String tag_last = "last";
	public static final String tag_tiptop = "tiptop";
	public static final String tag_style = "style";
	public static final String tag_nodetype = "nodeType";
	
	public static final String tag_transitions = "transitions";
	public JSONObject toJSON() throws SerializationException {
		JSONObject json = super.toJSON();
		json.put(tag_x, this.x);
		json.put(tag_y, this.y);
		json.put(tag_width, this.width);
		json.put(tag_height, this.height);
		json.put(tag_caption, this.caption);
//		json.put(tag_inpath, this.inPath);
//		json.put(tag_last, this.last);
		json.put(tag_state, this.elementState);
		json.put(tag_image, this.image);
		json.put(tag_pastimage, this.pastImage);
		json.put(tag_lastimage, this.lastImage);
		json.put(tag_tiptop, this.tiptop);
		json.put(tag_style, this.style);
		json.put(tag_nodetype, this.getNodeType());
		
		if ( this.transitionArray != null ) {
			JSONArray jsonArray = new JSONArray();
			Iterator<TransBPMTransition> it = this.transitionArray.iterator();
			TransBPMTransition transition = null;
			while ( it.hasNext() ) {
				transition = it.next();
				jsonArray.put(transition.toJSON());
			}
			json.put(tag_transitions, jsonArray);
		}
		
		return json;
	}
	
	private TransBPMTransition createTransition(String tagName) {
		TransBPMTransition transition = null;
		if ( TransBPMAssociation.TAG_NAME.equals(tagName) ) {
			transition = new TransBPMAssociation();
		} else if ( TransBPMSequenceFlow.TAG_NAME.equals(tagName) ) {
			transition = new TransBPMSequenceFlow();
		} else if ( TransBPMExceptionFlow.TAG_NAME.equals(tagName) ) {
			transition = new TransBPMExceptionFlow();
		}
		return transition;
	}

	public void fromJSON(JSONObject json) throws SerializationException {
		super.fromJSON(json);
		this.x = json.optInt(tag_x);
		this.y = json.optInt(tag_y);
		this.width = json.optInt(tag_width);
		this.height = json.optInt(tag_height);
		this.caption = json.optString(tag_caption);
//		this.inPath = json.optBoolean(tag_inpath);
//		this.last = json.optBoolean(tag_last);
		if (json.has(tag_state)) {
			this.elementState = json.optInt(tag_state);
		} else {
			this.elementState = ElementState.NORMAL;
		}
		this.image = json.optString(tag_image);
		this.lastImage = json.optString(tag_lastimage);
		this.pastImage = json.optString(tag_pastimage);
		this.tiptop = json.optString(tag_tiptop);
		this.style = json.optString(tag_style);
		this.nodeType = json.optInt(tag_nodetype);
		if ( json.has(tag_transitions) ) {
			JSONArray jsonArray = json.getJSONArray(tag_transitions);
			for ( int i = 0, size = jsonArray.length(); i<size; ++i ) {
				JSONObject tmpJson = jsonArray.getJSONObject(i);
				String tagName = tmpJson.getString(TransBPMObject.tag_tag_name);
				TransBPMTransition transition = this.createTransition(tagName);
				transition.fromJSON(tmpJson);
				this.addTransition(transition);
			}
		}
	}
}
