package com.bokesoft.yes.bpm.meta.transform;

import org.json.JSONObject;

import com.bokesoft.yigo.common.json.JSONSerializable;
/**
 * 流程中人工干预的信息传输结构
 * @author wbh
 *
 */
public class ManualTransferInfo implements JSONSerializable {
	/** 流程实例ID*/
	private long instanceID = -1l;
	/** 工作项ID*/
	private long workitemID = -1l;
	/** 节点ID*/
	private int nodeID = -1;
	/** 嵌入节点的ID */
	private Integer inlineNodeID = -1;
	/** 审批结果*/
	private Integer auditResult = -1;
	/** 审批意见*/
	private String userInfo = "";
	/** 干预者ID*/
	private long srcOperator = -1l;
	/** 转移到的目标节点*/
	private int transferTo = -1;
	/** 是否锁定后继工作项*/
	private boolean lock = true;
	

	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject json = new JSONObject();
		json.put("InstanceID", instanceID);
		json.put("WorkitemID", workitemID);
		json.put("NodeID", nodeID);
		json.put("InlineNodeID", inlineNodeID);
		json.put("AuditResult", auditResult);
		json.put("UserInfo", userInfo);
		json.put("SrcOperator", srcOperator);
		json.put("TransferTo", transferTo);
		json.put("Lock", lock);
		
		return json;
	}

	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		if (jsonObj.has("InstanceID")) {
			instanceID = jsonObj.getLong("InstanceID");
		}
		if (jsonObj.has("WorkitemID")) {
			workitemID = jsonObj.getLong("WorkitemID");
		}
		if (jsonObj.has("NodeID")) {
			nodeID = jsonObj.getInt("NodeID");
		}
		if (jsonObj.has("InlineNodeID")) {
			inlineNodeID = jsonObj.getInt("InlineNodeID");
		}
		if (jsonObj.has("AuditResult")) {
			auditResult = jsonObj.getInt("AuditResult");
		}
		if (jsonObj.has("UserInfo")) {
			userInfo = jsonObj.getString("UserInfo");
		}
		if (jsonObj.has("SrcOperator")) {
			srcOperator = jsonObj.getLong("SrcOperator");
		}
		if (jsonObj.has("TransferTo")) {
			transferTo = jsonObj.getInt("TransferTo");
		}
		if (jsonObj.has("Lock")) {
			lock = jsonObj.getBoolean("Lock");
		}
		

	}

	public long getInstanceID() {
		return instanceID;
	}

	public void setInstanceID(long instanceID) {
		this.instanceID = instanceID;
	}

	public long getWorkitemID() {
		return workitemID;
	}

	public void setWorkitemID(long workitemID) {
		this.workitemID = workitemID;
	}

	public int getNodeID() {
		return nodeID;
	}

	public void setNodeID(int nodeID) {
		this.nodeID = nodeID;
	}

	public Integer getInlineNodeID() {
		return inlineNodeID;
	}

	public void setInlineNodeID(Integer inlineNodeID) {
		this.inlineNodeID = inlineNodeID;
	}

	public Integer getAuditResult() {
		return auditResult;
	}

	public void setAuditResult(Integer auditResult) {
		this.auditResult = auditResult;
	}

	public String getUserInfo() {
		return userInfo;
	}

	public void setUserInfo(String userInfo) {
		this.userInfo = userInfo;
	}

	public long getSrcOperator() {
		return srcOperator;
	}

	public void setSrcOperator(long srcOperator) {
		this.srcOperator = srcOperator;
	}

	public int getTransferTo() {
		return transferTo;
	}

	public void setTransferTo(int transferTo) {
		this.transferTo = transferTo;
	}

	public boolean isLock() {
		return lock;
	}

	public void setLock(boolean lock) {
		this.lock = lock;
	}
	

}
