package com.bokesoft.yes.bpm.meta.transform;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.ItemData;

/**
 * 参与者对象(支持多种形式)，用于传输。
 * 
 * @author 刘翔翔
 *
 */
public class PPObject implements JSONSerializable {

	public static final int LONG = 1;

	public static final int ARRAY = 2;

	public static final int DATATABLE = 3;
	
	public static final String ColumnType = "Type";
	
	public static final String ColumnInfo = "Info";

	public static final String DicOperator = "Operator";
	
	public static final String DicRole = "Role";

	private Integer type = -1;

	private Long operatorID;

	private ArrayList<Long> operatorList = new ArrayList<>();

	private DataTable complexOperatorTable;

	public PPObject() {
	}

	@SuppressWarnings("unchecked")
	public PPObject(Object ppObject) {
		if (ppObject instanceof Long) {
			type = LONG;
			this.operatorID = (Long) ppObject;
		} else if (ppObject instanceof ArrayList<?>) {
			type = ARRAY;
			for(Object item : (ArrayList<?>)ppObject) {
				if (item instanceof Long) {
					this.operatorList.add((Long) item);
				} else if (item instanceof ItemData) {
					this.operatorList.add(((ItemData)item).getOID());
				}
			}
//			this.operatorList = (ArrayList<Long>) ppObject;
		} else if (ppObject instanceof DataTable) {
			type = DATATABLE;
			this.complexOperatorTable = (DataTable) ppObject;
		}else if(ppObject instanceof String) {
			type = ARRAY;
			String[] items = ((String)ppObject).split(",");
			for (String item : items) {
				this.operatorList.add(TypeConvertor.toLong(item));
			}
		}
	}

	@Override
	public void fromJSON(JSONObject js) throws SerializationException {
		type = js.getInt("Type");
		if (type == LONG) {
			operatorID = js.getLong("OperatorID");
		} else if (type == ARRAY) {
			operatorList = new ArrayList<Long>();
			JSONArray ja = js.getJSONArray("OperatorList");
			for (int i = 0; i < ja.length(); i++) {
				operatorList.add(ja.getLong(i));
			}
		} else if (type == DATATABLE) {
			complexOperatorTable = new DataTable();
			complexOperatorTable.fromJSON(js.getJSONObject("ComplexOperatorTable"));
		}
	}

	@Override
	public JSONObject toJSON() throws JSONException, Throwable {
		JSONObject jsonObj = new JSONObject();
		jsonObj.put("Type", type);

		if (type == LONG) {
			jsonObj.put("OperatorID", operatorID);
		} else if (type == ARRAY) {
			JSONArray ja = new JSONArray();
			for (Long i : operatorList)
				ja.put(i);
			jsonObj.put("OperatorList", ja);
		} else if (type == DATATABLE) {
			jsonObj.put("ComplexOperatorTable", complexOperatorTable.toJSON());
		}
		return jsonObj;
	}

	public Integer getType() {
		return type;
	}

	public Long getOperatorID() {
		return operatorID;
	}

	public ArrayList<Long> getOperatorList() {
		return operatorList;
	}

	public DataTable getComplexOperatorTable() {
		return complexOperatorTable;
	}
}
