const path = require('path');
const HtmlWebpackPlugin = require("html-webpack-plugin");

module.exports = {
  mode: 'development',
  //mode: 'production',
  entry: './src/main.ts',
  devtool: 'inline-source-map',
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
      {
        //使用正則表達式規定需要選取的文件类型;
        test: /\.css$/,//选择以.css为后缀的文件
        //提醒自己这里正則表達式不能加引號...
        use: [ 
        /*需要使用的loader,多个用use数组,
          单个用   loader;*/
            "style-loader", "css-loader"
        ]
        //use中loader執行順序是自右向左子下到上
      }
    ]
  },

  
  resolve: {
    extensions: ['.tsx', '.ts'],
  },
  plugins: [
    new HtmlWebpackPlugin({
      template: './src/index.html'
    })
  ],

  externals: {
    jquery: 'jQuery',
    //snapsvg: 'Snap',
    codemirror: "CodeMirror"
  },
  output: {
    filename: 'erp.webplugin.js',
    path: path.resolve(__dirname, '../yigo/yesui-vnode'),
    libraryTarget: "umd",
    library: "webpluginx",
    libraryExport: "default"
  }
};