
import JComponent from "../../../../common/component/JComponent";
import Menu from "../../../../common/component/menu/Menu";
import Events from "../../../../common/event/Events";
import GridUtils from "../util/GridUtils";

/**
 * 表格树操作菜单
 */
export default class GridTreeMenuView {

    private static ACT_AddTreeGridSiblingRow: string = "AddTreeGridSiblingRow";
    private static ACT_AddTreeGridChildRow: string = "AddTreeGridChildRow";
    private static ACT_Delete: string = "Delete";

    private static instance: GridTreeMenuView = new GridTreeMenuView();

    private treeMenu: Menu = new Menu();

    private curGrid: YIUI.Control.Grid | undefined = undefined;

    private constructor() {
        this.installAction(this.treeMenu.addMenuItem(GridTreeMenuView.ACT_AddTreeGridSiblingRow, YIUI.I18N.getString(GridTreeMenuView.ACT_AddTreeGridSiblingRow,"新增行(同级)")));
        this.installAction(this.treeMenu.addMenuItem(GridTreeMenuView.ACT_AddTreeGridChildRow, YIUI.I18N.getString(GridTreeMenuView.ACT_AddTreeGridChildRow,"新增行(子级)")));
    }

    hide(): void {
        this.treeMenu.hide();
    }

    show(grid: YIUI.Control.Grid, left: number, top: number, width: number, height: number, parent: HTMLElement): void {
        if (!this.treeMenu.isShowing()) {
            this.curGrid = grid;
            this.treeMenu.show(left, top, width, height, parent);
        }
    }

    isShowing(grid: YIUI.Control.Grid): boolean {
        return grid == this.curGrid && this.treeMenu.isShowing();
    }

    private installAction(item: JComponent<any>): void {
        item.addEventListener(Events.MouseDown, (event: any) => {
            event = event || window.event;
            var action = item.getKey();
            this.doAction(action);
            this.hide();
        }, true);
    }

    private doAction(action: string): void {
        switch (action) {
            case GridTreeMenuView.ACT_AddTreeGridSiblingRow:
                this.addTreeGridSiblingRow();
                break;
            case GridTreeMenuView.ACT_AddTreeGridChildRow:
                this.addTreeGridChildLeafRow();
                break;
            case GridTreeMenuView.ACT_Delete:
                this.delete();
                break;
        }
    }

    async addTreeGridSiblingRow(): Promise<void> {
        if (!this.curGrid) return;
        var form = GridUtils.getForm(this.curGrid);
        var ctx = new View.Context(form);
        var oldRowIndex = this.curGrid.getFocusRowIndex();
        var oldColIndex = this.curGrid.getFocusColIndex();
        var newRowIndex = await form.eval(`AddTreeGridRow('${this.curGrid.key}', ${oldRowIndex}, false)`, ctx, []);
        newRowIndex = (newRowIndex > -1 ? newRowIndex : oldRowIndex);
        setTimeout(() => {
            this.curGrid && GridUtils.setCellFocus(newRowIndex, oldColIndex, this.curGrid);
        }, 100);
    }

    async addTreeGridChildLeafRow(): Promise<void> {
        if (!this.curGrid) return;
        var form = GridUtils.getForm(this.curGrid);
        var ctx = new View.Context(form);
        var oldRowIndex = this.curGrid.getFocusRowIndex();
        var oldColIndex = this.curGrid.getFocusColIndex();
        var newRowIndex = await form.eval(`AddTreeGridRow('${this.curGrid.key}', ${oldRowIndex}, true)`, ctx, []);
        newRowIndex = (newRowIndex > -1 ? newRowIndex : oldRowIndex);
        setTimeout(() => {
            this.curGrid && GridUtils.setCellFocus(newRowIndex, oldColIndex, this.curGrid);
        }, 100);
    }

    delete(): void {
        if (!this.curGrid) return;
    }

    static getInstance() {
        return GridTreeMenuView.instance;
    }
}