import BpmnDevDesigner from "../component/custom/BpmnDevDesigner";
import BpmnUserDesigner from "../component/custom/BpmnUserDesigner";
import YesCustomDesigner from "../component/custom/YesCustomDesigner";

export default class ComponentUtils {

    static installCustomBuiler(): void {
        ComponentUtils.regCustomBuiler('DevWorkflowDesigner', BpmnDevDesigner);
        ComponentUtils.regCustomBuiler('UserWorkflowDesigner', BpmnUserDesigner);
        ComponentUtils.regCustomBuiler('DataMapDesigner', YesCustomDesigner);
        ComponentUtils.regCustomBuiler('DataMigrationDesigner', YesCustomDesigner);
        ComponentUtils.regCustomBuiler('PrintDesigner', YesCustomDesigner);
        ComponentUtils.regCustomBuiler('ExcelDesigner', YesCustomDesigner);
        ComponentUtils.regCustomBuiler('ExtraLayoutDesigner', YesCustomDesigner);
    }

    static regCustomBuiler(name: string, builder: any): void {
        var yesCustomBuilder = YIUI.BuilderMap.getInstance().get(YIUI.ControlType.CUSTOM);
        if(!yesCustomBuilder) {
            yesCustomBuilder = YIUI.YesCustomBuilder;
        }
        yesCustomBuilder.reg(name, builder);
    }
}