import AbstractDomElement from '../../../../../common/dom/AbstractDomElement';
import {IValueChangedListener } from '../../../../../common/interfaces/Interfaces';
import eDomElement from "../../../dom/component/control/eDomElement";
import yComponent from "../yComponent";

export default abstract class yAbstractControl<E extends AbstractDomElement> extends yComponent<E> {

    private x: number = 0;
    private y: number = 0;
    private xspan: number = 1;
    private yspan: number = 1;

    private value: any;

    private changedLitener?: IValueChangedListener<any, any>;

    constructor(elem: E) {
        super(elem);
    }

    initValue(value: any) {
        this.value = value;
    }

    setValue(value: any) {
        var old = this.value;
        this.value = value;
        if (this.value != old) {
            this.changedLitener && this.changedLitener.fireValueChanged(old, this.value, this);
        }
    }

    getValue() {
        return this.value;
    }

    setValueChangedListener(changedLitener: IValueChangedListener<any, any>): void {
        this.changedLitener = changedLitener;
    }

    setLocationNormal(x: number, y: number, xspan: number = 1, yspan: number = 1): void {
        this.x = x;
        this.y = y;
        this.xspan = xspan;
        this.yspan = yspan;
    }

    setLocation(location: YIUI.ILocation): void {
        this.setLocationNormal(location.x, location.y, location.xSpan, location.ySpan);
    }

    getX(): number {
        return this.x;
    }

    getY(): number {
        return this.y;
    }

    getXSpan(): number {
        return this.xspan;
    }

    getYSpan(): number {
        return this.yspan;
    }

}