import ContainerPanel from "../../../../common/component/container/panel/ContainerPanel";
import Custom from "../../../../common/component/control/Custom";
import TableLayout from "../../../../common/dom/element/TableLayout";
import SizeInfo from "../../../../common/struct/SizeInfo";
import ITagNode from "../../../../common/xml/node/ITagNode";
import AreaHandleControl from "./AreaHandleControl";
import GroupArea from "./GroupArea";

/**
 * 分组区域容器
 */
export default class GroupAreaContainer extends ContainerPanel {

    /** 网格布局定义， 此处只用于定位，不能对其进行修改 */
    private tableLayout: TableLayout;

    private areas: GroupArea[] = [];

    constructor(tableLayout: TableLayout) {
        super();
        this.addClass('group-area-container');
        this.tableLayout =  tableLayout;
        this.addComponent(new Custom(this.tableLayout));
        //this.setHeight(SizeInfo.valueOfPX(this.tableLayout.getHeight()));
        //this.setWidth(SizeInfo.valueOfPX(this.tableLayout.getWidth()));
        this.setStyle("backgroud", "transparent");
        this.setStyle("position", "relative");
        this.setStyle("top", "0px");
        this.setStyle("z-index", "9999");
        this.setStyle("overflow", "auto");
    }

    addGroupArea(area: GroupArea): void {
        this.areas.push(area);
        this.addComponent(area);
        var handle = area.getHandleControl();
        if (handle) {
            this.addComponent(handle);
        }
    }

    removeGroupArea(area: GroupArea): void {
        if (!area) return;
        var index = this.areas.indexOf(area);
        this.removeComponent(area);
        var handleControl = area.getHandleControl();
        if (handleControl) {
            this.removeComponent(handleControl);
        }
        if (index < 0) return;
        this.areas.splice(index, 1);
    }

    remarkAll(): void {
        this.tableLayout.clearMarked();
        for (let area of this.areas) {
            this.tableLayout.markRange(area.getStartRow(), area.getEndRow());
            var handle = area.getHandleControl();
            if (handle) {
                this.tableLayout.markCell(handle.getY(), handle.getX());
            }
        }
    }

    findArea(tagNode: ITagNode): GroupArea | null {
        for (let area of this.areas) {
            if (area.getTagNode() == tagNode) {
                return area;
            }
        }
        return null;
    }

    findHandleControl(tagNode: ITagNode): AreaHandleControl | null {
        for (let area of this.areas) {
            if (area.getHandleControl()?.getTagNode() == tagNode) {
                return area.getHandleControl();
            }
        }
        return null;
    }

    findAreaByRow(row: number): GroupArea | null {
        for (let area of this.areas) {
            if (area.containRow(row)) {
                return area;
            }
        }
        return null;
    }

    hitTagNode(x: number, y: number): ITagNode | null {
        for (let area of this.areas) {
            if (area.containPoint(x, y)) {
                return area.getTagNode();
            }
            var handleControl = area.getHandleControl();
            if (handleControl && handleControl.containPoint(x, y)) {
                return handleControl.getTagNode();
            }
        }
        return null;
    }

    unselectAll(): void {
        for ( let area of this.areas) {
            area.markSelected(false);
            area.getHandleControl()?.markSelected(false);
        }
    }

    isEmpty(): boolean {
        return this.areas.length == 0;
    }
}