import {EDesignMode, ENodeType} from "../../../common/enum/Enums";
import GlobalConstants from "../../../common/struct/GlobalConstants";
import TypeUtil from "../../../common/util/TypeUtil";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import XmlEntity from "../../../common/xml/XmlEntity";
import WfConstants from "../../../design/bpm/base/WfConstants";
import WfDevPropertyDefine from "../../../design/bpm/base/WfDevPropertyDefine";
import {DictionaryTagNode, FormulaTagNode, OperationTagNode} from "../../../design/bpm/base/XmlNodes";
import WfNodeUtil from "../../../design/bpm/util/WfNodeUtil";
import GlobalVariable from "../../../design/GlobalVariable";
import IPropertyItem from "../../../design/plugin/property/base/PropertyDefine";
import RunDictFormula from "../../../design/base/RunDictFormula";
import IWorkSpace from "../../../common/workspace/IWorkSpace";
import XmlEntityUtil from "../../../common/xml/util/XmlEntityUtil";
import AbstractYigoFuns from "../../common/funs/AbstractYigoFuns";
import BPMNWorkSpace from "../../../design/bpm/BPMNWorkSpace";
import PrintConstants from "../../../design/print/base/PrintConstants";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ExcelConstants from "../../../design/excel/base/ExcelConstants";
import ExcelWorkSpace from "../../../design/excel/ExcelWorkSpace";
import BaseConstants from "../../../design/base/BaseConstants";
import SheetView from "../../../design/excel/view/element/SheetView";
import PrintWorkSpace from "../../../design/print/PrintWorkSpace";
import ContentNode from "../../../common/xml/node/ContentNode";
import DataMigrationWorkSpace from "../../../design/datamigration/DataMigrationWorkSpace";
import ISelectable from "../../../common/selection/ISelectable";
import {CommonConstant} from "../../../design/datamap/base/CommonConstant";
import DataMapWorkSpace from "../../../design/datamap/DataMapWorkSpace";
import { CommonFunction } from "../../../design/datamap/base/CommonFunction";
import DataMigrationConstants from "../../../design/datamigration/base/DataMigrationConstants";


/**
 * 将工作流设计器中的公式通过YIGO的方式进行封装，用于配置中调用
 */
export default class YigoDesignFuns extends AbstractYigoFuns {

    protected initFunctions(): void {
        // 更新表格对应的字典节点信息
        this.addFun('UpdateDictionaryNode', this.updateDictionaryNode);
        this.addFun('ParseToOperationXML', this.parseToOperationXML);
        this.addFun('ParseToFormulaXML', this.parseToFormulaXML);
        // 更新表格对应的节点信息
        this.addFun('UpdateNode', this.updateNode);
        // 将版本信息更新到xml中
        this.addFun('UpdateVersionToDesign', this.updateVersionToDesign);
        // 更新设计器中的xml内容到表单控件
        //this.addFun('UpdateDesignXmlToUI', this.updateWorkflowXmlToUI);
        // 获取当前设计界面xml内容
        this.addFun('GetDesignXml', this.getDesignXml);


        // 更新工作流设计器控件中的属性到表单界面
        this.addFun('UpdateWorkflowAttrToUI', this.updateWorkflowAttrToUI);
        // 设置工作流根节点属性
        this.addFun('SetWorkflowAttrValue', this.setWorkflowAttrValue);
        // 获取工作流根节点属性
        this.addFun('GetWorkflowAttrValue', this.getWorkflowAttrValue);
        // 获取当前视图中除当前几点外的所有节点信息，用于列表
        this.addFun('ListWorkflowNodes', this.listWorkflowNodes);
        // 获取选中节点属性值
        this.addFun('GetPropertyValue', this.getPropertyValue);
        this.addFun('GetPropertyValueByCondition', this.getPropertyValueByCondition);

        // 设置选中节点属性值
        this.addFun('SetPropertyValue', this.setPropertyValue);
        this.addFun('SetExcelCellValue', this.setExcelCellValue);
        // 根据Code设置RunDictFormula
        this.addFun('SetPropertyFormulaCode', this.setPropertyFormulaCode);
        // 获取工作流绑定的权限设置表单Key
        this.addFun('GetWorkflowFormKey', this.getWorkflowFormKey);
        // 获取表格中满足某个特定条件的某个单元值
        this.addFun('GetCellValuesByFilter', this.getCellValuesByFilter);
        // 更新选中节点的权限
        this.addFun('UpdatePermNode', this.updatePermNode);

        this.addFun('GetOptPermKeys', this.getOptPermKeys);
        this.addFun('GetEnablePermKeys', this.getEnablePermKeys);
        this.addFun('GetVisiblePermKeys', this.getVisiblePermKeys);

        this.addFun('GetOptPermKeysFromXml', this.getOptPermKeysFromXml);
        this.addFun('GetEnablePermKeysFromXml', this.getEnablePermKeysFromXml);
        this.addFun('GetVisiblePermKeysFromXml', this.getVisiblePermKeysFromXml);
        this.addFun('ConvertPermToXml', this.convertPermToXml);
        this.addFun('GetPermShowText', this.getPermShowText);
        this.addFun('GetPermShowTextFromXml', this.getPermShowTextFromXml);

        this.addFun('GetCollectionShowText', this.getCollectionShowText);
        this.addFun('ParseToRunDictFormula', this.parseToRunDictFormula);
        this.addFun('IsWFUserMode', this.isWFUserMode);

        this.addFun('GetGridSelectedValues', this.getGridSelectedValues);
        //保存迁移设置
        this.addFun('SaveDMTableToXml', this.saveDMTableToXml);

        //获取迁移设置
        this.addFun('GetDMTableXml', this.getDMTableXml);
        //保存参与者到XML对象
        this.addFun('SaveParticipatorToXml', this.saveParticipatorToXml);
        this.addFun('ConvertParticipatorToXml', this.convertParticipatorGridsToXml);
        this.addFun('SaveTimerItemCollectionToXml', this.saveTimerItemCollectionToXml);
        // 取当前选中节点，或当前选中节点子节点的xml字符串; 
        this.addFun('GetSelectNodeXml', this.getSelectNodeXml);
        // 将界面上的表格类转成xml，转换规律 Grid表格Key->TagName Grid列Key->属性Key 单元格值->属性值
        this.addFun('ConvertGridDataToXml', this.convertGridDataToXml);
        // 将xml字符串更新到xml实体对象的节点中
        this.addFun('SaveXmlToNode', this.saveXmlToNode);
        // 刷新属性面板
        this.addFun('RefreshERPPropertyUI', this.refreshERPPropertyUI);
        // 生成节点的ID
        this.addFun('GenNextNodeID', this.genNextNodeID);
        this.addFun('RunDictFormula', this.runDictFormula);

        this.addFun('SetGridLayoutRowVisible', this.setGridLayoutRowVisible);
        this.addFun('SetGridLayoutAreaVisible', this.setGridLayoutAreaVisible);

        //获得报表配置
        this.addFun('GetPrintAttrValue', this.getPrintAttrValue);
        this.addFun('GetSectionValue', this.getSectionValue);
        this.addFun('GetReportColumnIndex', this.getColumnIndex);
        this.addFun('GetReportRowIndex', this.getRowItem);
        this.addFun('GetReportXML', this.getReportXML);
        this.addFun('GetSelectSectionXML', this.getSelectSectionXML);
        //保存报表配置
        this.addFun('SaveColumnToXml', this.saveColumnToXml);
        this.addFun('SaveReportToXml', this.saveReportToXml);


        this.addFun('GetRefFormKey', this.getExcelFormKey);
        this.addFun('GetSrcDataObjectKey', this.getSrcDataObjectKey);
        this.addFun('GetFieldKey', this.getFieldKey);
        this.addFun('GetTagDataObjectKey', this.getTagDataObjectKey);
        this.addFun('GetDataMigrationTableKey', this.getDataMigrationTableKey);
        this.addFun('GetTagTableKeyByLin', this.getTagTableKeyByLin);
        this.addFun('GetTagFieldKeyByLin', this.getTagFieldKeyByLin);
        this.addFun('GetSheetXML', this.getSheetXML);
        this.addFun('GetExcelRowIndex', this.getExcelRowIndex);
        this.addFun('GetExcelColumnIndex', this.getExcelColumnIndex);
        this.addFun('GetTableKey', this.getExcelTableKey);
        this.addFun('GetRowType', this.getRowType);
        this.addFun('IsMainTable', this.isMainTable);
        this.addFun('GetIsPrimaryTableKey', this.getIsPrimaryTableKey);
        this.addFun('IsField', this.isField);
        this.addFun('GetPrintCellTableKey', this.getPrintCellTableKey);
        this.addFun('GetPrintRowType', this.getPrintRowType);
        this.addFun('GetExcelAttrValue', this.getExcelAttrValue);
        this.addFun('SetColumnKeytoXml', this.setColumnKeytoXml);
        this.addFun('SetPrintColumnKeytoXml', this.setPrintColumnKeytoXml);
        this.addFun('SetSourceFieldToDataMigration', this.setSourceFieldToDataMigration);
        this.addFun('SetTargetFieldToDataMigration', this.setTargetFieldToDataMigration);

        this.addFun('GetDataMapTableKey', this.getDataMapTableKey);
        this.addFun('GetDataMapFieldKey', this.getDataMapFieldKey);
        this.addFun('GetDataMapRootAttrValue', this.getDataMapRootAttrValue);
        this.addFun('GetFeedbackFormKey', this.getFeedbackFormKey);
        this.addFun('GetDataMapFormKeyByField', this.getDataMapFormKeyByField);
        this.addFun('AddFeedBackForm', this.addFeedBackForm);
        this.addFun('GetDataMapXML', this.getDataMapXML);
        this.addFun('SetSourceFieldToDataMap', this.setSourceFieldToDataMap);
        this.addFun('SetTargetFieldToDataMap', this.setTargetFieldToDataMap);
        this.addFun('SetFeedBackFieldToDataMap', this.setFeedBackFieldToDataMap);
        this.addFun('GetTargetTableList', this.getTargetTableList);
        this.addFun('GetPrimaryTableKey', this.getPrimaryTableKey);
        this.addFun('HasFeedBackCollection', this.hasFeedBackCollection);
        this.addFun('HasAttrDefinition', this.hasAttrDefinition);
    }

    private setGridLayoutRowVisible(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = <YIUI.UIForm>ctx.form;
        var gridPanelKey = args[0];
        var bVisible = TypeUtil.toBoolean(args[1]);
        var startRow = TypeUtil.toNum(args[2]);
        var gridPanel = <YIUI.Panel.GridLayoutPanel>form.getComponent(gridPanelKey);

        var rows: number = gridPanel.heights.length;
        var endRow = rows;
        if (args.length > 3) {
            endRow = TypeUtil.toNum(args[3]);
        }
        for (var row = startRow; row <= endRow; row++) {
            var selector = `tbody tr[row='${row}']`;
            $(selector, gridPanel.getEl()).css('display', bVisible ? '' : 'none');
        }
    }

    private setGridLayoutAreaVisible(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = <YIUI.UIForm>ctx.form;
        var gridPanelKey = args[0];
        var bVisible = TypeUtil.toBoolean(args[1]);
        var startRow = TypeUtil.toNum(args[2]);
        var startCol = TypeUtil.toNum(args[3]);
        var gridPanel = <YIUI.Panel.GridLayoutPanel>form.getComponent(gridPanelKey);
        var rows: number = gridPanel.heights.length;
        var endRow = rows;
        if (args.length > 4) {
            endRow = TypeUtil.toNum(args[4]);
        }
        var cols: number = gridPanel.widths.length;
        var endCol = cols;
        if (args.length > 5) {
            endCol = TypeUtil.toNum(args[5]);
        }

        for (var row = startRow; row <= endRow; row++) {
            var rowSelector = `tbody tr[row='${row}']`;
            var $row = $(rowSelector, gridPanel.getEl());
            for (var col = startCol; col <= endCol; col++) {
                var cellSelector = `td[col='${col}']`;
                $(cellSelector, $row).css('display', bVisible ? '' : 'none');
            }
        }
    }

    private async runDictFormula(evaluator: any, name: string, ctx: any, args: any[]): Promise<any> {
        var form = <YIUI.UIForm>ctx.form;
        var code = args[0];

        var itemKey = GlobalVariable.G_FORMULA_DICT;
        var oid = await form.eval(`GetDictOID('${itemKey}', 'Code', '${code}')`, ctx, []);
        if (oid <= 0) return;

        var define = await form.eval(`GetDictValue('${itemKey}', ${oid}, 'Define')`, ctx, []);
        var formulaSourceType = await form.eval(`GetDictValue('${itemKey}', ${oid}, 'FormulaSourceType')`, ctx, []);
        var isConst = (formulaSourceType == 3);
        if (isConst) return define;
        if (define) return await form.eval(define, ctx, []);
    }

    private async refreshERPPropertyUI(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        if (true) return;    //3.1.6中属性面板暂时无效
        if (!YigoDesignFuns.hasPropertyPanel(form)) {
            return;
        }
        var prepareRerender = async function (obj: any) {
            if (obj.isPanel && obj.rendered) obj.rendered = false;
            if (obj.isPanel && obj.layout && obj.layout.prepared) obj.layout.prepared = false;
            var items = obj.items;
            if (items) {
                for (var i = 0, len = items.length; i < len; i++) {
                    await prepareRerender(items[i]);
                }
            }
        };
        var root = form.getRoot();
        await prepareRerender(root);
        await form.render();
    }

    private static hasPropertyPanel(form: any): boolean {
        var _hasPropertyPanel = function (obj: any): boolean {
            if (obj.isPropertyLayout && obj.isPropertyLayout()) {
                return true;
            }
            var items = obj.items;
            if (items) {
                for (var i = 0, len = items.length; i < len; i++) {
                    return _hasPropertyPanel(items[i]);
                }
            }
            return false;
        };
        var root = form.getRoot();
        return _hasPropertyPanel(root);
    }

    private genNextNodeID(evaluator: any, name: string, ctx: any, args: any[]): number {
        var form = <YIUI.UIForm>ctx.form;
        if (!form) return 0;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return 0;

        var xmlEntity = wfWorkSpace.getXmlEntity();
        return xmlEntity.genNextNodeID();
    }

    /**
     * 将xml字符串更新到xml实体对象的节点中
     * 参数1: 更新到的目标TagName, 若是在子节点更下层的节点，节点路径用 '|' 分隔
     * 参数2: 所需更新的xml字符串, 可以直接通过 ConvertGridDataToXml公式获取
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private saveXmlToNode(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = <YIUI.UIForm>ctx.form;
        if (!form) return;

        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var targetTagName = args[0];
        var strXml = args[1];
        var xmlEntity = wfWorkSpace.getXmlEntity();
        var selectItem = xmlEntity.getSelectionModel().getSingleSeletionItem();
        if (selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            var targetNode = targetTagName ? tagNode.ensureChild(targetTagName) : tagNode;
            targetTagName && targetNode.clearChildren();
            if (strXml) {
                var childs = XmlEntity.parseTagNodeCollection(strXml);
                for (let child of childs) {
                    if (child.getNodeType() == ENodeType.TAG) {
                        !targetTagName && targetNode.clearChildren((<ITagNode>child).getTagName());
                    }
                    targetNode.addChild(child);
                }
            }
            XmlEntityUtil.refreshSelection(xmlEntity);
            wfWorkSpace.reloadSource();
        }
    }

    /**
     * 将界面上的表格类转成xml，转换规律 Grid表格Key->TagName Grid列Key->属性Key 单元格值->属性值
     * 注: 列标志以 "_"开头，不保存；以`${tagName}_` 开头的列名作为子节点CDATA设置值处理；其他带'_'的列标志，只取 "_" 之前的部分作为属性标志
     * 参数1: 设置作为TagName的列序号
     * 参数2: 设置关键列，若某行该列单元格为空，则该行不写入xml
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private convertGridDataToXml(evaluator: any, name: string, ctx: any, args: any[]): string {
        var xmlStr = "";
        var form = <YIUI.UIForm>ctx.form;
        if (!form) return xmlStr;
        var tagColumnIndex = (args.length > 0 ? args[0] : -1);
        var primaryKey = (args.length > 1 ? String(args[1]) : '');
        var primaryKeys = primaryKey ? primaryKey.split(':') : primaryKey;
        for (let gridInfo of form.getGridArray()) {
            var uiGrid = <YIUI.Control.Grid>form.getComponent(gridInfo.key);
            var rowCount = uiGrid.getRowCount();
            for (var row = 0; row < rowCount; row++) {
                if (primaryKeys) {
                    // 是否存在关键字段为空的情况
                    var hasEmptyPrimary = false;
                    for (let cellKey of primaryKeys) {
                        var loc = form.getCellLocation(cellKey);
                        if (loc.key == uiGrid.key) {
                            hasEmptyPrimary = !uiGrid.getCellDataAt(row, loc.column).value;
                            if (hasEmptyPrimary) break;
                        }
                    }
                    if (hasEmptyPrimary) continue;
                }
                var tagName = tagColumnIndex < 0 ? gridInfo.key : uiGrid.getValueAt(row, tagColumnIndex)
                if (!tagName) continue;

                var childNode = new TagNode(tagName);
                var colCount = uiGrid.getColumnCount();
                for (var col = 0; col < colCount; col++) {
                    if (col == tagColumnIndex) continue;
                    var column = uiGrid.getColumnAt(col);
                    var cellValue = uiGrid.getValueAt(row, col);
                    var attrKey = column.key;
                    var prefixCDataNode = `${tagName}_CDATA_`;
                    var prefixChildNode = `ChildNode_`;
                    if (attrKey.startsWith("_")) {
                        continue;
                    } else if (attrKey.startsWith(prefixChildNode)) {
                        // 处理子节点
                        if (cellValue) {
                            var tagNodes = XmlEntity.parseTagNodeCollection(cellValue);
                            for (let tagNode of tagNodes) {
                                childNode.addChild(tagNode);
                            }
                        }
                    } else if (attrKey.startsWith(prefixCDataNode)) {
                        // 处理子节点
                        var childTagName = attrKey.replace(prefixCDataNode, "");
                        if (cellValue) {
                            var childTagNode = new TagNode(childTagName);
                            childTagNode.setCDATAValue(cellValue);
                            childNode.addChild(childTagNode);
                        }
                    } else {
                        // 处理属性    
                        var pos = attrKey.indexOf("_");
                        if (pos > 0) attrKey = attrKey.substring(0, pos);
                        var metaCell = uiGrid.getMetaCellByColumnKey(column.key);
                        var defaultValue = metaCell ? metaCell.defaultValue : "";
                        childNode.setAttributeValue(attrKey, (cellValue == null ? "" : cellValue), defaultValue ? defaultValue : "");
                    }
                }
                xmlStr += childNode.toXml(true);
            }
        }
        return xmlStr;
    }

    /**
     * 取当前选中节点，或当前选中节点子节点的xml字符串;
     * 参数1： 可选参数 子节点TagName,未指定时默认取当前选中节点的所有xml字符串
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getSelectNodeXml(evaluator: any, name: string, ctx: any, args: any[]): string {
        var wfWorkSpace = YigoDesignFuns.getWorkspace(ctx.form);
        if (!wfWorkSpace) return "";
        var childTagName = (args.length > 0 ? args[0] : '');
        var xmlEntity = wfWorkSpace.getXmlEntity();
        var selectItem = xmlEntity.getSelectionModel().getSingleSeletionItem();
        if (selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            if (!childTagName) return tagNode.toXml(true);
            var node = tagNode.getChild(childTagName);
            if (!node) return "";
            return node.toXml(true);
        }
        return "";
    }

    private saveTimerItemCollectionToXml(evaluator: any, name: string, ctx: any, args: any[]) {
        var wfWorkSpace = YigoDesignFuns.getWorkspace(ctx.form);
        if (!wfWorkSpace) return;

        var types = String(args[0]);
        var keys = String(args[1]);
        var peroids = args[2];
        var cycleIntervals = args[3];
        var triggers = args[4];
        var repeats = args[5];
        if (!keys) return;

        var xmlEntity = wfWorkSpace.getXmlEntity();
        var selectItem = xmlEntity.getSelectionModel().getSingleSeletionItem();
        if (!selectItem) return;
        if (selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            var node = tagNode.ensureChild(WfConstants.NODE_TimerItemCollection);
            node.clearChildren();
            var arrType = types.split(",");
            var arrKey = keys.split(",");
            var arrPeriod = peroids.split(",");
            var arrCycleInterval = cycleIntervals.split(",");
            var arrTrigger = triggers.split(",");
            var arrRepeat = repeats.split(",");
            for (var i = 0; i < arrKey.length; i++) {
                var child = <TagNode>node.addChild(new TagNode(arrType[i]));
                child.setAttributeValue(GlobalConstants.S_Key, arrKey[i]);
                child.setAttributeValue(WfConstants.ATTR_Peroid, arrPeriod[i]);
                child.setAttributeValue(WfConstants.ATTR_CycleInterval, arrCycleInterval[i]);
                child.setAttributeValue(WfConstants.ATTR_Trigger, arrTrigger[i]);
                child.setAttributeValue(WfConstants.ATTR_Repeat, arrRepeat[i]);
            }
            wfWorkSpace.reloadSource();
        }
    }

    private getDMTableXml(evaluator: any, name: string, ctx: any, args: any[]): string {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return "";
        var xmlEntity = wfWorkSpace.getXmlEntity();
        var dmNode = <TagNode>WfNodeUtil.ensureDMTableNode(xmlEntity);
        return dmNode.toXml(true);
    }

    /**
     * 保存参与者到XML对象
     * 参数1: 操作员表格标识
     * 参数2: 角色表格标识
     * 参数3: 查询表格标识
     * 参数4: 公式表格标识
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private async saveParticipatorToXml(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var operatorGridKey = args[0];
        var roleGridKey = args[1];
        var queryGridKey = args[2];
        var formulaGridKey = args[3];
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var xmlEntity = wfWorkSpace.getXmlEntity();
        var selectItem = xmlEntity.getSelectionModel().getSingleSeletionItem();
        if (selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            var operatorGrid = <YIUI.Control.Grid>form.getComponent(operatorGridKey);
            var roleGrid = <YIUI.Control.Grid>form.getComponent(roleGridKey);
            var queryGrid = <YIUI.Control.Grid>form.getComponent(queryGridKey);
            var formulaGrid = <YIUI.Control.Grid>form.getComponent(formulaGridKey);
            var participatorCollectionTag = <TagNode>tagNode.ensureChild(WfConstants.NODE_ParticipatorCollection);
            participatorCollectionTag.clearChildren();
            await YigoDesignFuns._fillParticipatorsToNode(participatorCollectionTag, operatorGrid, roleGrid, queryGrid, formulaGrid, ctx);
            xmlEntity.update(tagNode, false);

            XmlEntityUtil.refreshSelection(xmlEntity);
            wfWorkSpace.reloadSource();
        }
    }

    private async convertParticipatorGridsToXml(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var operatorGridKey = args[0];
        var roleGridKey = args[1];
        var queryGridKey = args[2];
        var formulaGridKey = args[3];

        var operatorGrid = <YIUI.Control.Grid>form.getComponent(operatorGridKey);
        var roleGrid = <YIUI.Control.Grid>form.getComponent(roleGridKey);
        var queryGrid = <YIUI.Control.Grid>form.getComponent(queryGridKey);
        var formulaGrid = <YIUI.Control.Grid>form.getComponent(formulaGridKey);
        var participatorCollectionTag = new TagNode(WfConstants.NODE_ParticipatorCollection);
        await YigoDesignFuns._fillParticipatorsToNode(participatorCollectionTag, operatorGrid, roleGrid, queryGrid, formulaGrid, ctx);
        return participatorCollectionTag.toXml(true);
    }

    private static async _fillParticipatorsToNode(participatorCollectionTag: TagNode, operatorGrid: YIUI.Control.Grid, roleGrid: YIUI.Control.Grid,
                                                  queryGrid: YIUI.Control.Grid, formulaGrid: YIUI.Control.Grid, ctx: any) {
        await YigoDesignFuns._saveDictionaryParticipator(participatorCollectionTag, GlobalConstants.S_Operator, 'OperatorDataType', 'OperatorID', operatorGrid, ctx);
        await YigoDesignFuns._saveDictionaryParticipator(participatorCollectionTag, GlobalConstants.S_Role, 'RoleDataType', 'RoleID', roleGrid, ctx);
        YigoDesignFuns._saveQueryParticipator(participatorCollectionTag, queryGrid);
        YigoDesignFuns._saveFormulaParticipator(participatorCollectionTag, formulaGrid);
    }

    private static _saveQueryParticipator(participatorCollectionTag: TagNode, queryGrid: YIUI.Control.Grid) {
        var rowCount = queryGrid.getRowCount();
        if (rowCount > 0) {
            for (var row = 0; row < rowCount; row++) {
                var queryData = queryGrid.getValueByKey(row, 'QueryData');
                var queryParameterXml = queryGrid.getValueByKey(row, 'QueryParameterXml');
                if (queryData) {
                    var queryTag = new TagNode(GlobalConstants.S_Query);
                    participatorCollectionTag.addChild(queryTag);
                    queryTag.setCDATAValue(queryData);
                    if (queryParameterXml) {
                        var strCollectionXml = `<${GlobalConstants.S_QueryParameterCollection}>${queryParameterXml}</${GlobalConstants.S_QueryParameterCollection}>`
                        var parameterCollectionTag = XmlEntity.parseTagNode(strCollectionXml);
                        queryTag.addChild(parameterCollectionTag);
                    }
                }
            }
        }
    }

    private static _saveFormulaParticipator(participatorCollectionTag: TagNode, formulaGrid: YIUI.Control.Grid) {
        var rowCount = formulaGrid.getRowCount();
        if (rowCount > 0) {
            for (var row = 0; row < rowCount; row++) {
                var value = formulaGrid.getValueByKey(row, 'FormulaData');
                if (value) {
                    var formulaTag = new TagNode(GlobalConstants.S_MidFormula);
                    participatorCollectionTag.addChild(formulaTag);
                    formulaTag.setCDATAValue(value);
                }
            }
        }
    }

    private static async _saveDictionaryParticipator(participatorCollectionTag: TagNode, itemKey: string, typeColumnKey: string, idColumnKey: string, operatorGrid: YIUI.Control.Grid, ctx: any): Promise<void> {
        var rowCount = operatorGrid.getRowCount();
        if (rowCount > 0) {

            var itemIDs = "", itemCodes = "";
            for (var row = 0; row < rowCount; row++) {
                var type = operatorGrid.getValueByKey(row, typeColumnKey);
                var item = operatorGrid.getValueByKey(row, idColumnKey);
                if (item && item.oid > 0) {
                    if (type == 'ID') {
                        itemIDs += (itemIDs ? ":" + item.oid : item.oid);
                    } else if (type == 'Code') {
                        var form = ctx.form;
                        var code = await form.eval(`GetDictValue('${itemKey}', ${item.oid}, 'Code')`, ctx, []);
                        itemCodes += (itemCodes ? ":" + code : code);
                    }
                }
            }
            if (itemIDs || itemCodes) {
                var dictionaryTag = new TagNode(WfConstants.NODE_Dictionary);
                dictionaryTag.setAttributeValue(GlobalConstants.S_ItemKey, itemKey);
                participatorCollectionTag.addChild(dictionaryTag);
                itemIDs && dictionaryTag.setAttributeValue(GlobalConstants.S_ItemID, itemIDs);
                itemCodes && dictionaryTag.setAttributeValue(GlobalConstants.S_Code, itemCodes);
            }
        }
    }

    private saveDMTableToXml(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var keys = String(args[0]);
        var types = args[1];
        var sourceKeys = args[2];
        var constValues = args[3];
        if (!keys) return;

        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var xmlEntity = wfWorkSpace.getXmlEntity();
        var dmNode = WfNodeUtil.ensureDMTableNode(xmlEntity);
        dmNode.clearChildren();
        var arrKey = keys.split(",");
        var arrType = types.split(",");
        var arrSourceKey = sourceKeys.split(",");
        var arrConstValue = constValues.split(",");
        for (var i = 0; i < arrKey.length; i++) {
            if (arrSourceKey[i] || arrConstValue[i]) {
                var node = <TagNode>dmNode.addChild(new TagNode(WfConstants.NODE_Field));
                node.setAttributeValue(GlobalConstants.S_Key, arrKey[i]);
                node.setAttributeValue(WfConstants.ATTR_Type, arrType[i], 'Field');
                node.setAttributeValue(WfConstants.ATTR_SourceFieldKey, arrSourceKey[i], '');
                node.setAttributeValue(WfConstants.ATTR_ConstValue, arrConstValue[i], '');
            }
        }
        wfWorkSpace.reloadSource();
    }

    private setPrintColumnKeytoXml(evaluator: any, name: string, ctx: any, args: any[]) {
        let form = ctx.form;
        // 从doc里获取数据
        let newValue = args[0];
        let newCaption = args[1];
        let DataType = args[2];
        let Inste_Key = args[3];//是否插入标识
        let Inste_Caption = args[4];//是否插入名称
        let Inste_H = args[5];//插入方式
        let ItemKey = args[6];
        let FieldKeys = args[7];
        let Format = args[8];
        let M_Format = args[9];
        let D_Format = args[10];
        let list = args[11];
        let workSpace = <PrintWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        let xmlEntity = workSpace.getXmlEntity();
        let cellNode = <ITagNode>XmlEntityUtil.getSelectionModel(xmlEntity).getSingleSeletionItem();
        let parent = cellNode.getParent();
        if (Inste_Key == "true") {
            if (DataType != "Text" && DataType != "") {
                var iTagNode = cellNode.ensureChild("Display").ensureChild("Format");
                iTagNode.setAttributeValue("DataType", DataType);
                if (DataType == "Dict") {
                    iTagNode.setAttributeValue("FieldKeys", FieldKeys);
                    iTagNode.setAttributeValue("ItemKey", ItemKey);
                } else if (DataType == "Number") {
                    iTagNode.setAttributeValue("Format", Format);
                } else if (DataType == "Money") {
                    iTagNode.setAttributeValue("Format", M_Format);
                } else if (DataType == "Date") {
                    iTagNode.setAttributeValue("Format", D_Format);
                } else if (DataType == "List" || DataType == "MultiList") {
                    if (list.length > 0) {
                        var split = list.split(";");
                        for (let i = 0; i < split.length; i++) {
                            var splitElement = split[i];
                            var split1 = splitElement.split(":");
                            var tagNode = new TagNode("ListItem");
                            tagNode.setAttributeValue("Value", split1[0]);
                            tagNode.setAttributeValue("Text", split1[1]);
                            if (split1[0] != "" && split1[1] != "") {
                                iTagNode.addChild(tagNode);
                            }
                        }
                    }
                }
            } else if (DataType = "Text") {
                var iTagNode = cellNode.ensureChild("Display").ensureChild("Format");
                iTagNode.setAttributeValue("DataType", DataType);
            }
        }
        let rowNode = <ITagNode>parent;
        let rowType = rowNode.getAttributeValue(BaseConstants.ATTR_Type, "Fix");
        if (rowType == "Detail") {
            let rowsNode = rowNode.getParent();
            if (Inste_Key == "true" && Inste_Caption == "true") {
                cellNode.setAttributeValue(PrintConstants.ATTR_Key, newValue);
                cellNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                cellNode.setAttributeValue(PrintConstants.ATTR_SourceType, "Field");
                cellNode.setAttributeValue(PrintConstants.ATTR_FieldKey, newValue);
                cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, rowNode.getAttributeValue(BaseConstants.ATTR_TableKey));
                //如果有内容，清空掉
                let cellText = <ITagNode>cellNode.getChild("CellText");
                if(cellText){
                    cellNode.removeChild(cellText);
                }
                //如果存在明细头,连带明细头一块设置
                let rowIndex = rowsNode!.getChildren().indexOf(rowNode);
                let cellIndex = rowNode.getChildren().indexOf(cellNode);
                let preRow, afterRow;
                if (rowIndex > 0) {
                    preRow = <ITagNode>rowsNode!.getChildren()[rowIndex - 1];
                    afterRow = <ITagNode>rowsNode!.getChildren()[rowIndex + 1];
                    if (preRow) {
                        if (preRow.getAttributeValue(BaseConstants.ATTR_Type, "Fix") == "DetailHead") {
                            let find = <ITagNode>preRow.getChildren()[cellIndex];
                            if (find) {
                                find.setAttributeValue(PrintConstants.ATTR_Key, "Inner_"+newValue);
                                find.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                                find.removeAttribute(PrintConstants.ATTR_SourceType);
                                //如果有内容，清空掉
                                let cellText = <ITagNode>find.getChild("CellText");
                                if(cellText){
                                    find.removeChild(cellText);
                                }
                            } else {
                                var columnNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
                                columnNode.setAttributeValue(PrintConstants.ATTR_Key, "Inner_"+newValue);
                                columnNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                                columnNode.removeAttribute(PrintConstants.ATTR_SourceType);
                                //如果有内容，清空掉
                                let cellText = <ITagNode>columnNode.getChild("CellText");
                                if(cellText){
                                    columnNode.removeChild(cellText);
                                }
                                columnNode.setParent(preRow);
                                preRow.addChild(columnNode);
                            }
                        } else if (preRow.getAttributeValue(BaseConstants.ATTR_Type, "Fix") == "LinkPrev") {//承上行
                            let find = <ITagNode>preRow.getChildren()[cellIndex];
                            if (find) {
                                find.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                                find.removeAttribute(PrintConstants.ATTR_SourceType);
                                //如果有内容，清空掉
                                let cellText = <ITagNode>find.getChild("CellText");
                                if(cellText){
                                    find.removeChild(cellText);
                                }
                            } else {
                                var columnNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
                                columnNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                                columnNode.removeAttribute(PrintConstants.ATTR_SourceType);
                                //如果有内容，清空掉
                                let cellText = <ITagNode>columnNode.getChild("CellText");
                                if(cellText){
                                    columnNode.removeChild(cellText);
                                }
                                columnNode.setParent(preRow);
                                preRow.addChild(columnNode);
                            }
                            let headRow = <ITagNode>rowsNode!.getChildren()[rowIndex - 2];
                            if(headRow && headRow.getAttributeValue(BaseConstants.ATTR_Type, "Fix") == "DetailHead"){//承上行前一行是明细头
                                let findCol = <ITagNode>headRow.getChildren()[cellIndex];
                                if (findCol) {
                                    findCol.setAttributeValue(PrintConstants.ATTR_Key, "Inner_"+newValue);
                                    findCol.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                                    findCol.removeAttribute(PrintConstants.ATTR_SourceType);
                                    //如果有内容，清空掉
                                    let cellText = <ITagNode>findCol.getChild("CellText");
                                    if(cellText){
                                        findCol.removeChild(cellText);
                                    }
                                } else {
                                    var columnNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
                                    columnNode.setAttributeValue(PrintConstants.ATTR_Key, "Inner_"+newValue);
                                    columnNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                                    columnNode.removeAttribute(PrintConstants.ATTR_SourceType);
                                    //如果有内容，清空掉
                                    let cellText = <ITagNode>columnNode.getChild("CellText");
                                    if(cellText){
                                        columnNode.removeChild(cellText);
                                    }
                                    columnNode.setParent(headRow);
                                    headRow.addChild(columnNode);
                                }
                            }
                        }
                    }
                    if (afterRow && afterRow.getAttributeValue(BaseConstants.ATTR_Type, "Fix") == "LinkNext") {//启下行
                        let find = <ITagNode>afterRow.getChildren()[cellIndex];
                        if (find) {
                            find.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                            find.removeAttribute(PrintConstants.ATTR_SourceType);
                            //如果有内容，清空掉
                            let cellText = <ITagNode>find.getChild("CellText");
                            if(cellText){
                                find.removeChild(cellText);
                            }
                        } else {
                            var columnNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
                            columnNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                            columnNode.removeAttribute(PrintConstants.ATTR_SourceType);
                            //如果有内容，清空掉
                            let cellText = <ITagNode>columnNode.getChild("CellText");
                            if(cellText){
                                columnNode.removeChild(cellText);
                            }
                            columnNode.setParent(afterRow);
                            afterRow.addChild(columnNode);
                        }
                    }
                }
            } else if (Inste_Key == "true" && Inste_Caption == "false") {//只添加标识
                cellNode.setAttributeValue(PrintConstants.ATTR_Key, newValue);
                cellNode.setAttributeValue(PrintConstants.ATTR_Caption, newValue);
                cellNode.setAttributeValue(PrintConstants.ATTR_SourceType, "Field");
                cellNode.setAttributeValue(PrintConstants.ATTR_FieldKey, newValue);
                cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, rowNode.getAttributeValue(BaseConstants.ATTR_TableKey));
                //如果有内容，清空掉
                let cellText = <ITagNode>cellNode.getChild("CellText");
                if(cellText){
                    cellNode.removeChild(cellText);
                }
            } else if (Inste_Key == "false" && Inste_Caption == "true") {//只添加名称
                //cellNode.setAttributeValue(PrintConstants.ATTR_Key, newValue);
                cellNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                cellNode.setAttributeValue(PrintConstants.ATTR_SourceType, "Field");
                cellNode.setAttributeValue(PrintConstants.ATTR_FieldKey, newValue);
                cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, rowNode.getAttributeValue(BaseConstants.ATTR_TableKey));
                //如果有内容，清空掉
                let cellText = <ITagNode>cellNode.getChild("CellText");
                if(cellText){
                    cellNode.removeChild(cellText);
                }
            }
            var selectSheetView = workSpace.getGraphicView().getSelectSheetView();
            if(selectSheetView != null){
                xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
            }
            xmlEntity.update(rowsNode, true);
        } else {
            let strings = newValue.split("|");
            let key;
            if(strings.length > 1){
                key = strings[1];
            }else {
                key = newValue;
            }
            if (Inste_Key == "true" && Inste_Caption == "true") {
                cellNode.setAttributeValue(PrintConstants.ATTR_Key, key);
                cellNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                cellNode.setAttributeValue(PrintConstants.ATTR_SourceType, "Field");
                cellNode.setAttributeValue(PrintConstants.ATTR_FieldKey, key);
                cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                //如果有内容，清空掉
                let cellText = <ITagNode>cellNode.getChild("CellText");
                if(cellText){
                    cellNode.removeChild(cellText);
                }
                //横向
                if (Inste_H == "H") {
                    let cellIndex = rowNode.getChildren().indexOf(cellNode);
                    if (cellIndex != 0) {
                        let preColumn = <ITagNode>rowNode.getChildren()[cellIndex-1];
                        if (preColumn) {
                            preColumn.setAttributeValue(PrintConstants.ATTR_Key, "Lab_"+key);
                            preColumn.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                            preColumn.removeAttribute(PrintConstants.ATTR_SourceType);
                            //如果有内容，清空掉
                            let cellText = <ITagNode>preColumn.getChild("CellText");
                            if(cellText){
                                preColumn.removeChild(cellText);
                            }
                        } else {
                            var columnNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
                            columnNode.setAttributeValue(PrintConstants.ATTR_Key, "Lab_"+key);
                            columnNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                            columnNode.removeAttribute(PrintConstants.ATTR_SourceType);
                            //如果有内容，清空掉
                            let cellText = <ITagNode>columnNode.getChild("CellText");
                            if(cellText){
                                columnNode.removeChild(cellText);
                            }
                            columnNode.setParent(rowNode);
                            rowNode.addChild(columnNode);
                        }
                    }
                } else {//纵向
                    let rowsNode = rowNode.getParent();
                    let rowIndex = rowsNode!.getChildren().indexOf(rowNode);
                    let cellIndex = rowNode.getChildren().indexOf(cellNode);
                    let preRow = <ITagNode>rowsNode!.getChildren()[rowIndex - 1];
                    let tag;
                    if (!preRow) {
                        var tagNode1 = new TagNode("Row");
                        rowsNode?.addChild(tagNode1);
                        tag = new TagNode("Cell");
                        tag.setAttributeValue(PrintConstants.ATTR_Key, "Lab_"+key);
                        tag.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                        tag.removeAttribute(PrintConstants.ATTR_SourceType);
                        //如果有内容，清空掉
                        let cellText = <ITagNode>tag.getChild("CellText");
                        if(cellText){
                            tag.removeChild(cellText);
                        }
                        tagNode1.addChild(tag);
                    } else {
                        tag = <ITagNode>preRow.getChildren()[cellIndex];
                        if (!tag){
                            tag = new TagNode("Cell");
                            preRow.addChild(tag);
                        }
                        tag!.setAttributeValue(PrintConstants.ATTR_Key, "Lab_"+key);
                        tag!.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                        tag!.removeAttribute(PrintConstants.ATTR_SourceType);
                        //如果有内容，清空掉
                        let cellText = <ITagNode>tag.getChild("CellText");
                        if(cellText){
                            tag.removeChild(cellText);
                        }
                    }
                }
            } else if (Inste_Key == "true" && Inste_Caption == "false") {//只添加标识
                cellNode.setAttributeValue(PrintConstants.ATTR_Key, key);
                cellNode.setAttributeValue(PrintConstants.ATTR_Caption, key);
                cellNode.setAttributeValue(PrintConstants.ATTR_SourceType, "Field");
                cellNode.setAttributeValue(PrintConstants.ATTR_FieldKey, key);
                cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                //如果有内容，清空掉
                let cellText = <ITagNode>cellNode.getChild("CellText");
                if(cellText){
                    cellNode.removeChild(cellText);
                }
            } else if (Inste_Key == "false" && Inste_Caption == "true") {//只添加名称
                //cellNode.setAttributeValue(PrintConstants.ATTR_Key, key);
                cellNode.setAttributeValue(PrintConstants.ATTR_Caption, newCaption);
                cellNode.setAttributeValue(PrintConstants.ATTR_SourceType, "Field");
                cellNode.setAttributeValue(PrintConstants.ATTR_FieldKey, key);
                cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                //如果有内容，清空掉
                let cellText = <ITagNode>cellNode.getChild("CellText");
                if(cellText){
                    cellNode.removeChild(cellText);
                }
            }
            var selectSheetView = workSpace.getGraphicView().getSelectSheetView();
            if(selectSheetView != null){
                xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
            }
            xmlEntity.update(rowNode, true);
        }
    }

    private setColumnKeytoXml(evaluator: any, name: string, ctx: any, args: any[]) {
        let form = ctx.form;
        // 从doc里获取数据
        let newValue = args[0];
        let newCaption = args[1];
        let DataType = args[2];
        let Inste_Key = args[3];//是否插入标识
        let Inste_Caption = args[4];//是否插入名称
        let Inste_H = args[5];//插入方式
        let ItemKey = args[6];
        let FieldKeys = args[7];
        let Format = args[8];
        let M_Format = args[9];
        let D_Format = args[10];
        let list = args[11];
        let workSpace = <ExcelWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        let xmlEntity = workSpace.getXmlEntity();
        let root = <ITagNode>xmlEntity.getRoot().getChildren()[1];
        let cellNode = <ITagNode>XmlEntityUtil.getSelectionModel(xmlEntity).getSingleSeletionItem();
        let parent = cellNode.getParent();
        if (parent) {
            if (Inste_Key == "true") {
                if (DataType != "Text" && DataType != "") {
                    var iTagNode = cellNode.ensureChild("Display").ensureChild("Format");
                    iTagNode.setAttributeValue("DataType", DataType);
                    if (DataType == "Dict") {
                        iTagNode.setAttributeValue("FieldKeys", FieldKeys);
                        iTagNode.setAttributeValue("ItemKey", ItemKey);
                    } else if (DataType == "Number") {
                        iTagNode.setAttributeValue("Format", Format);
                    } else if (DataType == "Money") {
                        iTagNode.setAttributeValue("Format", M_Format);
                    } else if (DataType == "Date") {
                        iTagNode.setAttributeValue("Format", D_Format);
                    } else if (DataType == "List" || DataType == "MultiList") {
                        if (list.length > 0) {
                            var split = list.split(";");
                            for (let i = 0; i < split.length; i++) {
                                var splitElement = split[i];
                                var split1 = splitElement.split(":");
                                var tagNode = new TagNode("ListItem");
                                tagNode.setAttributeValue("Value", split1[0]);
                                tagNode.setAttributeValue("Text", split1[1]);
                                if (split1[0] != "" && split1[1] != "") {
                                    iTagNode.addChild(tagNode);
                                }
                            }
                        }
                    }

                } /* else if (DataType = "Text") {
                    var iTagNode = cellNode.ensureChild("Display").ensureChild("Format");
                    iTagNode.setAttributeValue("DataType", DataType, "Text");
                } */
                }
            let rowNode = <ITagNode>parent;
            let rowType = rowNode.getAttributeValue(BaseConstants.ATTR_Type, "Fix");
            if (rowType == "Detail") {
                let rowsNode = rowNode.getParent();
                if (Inste_Key == "true" && Inste_Caption == "true") {
                    cellNode.setAttributeValue(ExcelConstants.ATTR_Definition, newValue)
                    cellNode.removeAttribute(ExcelConstants.ATTR_SourceType)
                    //如果存在明细头,连带明细头一块设置
                    let rowIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 0);
                    let cellIndex = cellNode.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0);
                    let preRow;
                    if (rowIndex > 1) {
                        preRow = rowsNode!.find("Row", "RowIndex", (rowIndex - 1).toString());
                        if (preRow && preRow.getAttributeValue(BaseConstants.ATTR_Type, "Fix") == "DetailHead") {
                            let find = preRow.find("Cell", ExcelConstants.ATTR_CellIndex, cellIndex.toString());
                            if (find) {
                                find.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                find.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                            } else {
                                var columnNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                                columnNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, cellIndex.toString());
                                columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                columnNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                                columnNode.setParent(preRow);
                                preRow.addChild(columnNode)
                            }
                        }
                    }
                } else if (Inste_Key == "true" && Inste_Caption == "false") {//只添加标识
                    cellNode.setAttributeValue(ExcelConstants.ATTR_Definition, newValue)
                    cellNode.removeAttribute(ExcelConstants.ATTR_SourceType)
                } else if (Inste_Key == "false" && Inste_Caption == "true") {//只添加名称
                    cellNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                    cellNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                }
                var selectSheetView = <SheetView>workSpace.getGraphicView().getSelectSheetView();
                xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
                xmlEntity.update(rowsNode, true);
            } else {
                let strings = newValue.split("|");
                if (Inste_Key == "true" && Inste_Caption == "true") {
                    cellNode.setAttributeValue(ExcelConstants.ATTR_Definition, strings[1]);
                    cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                    cellNode.removeAttribute(ExcelConstants.ATTR_SourceType)
                    if (Inste_H == "H") {
                        let cellIndex = cellNode.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0);
                        if (cellIndex != 1) {
                            let preColumn = rowNode.find("Cell", "CellIndex", (cellIndex - 1).toString());
                            if (preColumn) {
                                preColumn.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                preColumn.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                            } else {
                                var columnNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                                columnNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, (cellIndex - 1).toString());
                                columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                columnNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                                columnNode.setParent(rowNode);
                                rowNode.addChild(columnNode);
                            }
                        }
                    } else {//纵向
                        let rowsNode = rowNode.getParent();
                        let rowIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 0);
                        let cellIndex = cellNode.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0);
                        let preRow = rowsNode!.find("Row", "RowIndex", (rowIndex - 1).toString());
                        let tag;
                        if (!preRow) {
                            var tagNode1 = new TagNode("Row");
                            tagNode1.setAttributeValue("RowIndex", (rowIndex - 1).toString());
                            rowsNode?.addChild(tagNode1);
                            tag = new TagNode("Cell");
                            tag.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                            tag.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                            tag.setAttributeValue("CellIndex", (cellIndex).toString());
                            tagNode1.addChild(tag);
                        } else {
                            tag = preRow!.find("Cell", "CellIndex", (cellIndex).toString());
                            if (!tag) {
                                tag = new TagNode("Cell");
                                tag.setAttributeValue("CellIndex", (cellIndex).toString());
                                preRow.addChild(tag);
                            }
                            tag!.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                            tag!.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                        }
                    }

                } else if (Inste_Key == "true" && Inste_Caption == "false") {//只添加标识
                    cellNode.setAttributeValue(ExcelConstants.ATTR_Definition, strings[1]);
                    cellNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                    cellNode.removeAttribute(ExcelConstants.ATTR_SourceType)
                } else if (Inste_Key == "false" && Inste_Caption == "true") {//只添加名称
                    cellNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                    cellNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                }
                var selectSheetView = <SheetView>workSpace.getGraphicView().getSelectSheetView();
                xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
                xmlEntity.update(rowNode, true);
            }
        } else {
            let excelWorkSpace = <ExcelWorkSpace>workSpace;
            let selectSheetViewName = excelWorkSpace.getGraphicView().getSelectSheetViewName();
            let sheetNode;
            let rowNode;
            let rowIndex = Number(cellNode.getAttributeValue("rowindex")) + 1;
            let colIndex = Number(cellNode.getAttributeValue("colindex")) + 1;
            sheetNode = <ITagNode>root.find("Sheet", "Name", selectSheetViewName);
            let rowsNode = <ITagNode>sheetNode.getChildren()[0];
            rowNode = <ITagNode>sheetNode.find("Row", "RowIndex", rowIndex.toString());
            if (rowNode) {
                let rowType = rowNode.getAttributeValue(BaseConstants.ATTR_Type, "Fix");
                if (rowType == "Detail") {
                    var columnNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                    if (Inste_Key == "true") {
                        if (DataType != "Text" && DataType != "") {
                            var iTagNode = columnNode.ensureChild("Display").ensureChild("Format");
                            iTagNode.setAttributeValue("DataType", DataType);
                            if (DataType == "Dict") {
                                iTagNode.setAttributeValue("FieldKeys", FieldKeys);
                                iTagNode.setAttributeValue("ItemKey", ItemKey);
                            } else if (DataType == "Number") {
                                iTagNode.setAttributeValue("Format", Format);
                            } else if (DataType == "Money") {
                                iTagNode.setAttributeValue("Format", M_Format);
                            } else if (DataType == "Date") {
                                iTagNode.setAttributeValue("Format", D_Format);
                            } else if (DataType == "List" || DataType == "MultiList") {
                                if (list.length > 0) {
                                    var split = list.split(";");
                                    for (let i = 0; i < split.length; i++) {
                                        var splitElement = split[i];
                                        var split1 = splitElement.split(":");
                                        var tagNode = new TagNode("ListItem");
                                        tagNode.setAttributeValue("Value", split1[0]);
                                        tagNode.setAttributeValue("Text", split1[1]);
                                        if (split1[0] != "" && split1[1] != "") {
                                            iTagNode.addChild(tagNode);
                                        }
                                    }
                                }
                            }

                        } else if (DataType = "Text") {
                            var iTagNode = columnNode.ensureChild("Display").ensureChild("Format");
                            iTagNode.setAttributeValue("DataType", DataType);
                        }
                    }
                    if (Inste_Key == "true" && Inste_Caption == "true") {
                        columnNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, colIndex.toString());
                        columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newValue);
                        columnNode.setParent(rowNode);
                        rowNode.addChild(columnNode);
                        //如果存在明细头,连带明细头一块设置
                        let rowsNode = rowNode.getParent();
                        let preRow;
                        if (rowIndex > 1) {
                            preRow = rowsNode!.find("Row", "RowIndex", (rowIndex - 1).toString());
                            if (preRow && preRow.getAttributeValue(BaseConstants.ATTR_Type, "Fix") == "DetailHead") {
                                let find = preRow.find("Cell", ExcelConstants.ATTR_CellIndex, colIndex.toString());
                                if (find) {
                                    find.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                    find.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                                } else {
                                    var columnNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                                    columnNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, colIndex.toString());
                                    columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                    columnNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                                    columnNode.setParent(preRow);
                                    preRow.addChild(columnNode)
                                }
                            }
                        }
                    } else if (Inste_Key == "true" && Inste_Caption == "false") {//只添加标识
                        columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newValue)
                        columnNode.removeAttribute(ExcelConstants.ATTR_SourceType)
                    } else if (Inste_Key == "false" && Inste_Caption == "true") {//只添加名称
                        columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                        columnNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                    }

                } else {
                    let strings = newValue.split("|");
                    var columnNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                    columnNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, colIndex.toString());
                    columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, strings[1]);
                    columnNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                    columnNode.setParent(rowNode);
                    rowNode.addChild(columnNode);
                    if (Inste_Key == "true" && Inste_Caption == "true") {
                        if (Inste_H == "H") {
                            if (colIndex != 1) {
                                let preNode = rowNode.find("Cell", "CellIndex", (colIndex - 1).toString());
                                if (preNode) {
                                    preNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, (colIndex - 1).toString());
                                    preNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                    preNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                                } else {
                                    preNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                                    preNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, (colIndex - 1).toString());
                                    preNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                    preNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                                    preNode.setParent(rowNode);
                                    rowNode.addChild(preNode);
                                }
                            }
                        } else {
                            let rowsNode = rowNode.getParent();
                            let rowIndex = rowNode.getAttributeValueInt(ExcelConstants.ATTR_RowIndex, 0);
                            let cellIndex = cellNode.getAttributeValueInt(ExcelConstants.ATTR_CellIndex, 0);
                            let preRow = rowsNode!.find("Row", "RowIndex", (rowIndex - 1).toString());
                            let tag;
                            if (!preRow) {
                                var tagNode1 = new TagNode("Row");
                                tagNode1.setAttributeValue("RowIndex", (rowIndex - 1).toString());
                                rowsNode?.addChild(tagNode1);
                                tag = new TagNode("Cell");
                                tag.setAttributeValue("CellIndex", (colIndex).toString());
                                tag.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                tag.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                                tagNode1.addChild(tag);
                            } else {
                                tag = preRow!.find("Cell", "CellIndex", (cellIndex).toString());
                                if (!tag) {
                                    tag = new TagNode("Cell");
                                    tag.setAttributeValue("CellIndex", (colIndex).toString());
                                    preRow.addChild(tag);
                                }
                                tag!.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                                tag!.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");

                            }
                        }

                    } else if (Inste_Key == "true" && Inste_Caption == "false") {//只添加标识
                        columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, strings[1]);
                        columnNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                        columnNode.removeAttribute(ExcelConstants.ATTR_SourceType)
                    } else if (Inste_Key == "false" && Inste_Caption == "true") {//只添加名称
                        columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                        columnNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                    }

                }
                var selectSheetView = <SheetView>workSpace.getGraphicView().getSelectSheetView();
                xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
                xmlEntity.update(rowNode, true);
            } else {
                var row = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Row);
                row.setParent(rowsNode);
                row.setAttributeValue(ExcelConstants.ATTR_RowIndex, rowIndex.toString());
                rowsNode.addChild(row);
                let strings = newValue.split("|");
                var columnNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                columnNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, colIndex.toString());
                columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, strings[1]);
                columnNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                columnNode.setParent(row);
                row.addChild(columnNode);
                if (Inste_Key == "true") {
                    if (DataType != "Text" && DataType != "") {
                        var iTagNode = columnNode.ensureChild("Display").ensureChild("Format");
                        iTagNode.setAttributeValue("DataType", DataType);
                        if (DataType == "Dict") {
                            iTagNode.setAttributeValue("FieldKeys", FieldKeys);
                            iTagNode.setAttributeValue("ItemKey", ItemKey);
                        } else if (DataType == "Number") {
                            iTagNode.setAttributeValue("Format", Format);
                        } else if (DataType == "Money") {
                            iTagNode.setAttributeValue("Format", M_Format);
                        } else if (DataType == "Date") {
                            iTagNode.setAttributeValue("Format", D_Format);
                        } else if (DataType == "List" || DataType == "MultiList") {
                            if (list.length > 0) {
                                var split = list.split(";");
                                for (let i = 0; i < split.length; i++) {
                                    var splitElement = split[i];
                                    var split1 = splitElement.split(":");
                                    var tagNode = new TagNode("ListItem");
                                    tagNode.setAttributeValue("Value", split1[0]);
                                    tagNode.setAttributeValue("Text", split1[1]);
                                    if (split1[0] != "" && split1[1] != "") {
                                        iTagNode.addChild(tagNode);
                                    }
                                }
                            }
                        }

                    } else if (DataType = "Text") {
                        var iTagNode = columnNode.ensureChild("Display").ensureChild("Format");
                        iTagNode.setAttributeValue("DataType", DataType);
                    }
                }
                if (Inste_Key == "true" && Inste_Caption == "true") {
                    if (Inste_H == "H") {
                        if (colIndex != 1) {
                            var preNode = xmlEntity.getNodeFactory().createTagNode(ExcelConstants.NODE_Cell);
                            preNode.setAttributeValue(ExcelConstants.ATTR_CellIndex, (colIndex - 1).toString());
                            preNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                            preNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                            preNode.setParent(row);
                            row.addChild(preNode);
                        }
                    } else {
                        if (rowIndex != 1) {
                        let preRow = new TagNode("Row")
                        sheetNode.ensureChild("Rows").addChild(preRow);
                        preRow.setAttributeValue("RowIndex", (rowIndex - 1).toString());
                        let cellIndex = colIndex;
                        let tag = new TagNode("Cell");
                        tag.setAttributeValue(ExcelConstants.ATTR_CellIndex, cellIndex.toString());
                        tag!.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                        tag!.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                        preRow.addChild(tag);
                    }
                    }
                } else if (Inste_Key == "true" && Inste_Caption == "false") {//只添加标识
                    columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, strings[1]);
                    columnNode.setAttributeValue(BaseConstants.ATTR_TableKey, strings[0]);
                    columnNode.removeAttribute(ExcelConstants.ATTR_SourceType)
                } else if (Inste_Key == "false" && Inste_Caption == "true") {//只添加名称
                    columnNode.setAttributeValue(ExcelConstants.ATTR_Definition, newCaption);
                    columnNode.setAttributeValue(ExcelConstants.ATTR_SourceType, "Const");
                }
                var selectSheetView = <SheetView>workSpace.getGraphicView().getSelectSheetView();
                xmlEntity.getSelectionModel().select(selectSheetView.getTagNode());
                xmlEntity.update(rowsNode, true);
            }
        }
    }

    private setSourceFieldToDataMigration(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        // 从doc里获取数据
        var doc = form.document;
        var wfWorkSpace = <DataMigrationWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        let dataTable = doc.getByKey("ED_DataMigrationFieldDtl");
        wfWorkSpace.getGraphicView().doAddFieldsCmd(dataTable, xmlEntity, wfWorkSpace);
    };

    private setTargetFieldToDataMigration(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        // 从doc里获取数据
        var doc = form.document;
        var wfWorkSpace = <DataMigrationWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        let dataTable = doc.getByKey("ED_DataMigrationFieldDtl");
        wfWorkSpace.getGraphicView().doAddTargetFieldsCmd(dataTable, xmlEntity, wfWorkSpace)
    };



    /**
     * 修改数据流程方法
     * @param name
     * @param ctx
     * @param args
     * @private
     */
    private saveReportToXml(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        // 从doc里获取数据
        var doc = form.document;
        var type = args[0];
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form)!;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        var root = <ITagNode>xmlEntity.getRoot().getChildren()[1];
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(xmlEntity).getSingleSeletionItem();
        // Report属性处理
        if (PrintConstants.NODE_Cell_Data == type) { // 单元格数据
            let dataTable = doc.getByKey(PrintConstants.D_REPORT_CELL_INFO);
            if (dataTable.size() <= 0) return;
            let cell = YigoDesignFuns.getCell(selectItem);
            YigoDesignFuns.dealCellInfo(xmlEntity, dataTable, cell);
        } else if (PrintConstants.NODE_Cell_ViewStyle == type) { // 单元格样式
            let dataTable = doc.getByKey(PrintConstants.D_REPORT_CELL_DISPLAY);
            let cell = YigoDesignFuns.getCell(selectItem);
            YigoDesignFuns.dealCellStyle(xmlEntity, dataTable, cell);
        } else if (WfConstants.NODE_DataSource == type) { // 数据源
            let dataTable = doc.getByKey(PrintConstants.D_REPORT_TABLE_COLLECTION);
            let fieldTable = doc.getByKey(PrintConstants.D_REPORT_TABLE_FIELD);
            YigoDesignFuns.dealDataSourceTable(dataTable, fieldTable, root, xmlEntity);
        } else if (PrintConstants.NODE_Cell_DataStyle == type) { // 单元格数据样式
            let dataTable = doc.getByKey(PrintConstants.D_REPORT_FORMAT);
            let formatList = doc.getByKey(PrintConstants.D_REPORT_FORMAT_LIST);
            let multiList = doc.getByKey(PrintConstants.D_REPORT_FORMAT_MULTI_LIST);
            let cell = YigoDesignFuns.getCell(selectItem);
            YigoDesignFuns.dealCellDataStyle(xmlEntity, dataTable, formatList, multiList, cell);
        } else if (PrintConstants.NODE_Row_Porporty == type) { // row
            let dataTable = doc.getByKey(PrintConstants.D_ReportRow);
            let row = selectItem.getParent()!;
            YigoDesignFuns.dealRowData(xmlEntity, dataTable, row);
        } else if (PrintConstants.NODE_Para_Porporty == type) { // section
            let dataTable = doc.getByKey(PrintConstants.D_ReportSection);
            let section = selectItem.getParent()!.getParent()!.getParent()!;
            YigoDesignFuns.dealSectionData(xmlEntity, dataTable, section);
        } else if (PrintConstants.Node_Page_Opt == type) { // 页面设置
            let dataTable = doc.getByKey(PrintConstants.D_ReportSettingDetail);
            YigoDesignFuns.dealReportPageOpt(xmlEntity, dataTable, root);
        }
        // Excel 属性处理
        else if (ExcelConstants.Node_Cell_Porperty == type) { //单元格属性
            let dataTable = doc.getByKey(ExcelConstants.TBL_ExcelCellFormat);
            let formatList = doc.getByKey(ExcelConstants.TBL_ExcelFormatList);
            let multiList = doc.getByKey(ExcelConstants.TBL_ExcelFormatMultiList);
            let excelCell = YigoDesignFuns.getExcelCell(root, selectItem, wfWorkSpace);
            YigoDesignFuns.dealExcelCellProp(xmlEntity, dataTable, formatList, multiList, excelCell);
            (<ExcelWorkSpace>wfWorkSpace).getGraphicView().loadSheetView(xmlEntity);
            (<ExcelWorkSpace>wfWorkSpace).getSelectionModel().select(excelCell);
            xmlEntity.update(excelCell, false);
        } else if (ExcelConstants.Node_Cell_Expand == type) { //单元格拓展
            let dataTable = doc.getByKey(ExcelConstants.TBL_ExcelColumnExpand);
            let excelCell = YigoDesignFuns.getExcelCell(root, selectItem, wfWorkSpace);
            YigoDesignFuns.dealCellExpand(xmlEntity, dataTable, excelCell, wfWorkSpace)
        } else if (ExcelConstants.Node_ColAndRow_Size == type) { //行列尺寸
            let dataTable = doc.getByKey(ExcelConstants.TBL_ExcelCellSize);
            var ews = <ExcelWorkSpace>wfWorkSpace;
            let sheetView = <SheetView>ews.getGraphicView().getSelectSheetView()!;
            let sheetNode = sheetView.getTagNode();
            YigoDesignFuns.dealRowAndColumnSize(xmlEntity, dataTable, sheetNode, selectItem, wfWorkSpace);
        } else if (ExcelConstants.Node_Template_Porperty == type) { //模板属性
            let dataTable = doc.getByKey(ExcelConstants.TBL_ExcelProp);
            YigoDesignFuns.dealTemplateProp(xmlEntity, dataTable, root, wfWorkSpace, selectItem);
        }
        wfWorkSpace.reloadSource();
    }

    /**
     * 处理报表页面设置
     * @param xmlEntity
     * @param dataTable
     * @param root
     * @private
     */
    private static dealReportPageOpt(xmlEntity: IXmlEntity, dataTable: any, root: ITagNode) {
        if (dataTable.size() > 0) {
            let isVirtualPage = YigoDesignFuns.handleFieldNull(dataTable, "IsVirtualPage", "false");
            root.setAttributeValue("VirtualPage", isVirtualPage, "false");
            let type = dataTable.getByKey("Type");
            // 页面处理
            let predefined = YigoDesignFuns.handleFieldNull(dataTable, "PagePredefined", "A4;595;842")
            let pageHeight = YigoDesignFuns.handleFieldNull(dataTable, "PageHeight", "0");
            let pageWidth = YigoDesignFuns.handleFieldNull(dataTable, "PageWidth", "0");
            if (type == "Custom") {
                root.setAttributeValue("PageID", type);
                root.setAttributeValue("PageHeight", pageHeight);
                root.setAttributeValue("PageWidth", pageWidth);
            } else {
                let split = predefined.split(";");
                let pageId = split[0],
                    pageWidth = split[1],
                    pageHeight = split[2];
                root.setAttributeValue("PageID", pageId);
                root.setAttributeValue("PageHeight", pageHeight);
                root.setAttributeValue("PageWidth", pageWidth);
            }
            let orientation = YigoDesignFuns.handleFieldNull(dataTable, "Orientation", "Portrait");
            root.setAttributeValue("PageOrientation", orientation, "Portrait");
            // 纸张处理
            if (isVirtualPage == "false") { // 这里需要对模拟页进行处理
                let type = dataTable.getByKey("Type");
                if (type == "Custom") {
                    root.setAttributeValue("PaperID", type);
                    root.setAttributeValue("PaperHeight", pageHeight);
                    root.setAttributeValue("PaperWidth", pageWidth);
                } else {
                    let split = predefined.split(";");
                    let pageId = split[0],
                        pageWidth = split[1],
                        pageHeight = split[2];
                    root.setAttributeValue("PaperID", pageId);
                    root.setAttributeValue("PaperHeight", pageHeight);
                    root.setAttributeValue("PaperWidth", pageWidth);
                }
                root.setAttributeValue("PaperOrientation", orientation, "Portrait");
            } else {
                let paperType = dataTable.getByKey("PaperType");
                if (!paperType) { // 如果未填 不进行设置 再次点开默认会加载Page的设置
                    //root.removeAttribute("VirtualPage"); // 移除默认为false
                } else if (paperType == "Custom") {
                    let paperHeight = YigoDesignFuns.handleFieldNull(dataTable, "PaperHeight", "0");
                    let paperWidth = YigoDesignFuns.handleFieldNull(dataTable, "PaperWidth", "0");
                    root.setAttributeValue("PaperID", type);
                    root.setAttributeValue("PaperHeight", paperHeight);
                    root.setAttributeValue("PaperWidth", paperWidth);
                } else {
                    let predefined = YigoDesignFuns.handleFieldNull(dataTable, "PaperPredefined", "A4;595;842");
                    let split = predefined.split(";");
                    let pageId = split[0],
                        pageWidth = split[1],
                        pageHeight = split[2];
                    root.setAttributeValue("PaperID", pageId);
                    root.setAttributeValue("PaperHeight", pageHeight);
                    root.setAttributeValue("PaperWidth", pageWidth);
                }
                let paperOrientation = YigoDesignFuns.handleFieldNull(dataTable, "PaperOrientation", "Portrait");
                root.setAttributeValue("PaperOrientation", paperOrientation, "Portrait");
            }
            root.setAttributeValue("TopMargin", dataTable.getByKey("TopMargin"));
            root.setAttributeValue("RightMargin", dataTable.getByKey("RightMargin"));
            root.setAttributeValue("BottomMargin", dataTable.getByKey("BottomMargin"));
            root.setAttributeValue("LeftMargin", dataTable.getByKey("LeftMargin"));


            xmlEntity.update(root, false);
        }
    }

    /**
     * 获取Excel的cell单元格 不存在节点先创建
     * @param root
     * @param selectItem
     * @private
     */
    private static getExcelCell(root: ITagNode, selectItem: ITagNode, wfWorkSpace: IWorkSpace): ITagNode {
        let parent = selectItem.getParent();
        if (parent) { // 已被创建的cell
            return selectItem;
        } else {
            var rowIndex = parseInt(selectItem.getAttributeValue("rowindex")) + 1;
            var colIndex = parseInt(selectItem.getAttributeValue("colindex")) + 1;
            let sheetView = <SheetView>(<ExcelWorkSpace>wfWorkSpace).getGraphicView().getSelectSheetView()!;
            let sheetNode = <TagNode>sheetView.getTagNode();
            if (!sheetNode.getChild("Rows")) { // 没有Rows创建
                sheetNode.addChild(new TagNode("Rows"));
            }
            let rowsNode = sheetNode.getChild("Rows")!;
            let row = new TagNode("Row");
            let flag = true;
            for (let child of rowsNode.getChildren()) { // 尝试获取rowindex的Row
                if (child instanceof TagNode) {
                    if (rowIndex == parseInt(child.getAttributeValue("RowIndex"))) {
                        row = child;
                        flag = false;
                        break;
                    }
                }
            }
            // 没有row 创建
            if (flag) {
                row.setAttributeValue("RowIndex", String(rowIndex));
                rowsNode.addChild(row);
            }
            let cellNode = new TagNode("Cell");
            row.addChild(cellNode);
            cellNode.setAttributeValue("CellIndex", String(colIndex));
            return cellNode;
        }
    }


    private static dealRowAndColumnSize(xmlEntity: IXmlEntity, dataTable: any, sheet: ITagNode, selectItem: ITagNode, wfWorkSpace: any) {
        if (dataTable.size() > 0) {
            // 需要对节点是否存在进行分情况处理
            if (!selectItem.getParent()) {
                let rowindex = parseInt(selectItem.getAttributeValue("rowindex")) + 1;
                let colindex = parseInt(selectItem.getAttributeValue("colindex")) + 1;
                // RowHeight属性的添加修改
                if (!selectItem.getChild("Rows")) {
                    let tagNode = new TagNode("Rows");
                    sheet.addChild(tagNode);
                }
                let rows = sheet.getChild("Rows")!;
                let rowsChildren = rows.getChildren();
                let hasCell = false;
                let cells;
                for (var child of rowsChildren) {
                    let rowNode = <TagNode>child;
                    if (parseInt(rowNode.getAttributeValue("RowIndex")) == rowindex) { // 保留子节点 删除父节点
                        cells = rowNode.getChildren();
                        hasCell = rowNode.hasChild();
                        rows.removeChild(rowNode);
                    }
                }

                if (hasCell || dataTable.getByKey("Height") != 40) {
                    let rowNode = new TagNode("Row");
                    rowNode.setAttributeValue("RowIndex", String(rowindex));
                    rowNode.setAttributeValue("Height", YigoDesignFuns.handleFieldNull(dataTable, "Height", "0"), "40");
                    rows.addChild(rowNode);
                    if (hasCell && cells) {
                        for (var child of cells) { // 添加子节点
                            let cellNode = <TagNode>child;
                            rowNode.addChild(cellNode);
                        }
                    }
                }

                // column Wight 属性的添加修改
                if (!sheet.getChild("Columns")) {
                    let tagNode = new TagNode("Columns");
                    sheet.addChild(tagNode);
                }
                let columns = sheet.getChild("Columns")!;
                let children = columns.getChildren();
                var columnNode: TagNode;
                for (var child of children) {
                    columnNode = (<TagNode>child);
                    if (parseInt(columnNode.getAttributeValue("ColumnIndex")) == colindex) {
                        columns.removeChild(columnNode);
                        break;
                    }
                }

                // 直接删了重新加
                if (dataTable.getByKey("Width") != 80) {
                    columnNode = new TagNode("Column");
                    columnNode.setAttributeValue("ColumnIndex", String(colindex));
                    columnNode.setAttributeValue("Width", YigoDesignFuns.handleFieldNull(dataTable, "Width", "0"), "80");
                    columns.addChild(columnNode);
                }
            } else {
                // row属性的修改
                var rowNode = <ITagNode>selectItem.getParent()!;
                rowNode.setAttributeValue("Height", YigoDesignFuns.handleFieldNull(dataTable, "Height", "0"), "40");

                // Column属性的添加
                let colindex = parseInt(selectItem.getAttributeValue("CellIndex"));
                if (!sheet.getChild("Columns")) {
                    let tagNode = new TagNode("Columns");
                    sheet.addChild(tagNode);
                }
                let columns = sheet.getChild("Columns")!;
                let children = columns.getChildren();
                var columnNode: TagNode;
                for (var child of children) {
                    columnNode = (<TagNode>child);
                    if (parseInt(columnNode.getAttributeValue("ColumnIndex")) == colindex) {
                        columns.removeChild(columnNode);
                        break;
                    }
                }

                // 直接删了重新加
                if (dataTable.getByKey("Width") != 80) {
                    columnNode = new TagNode("Column");
                    columnNode.setAttributeValue("ColumnIndex", String(colindex));
                    columnNode.setAttributeValue("Width", YigoDesignFuns.handleFieldNull(dataTable, "Width", "0"), "80");
                    columns.addChild(columnNode);
                }
            }
            (<ExcelWorkSpace>wfWorkSpace).getGraphicView().loadSheetView(xmlEntity);
            (<ExcelWorkSpace>wfWorkSpace).getSelectionModel().select(sheet);
            xmlEntity.update(sheet, false);
        }
    }

    private static setCDataValue(root: ITagNode, value: string) {
        if (value || value == "") {
            for (let node of root.getChildren()) {
                if (node.getNodeType() == ENodeType.CDATA) {
                    node.setContent(`<![CDATA[${value}]]>`)
                    return;
                }
            }
            var node = new ContentNode(ENodeType.CDATA, "");
            root.addChild(node);
            node.setContent(`<![CDATA[${value}]]>`)
        }
    }

    private static dealCellExpand(xmlEntity: IXmlEntity, dataTable: any, cell: ITagNode, wfWorkSpace: any) {
        if (dataTable.size() > 0) {
            let isColumnExpand = YigoDesignFuns.handleFieldNull(dataTable, "IsColumnExpand", "false");
            xmlEntity.select(cell);
            cell.setAttributeValue("ColumnExpand", isColumnExpand, "false");
            cell.clearChildren(WfConstants.NODE_ColumnExpand);
            if (isColumnExpand == "true") {
                let columnExpandNode = new TagNode(WfConstants.NODE_ColumnExpand);
                columnExpandNode.setAttributeValue("ExpandType", YigoDesignFuns.handleFieldNull(dataTable, "ColumnExpandType"), "");
                columnExpandNode.setAttributeValue("ExpandSourceType", YigoDesignFuns.handleFieldNull(dataTable, "ColumnSourceType"), "");
                let columnContent = YigoDesignFuns.handleFieldNull(dataTable, "ColumnContent", "");
                YigoDesignFuns.setCDataValue(columnExpandNode, columnContent);
                cell.addChild(columnExpandNode);
            }
            (<ExcelWorkSpace>wfWorkSpace).getGraphicView().loadSheetView(xmlEntity);
            (<ExcelWorkSpace>wfWorkSpace).getSelectionModel().select(cell);
            xmlEntity.update(cell, false);
        }
    }

    /**
     * 处理Excel单元格属性
     * @param xmlEntity
     * @param dataTable
     * @param formatList
     * @param multiList
     * @param cell
     * @private
     */
    private static dealExcelCellProp(xmlEntity: IXmlEntity, dataTable: any, formatList: any, multiList: any, cell: ITagNode) {
        if (dataTable.size() > 0) {
            let displayNode = YigoDesignFuns.getChildNode(cell, WfConstants.NODE_Display);
            displayNode.clearChildren(WfConstants.NODE_Format);
            let formatNode = new TagNode(WfConstants.NODE_Format);
            displayNode.addChild(formatNode);
            let dataType = YigoDesignFuns.handleFieldNull(dataTable,"DataType", "Text");
            formatNode.setAttributeValue("DataType", dataType, "Text");
            switch (dataType) {
                case "Dict":
                    let itemKey = YigoDesignFuns.handleFieldNull(dataTable, "ItemKey");
                    if (itemKey == "") {
                        throw new Error("字典标识不能为空")
                    }
                    let fieldKeys = YigoDesignFuns.handleFieldNull(dataTable, "FieldKeys");
                    if (fieldKeys == "") {
                        throw new Error("字段列表不能为空")
                    }
                    formatNode.setAttributeValue("ItemKey", itemKey, "");
                    formatNode.setAttributeValue("FieldKeys", fieldKeys, "");
                    break;
                case "MultiDict":
                    formatNode.setAttributeValue("DataType", "MultiDict", "");
                    formatNode.setAttributeValue("ItemKey", YigoDesignFuns.handleFieldNull(dataTable, "MultiDictItemKey"), "");
                    formatNode.setAttributeValue("FieldKeys", YigoDesignFuns.handleFieldNull(dataTable, "MultiDictFieldKeys"), "");
                    break;
                case "Number":
                    formatNode.setAttributeValue("Format", YigoDesignFuns.handleFieldNull(dataTable, "FormatString"), "");
                    break;
                case "Money":
                    formatNode.setAttributeValue("Format", YigoDesignFuns.handleFieldNull(dataTable, "MoneyFormat"), "");
                    break;
                case "Date":
                    formatNode.setAttributeValue("Format", YigoDesignFuns.handleFieldNull(dataTable, "DateFormat"), "");
                    break;
                case "List":
                    formatNode.clearChildren();
                    YigoDesignFuns.sortDataTableRows(formatList);
                    for (var i = 0; i < formatList.getRowCount(); i++) {
                        formatList.setPos(i);
                        if (!formatList.rows[i] || formatList.getState() == 3) continue;
                        let listItem = new TagNode("ListItem");
                        listItem.setAttributeValue("Value", YigoDesignFuns.handleFieldNull(formatList, "ListValue"), "");
                        listItem.setAttributeValue("Text", YigoDesignFuns.handleFieldNull(formatList, "ListText"), "");
                        formatNode.addChild(listItem);
                    }
                    break;
                case "MultiList":
                    formatNode.clearChildren();
                    YigoDesignFuns.sortDataTableRows(multiList);
                    for (var i = 0; i < multiList.getRowCount(); i++) {
                        multiList.setPos(i);
                        if (!multiList.rows[i] || multiList.getState() == 3) continue;
                        let listItem = new TagNode("ListItem");
                        listItem.setAttributeValue("Value", YigoDesignFuns.handleFieldNull(multiList, "MultiValue"), "");
                        listItem.setAttributeValue("Text", YigoDesignFuns.handleFieldNull(multiList, "MultiText"), "");
                        formatNode.addChild(listItem);
                    }
                    break;
            }
        }
    }

    private static sortDataTableRows(dataTable: any) {
        dataTable.setShowDelete(true);
        var rows = dataTable.rows;
        var delCount = 0,
            length = dataTable.size();
        var sortRows = Array.from({length: length});
        for (var row of rows) {
            if (!row || (row.state && row.state == 3)) { // 将删除的放到后面
                sortRows[length - delCount - 1] = row;
                delCount++;
            } else {
                var index = row.vals[dataTable.indexByKey("Sequence")];
                sortRows[index - delCount - 1] = row;
            }
        }
        dataTable.rows = sortRows;
    }

    private static dealTemplateProp(xmlEntity: IXmlEntity, dataTable: any, root: ITagNode, wfWorkSpace: any, selectItem: ITagNode) {
        if (dataTable.size() > 0) {
            let caption = YigoDesignFuns.handleFieldNull(dataTable, "Caption", "");
            let isNeedLoadData = YigoDesignFuns.handleFieldNull(dataTable, "IsNeedLoadData", "false");
            root.setAttributeValue("Caption", caption, "");
            root.setAttributeValue("NeedLoadData", isNeedLoadData, "false");
            (<ExcelWorkSpace>wfWorkSpace).getGraphicView().loadSheetView(xmlEntity);
            (<ExcelWorkSpace>wfWorkSpace).getSelectionModel().select(root);
            xmlEntity.update(root, false);
        }

    }

    private static dealRowData(xmlEntity: IXmlEntity, dataTable: any, row: ITagNode) {
        if (dataTable.size() > 0) {
            let height = YigoDesignFuns.handleFieldNull(dataTable, "RowHeight", "0");
            let backColor = YigoDesignFuns.handleFieldNull(dataTable, "BackColor", "");
            let dtlCountEveryPage = YigoDesignFuns.handleFieldNull(dataTable, "DtlCountEveryPage", "0");
            let groupLevel = YigoDesignFuns.handleFieldNull(dataTable, "GroupLevel", "-1");
            let isLineBreak = YigoDesignFuns.handleFieldNull(dataTable, "IsLineBreak", "false");
            let pageBreak = YigoDesignFuns.handleFieldNull(dataTable, "IsPageBreak", "false");
            let tableKey = YigoDesignFuns.handleFieldNull(dataTable, "TableKey", "None");
            let groupKey = YigoDesignFuns.handleFieldNull(dataTable, "GroupKey", "");
            let rowType = YigoDesignFuns.handleFieldNull(dataTable, "RowType", "");
            row.setAttributeValue("Height", height, "0");
            row.setAttributeValue("BackColor", backColor, "");
            row.setAttributeValue("DtlCountEveryPage", dtlCountEveryPage, "0")
            row.setAttributeValue("GroupLevel", groupLevel, "-1");
            row.setAttributeValue("LineBreak", isLineBreak, "false");
            row.setAttributeValue("PageBreak", pageBreak, "false");
            row.setAttributeValue("TableKey", tableKey, "None");
            row.setAttributeValue("GroupKey", groupKey, "");
            row.setAttributeValue("Type", rowType, "");
            xmlEntity.update(row, false);
        }
    }

    /**
     * 处理section数据
     * @param xmlEntity
     * @param dataTable
     * @param section
     * @private
     */
    private static dealSectionData(xmlEntity: IXmlEntity, dataTable: any, section: ITagNode) {
        if (dataTable.size() > 0) {
            let key = YigoDesignFuns.handleFieldNull(dataTable, "Key", "");
            if (key == "") {
                throw new Error("段标志不能为空");
            }
            let type = YigoDesignFuns.handleFieldNull(dataTable, "Type", "");
            let caption = YigoDesignFuns.handleFieldNull(dataTable, "Caption", "");
            let minFillRowCount = YigoDesignFuns.handleFieldNull(dataTable, "MinFillRowCount", "0");
            let pageBreakPolicy = YigoDesignFuns.handleFieldNull(dataTable, "PageBreakPolicy", "None");
            let splitRow = YigoDesignFuns.handleFieldNull(dataTable, "IsSplitRow", "false");
            section.setAttributeValue("Key", key, "");
            section.setAttributeValue("Type", type, "");
            section.setAttributeValue("Caption", caption, "")
            section.setAttributeValue("MinFillRowCount", minFillRowCount, "0");
            section.setAttributeValue("PageBreakPolicy", pageBreakPolicy, "None");
            section.setAttributeValue("SplitRow", splitRow, "false");

            xmlEntity.update(section, false);
        }
    }

    /**
     * 处理字段空值返回默认值
     * @param dataTable
     * @param fieldKey
     * @param defaultValue
     * @private
     */
    private static handleFieldNull(dataTable: any, fieldKey: string, defaultValue?: any): any {
        let byKey = dataTable.getByKey(fieldKey);
        if (defaultValue) {
            return byKey ? byKey : defaultValue;
        }
        return byKey ? byKey : "";
    }

    private static dealCellDataStyle(xmlEntity: IXmlEntity, dataTable: any, formatList: any, multiList: any, cell: ITagNode) {
        if (dataTable.size() > 0) {
            let displayNode = <TagNode>cell.getChild("Display");
            if (!displayNode) {
                displayNode = new TagNode(WfConstants.NODE_Display);
                cell.addChild(displayNode);
            }
            displayNode.clearChildren(WfConstants.NODE_Format);
            let formatNode = new TagNode(WfConstants.NODE_Format);
            displayNode.addChild(formatNode);
            let dataType = YigoDesignFuns.handleFieldNull(dataTable, "DataType");
            formatNode.setAttributeValue("DataType", dataType, "");
            formatNode.setAttributeValue("Transformer", YigoDesignFuns.handleFieldNull(dataTable, "Transformer", ""), "");
            switch (dataType) {
                case "Dict":
                    let itemKey = YigoDesignFuns.handleFieldNull(dataTable, "ItemKey");
                    if (itemKey == "") {
                        throw new Error("字典标识不能为空")
                    }
                    let fieldKeys = YigoDesignFuns.handleFieldNull(dataTable, "FieldKeys");
                    if (fieldKeys == "") {
                        throw new Error("字段列表不能为空")
                    }
                    formatNode.setAttributeValue("ItemKey", itemKey, "");
                    formatNode.setAttributeValue("FieldKeys", fieldKeys, "");
                    break;
                case "MultiDict":
                    formatNode.setAttributeValue("ItemKey", YigoDesignFuns.handleFieldNull(dataTable, "MultiDictItemKey"), "");
                    formatNode.setAttributeValue("FieldKeys", YigoDesignFuns.handleFieldNull(dataTable, "MultiDictFieldKeys"), "");
                    break;
                case "Number":
                    formatNode.setAttributeValue("FormatString", YigoDesignFuns.handleFieldNull(dataTable, "FormatString"), "");
                    break;
                case "Money":
                    formatNode.setAttributeValue("FormatString", YigoDesignFuns.handleFieldNull(dataTable, "MoneyFormat"), "");
                    break;
                case "Date":
                    formatNode.setAttributeValue("FormatString", YigoDesignFuns.handleFieldNull(dataTable, "DateFormat"), "");
                    break;
                case "List":
                    formatNode.clearChildren();
                    YigoDesignFuns.sortDataTableRows(formatList);
                    for (var i = 0; i < formatList.getRowCount(); i++) {
                        formatList.setPos(i);
                        if (!formatList.rows[i] || formatList.getState() == 3) continue;
                        let listItem = new TagNode("ListItem");
                        listItem.setAttributeValue("Value", YigoDesignFuns.handleFieldNull(formatList, "ListValue"), "");
                        listItem.setAttributeValue("Text", YigoDesignFuns.handleFieldNull(formatList, "ListText"), "");
                        formatNode.addChild(listItem);
                    }
                    break;
                case "MultiList":
                    formatNode.clearChildren();
                    YigoDesignFuns.sortDataTableRows(multiList);
                    for (var i = 0; i < multiList.getRowCount(); i++) {
                        multiList.setPos(i);
                        if (!multiList.rows[i] || multiList.getState() == 3) continue;
                        let listItem = new TagNode("ListItem");
                        listItem.setAttributeValue("Value", YigoDesignFuns.handleFieldNull(multiList, "MultiValue"), "");
                        listItem.setAttributeValue("Text", YigoDesignFuns.handleFieldNull(multiList, "MultiText"), "");
                        formatNode.addChild(listItem);
                    }
                    break;
            }
            xmlEntity.update(cell, false);
        }
    }

    /**
     * 获取节点下的child 如果没有就新增
     * @param node
     * @param tag 标签
     * @private
     */
    public static getChildNode(node: ITagNode, tag: string): ITagNode {
        let child = node.getChild(tag);
        if (!child) {
            child = new TagNode(tag);
            node.addChild(child);
        }
        return child;
    }

    private static dealCellStyle(xmlEntity: IXmlEntity, dataTable: any, cell: ITagNode) {
        if (dataTable.size() > 0) {
            cell.setAttributeValue("FillEmptyContent", YigoDesignFuns.handleFieldNull(dataTable, "FillEmptyContent", "false"), "false");
            let overflow = YigoDesignFuns.handleFieldNull(dataTable, "Overflow", "0");
            if (overflow == "") {
                throw new Error("");
            }
            cell.setAttributeValue("Overflow", overflow, "0");
            let displayNode = YigoDesignFuns.getChildNode(cell, WfConstants.NODE_Display);
            displayNode.setAttributeValue("HAlign", YigoDesignFuns.handleFieldNull(dataTable, "HAlign", "Center"), "Center");
            displayNode.setAttributeValue("VAlign", YigoDesignFuns.handleFieldNull(dataTable, "VAlign", "Center"), "Center");
            displayNode.setAttributeValue("BackColor", YigoDesignFuns.handleFieldNull(dataTable, "BackColor", ""), "");
            displayNode.setAttributeValue("ShowType", YigoDesignFuns.handleFieldNull(dataTable, "ShowType", "TEXT"), "TEXT");
            displayNode.setAttributeValue("EncodingType", YigoDesignFuns.handleFieldNull(dataTable, "EncodingType", ""), "");
            displayNode.setAttributeValue("ErrorCorrectionLevel", YigoDesignFuns.handleFieldNull(dataTable, "ErrorCorrectionLevel", ""), "");
            displayNode.setAttributeValue("EnableZeroShow", YigoDesignFuns.handleFieldNull(dataTable, "EnableZeroShow", "false"), "false");
            displayNode.setAttributeValue("ZeroShowString", YigoDesignFuns.handleFieldNull(dataTable, "ZeroShowString"), "");
            displayNode.setAttributeValue("Margin", YigoDesignFuns.handleFieldNull(dataTable, "Margin", "0"), "0");
            displayNode.setAttributeValue("ForeColor", YigoDesignFuns.handleFieldNull(dataTable, "ForeColor"), "");
            let leftMargin = YigoDesignFuns.handleFieldNull(dataTable, "LeftMargin", "0"),
                topMargin = YigoDesignFuns.handleFieldNull(dataTable, "TopMargin", "0"),
                rightMargin = YigoDesignFuns.handleFieldNull(dataTable, "RightMargin", "0"),
                bottomMargin = YigoDesignFuns.handleFieldNull(dataTable, "BottomMargin", "0");
            let padding = leftMargin + "," + topMargin + "," + rightMargin + "," + bottomMargin;
            cell.setAttributeValue("Padding", padding, "0,0,0,0");

            let fontNode = YigoDesignFuns.getChildNode(displayNode, WfConstants.NODE_Font);
            fontNode.setAttributeValue("Name", YigoDesignFuns.handleFieldNull(dataTable, "Font"), "");
            fontNode.setAttributeValue("Size", YigoDesignFuns.handleFieldNull(dataTable, "FontSize", "-1"), "-1");
            fontNode.setAttributeValue("Bold", YigoDesignFuns.handleFieldNull(dataTable, "Bold", "false"), "false");
            fontNode.setAttributeValue("Italic", YigoDesignFuns.handleFieldNull(dataTable, "Italic", "false"), "false");
            if (!fontNode.getAttributes().length) displayNode.removeChild(fontNode); // 如果节点没有任何属性 则直接删掉
            if (dataTable.getByKey("Margin")) {
                let imageStyleNode = YigoDesignFuns.getChildNode(displayNode, WfConstants.NODE_ImageStyle);
                imageStyleNode.setAttributeValue("ImageScaleType", YigoDesignFuns.handleFieldNull(dataTable, "ImageScaleType", "Fit_XY"), "Fit_XY");
                if (!imageStyleNode.getAttributes().length) displayNode.removeChild(imageStyleNode);
            }
            if (!displayNode.getChildren().length && !displayNode.getAttributes().length) cell.removeChild(displayNode);
            xmlEntity.update(cell, false);
        }
    }

    /**
     * 处理报表数据源
     * @param dataTable
     * @param fieldTable
     * @param root
     * @param xmlEntity
     * @private
     */
    private static dealDataSourceTable(dataTable: any, fieldTable: any, root: ITagNode, xmlEntity: IXmlEntity) {
        let dataSource = <TagNode>root.find(WfConstants.NODE_DataSource, "", "");
        dataSource.clearChildren(); // 删除重新添加
        YigoDesignFuns.sortDataTableRows(dataTable);
        for (let i = 0; i < dataTable.getRowCount(); i++) {
            dataTable.setPos(i);
            if (!dataTable.rows[i] || dataTable.getState() == 3)
                continue;
            let tableMark = dataTable.getByKey("TableMark");
            if (tableMark == "") {
                throw new Error("标识不可为空");
            }
            let parentOID = dataTable.getByKey("OID");
            let table = new TagNode(WfConstants.NODE_Table);
            let dbTableKey = dataTable.getByKey("DbTableKey") == null ? "" : dataTable.getByKey("DbTableKey");
            let description = dataTable.getByKey("Description") == null ? "" : dataTable.getByKey("Description");
            let filter = dataTable.getByKey("Filter") == null ? "" : dataTable.getByKey("Filter");
            let statement = dataTable.getByKey("Statement") == null ? "" : dataTable.getByKey("Statement");
            let sourceType = YigoDesignFuns.handleFieldNull(dataTable, "SourceType");
            dataSource.addChild(table);
            table.setAttributeValue("Key", tableMark);
            table.setAttributeValue("Caption", dataTable.getByKey("TableName"), "");
            table.setAttributeValue("SourceType", sourceType, "");
            table.setAttributeValue("DBTableKey", dbTableKey, "");
            table.setAttributeValue("Description", description, "");
            table.setAttributeValue("Filter", filter, "");
            table.setAttributeValue("Statement", statement, "");

            YigoDesignFuns.sortDataTableRows(fieldTable);
            for (let j = 0; j < fieldTable.getRowCount(); j++) {
                fieldTable.setPos(j);
                if (!fieldTable.rows[j] || fieldTable.getState() == 3)
                    continue;
                let rowPOID = fieldTable.getByKey("POID");
                if (parentOID == rowPOID) {
                    let field = new TagNode(WfConstants.NODE_Field);
                    table.addChild(field);
                    field.setAttributeValue("Key", YigoDesignFuns.handleFieldNull(fieldTable, "ColumnKey"));
                    field.setAttributeValue("Caption", YigoDesignFuns.handleFieldNull(fieldTable, "ColumnName"));
                    field.setAttributeValue("DBFieldKey", YigoDesignFuns.handleFieldNull(fieldTable, "DbFieldKey"), "");
                    field.setAttributeValue("Description", YigoDesignFuns.handleFieldNull(fieldTable, "Description"), "");
                }
            }
        }
        xmlEntity.update(root, false);
    }

    private static getCell(selectItem: ITagNode): ITagNode {
        // 数据不完全
        var rows = selectItem.getParent()!.getParent()!.getChildren()!;
        var rowIndex = rows.indexOf(selectItem.getParent()!);
        var parent = <ITagNode>rows[rowIndex];
        var row = parent.getChildren()!;
        var columnIndex = row.indexOf(selectItem);
        var cell = <ITagNode>row[columnIndex];
        // 合并单元格的主格
        if (selectItem.getAttributeValue("IsMerged") == "true" && selectItem.getAttributeValue("IsMergedHead") != "true") {
            var mergedColumnSpan = parseInt(selectItem.getAttributeValue("MergedColumnSpan") || "0")
            var mergedRowSpan = parseInt(selectItem.getAttributeValue("MergedRowSpan") || "0")
            var parent = <ITagNode>rows[rowIndex - mergedRowSpan];
            var row = parent.getChildren()!;
            cell = <ITagNode>row[columnIndex - mergedColumnSpan];
        }
        return cell;
    }

    public static isNotEmpty(str: string): boolean {
        return str != null && str != "";
    }

    /**
     * 处理单元格数据
     * @param xmlEntity
     * @param dataTable
     * @param cell
     * @private
     */
    private static dealCellInfo(xmlEntity: IXmlEntity, dataTable: any, cell: ITagNode) {
        if (dataTable.getRowCount() > 0) {
            let type = dataTable.getByKey("ContentType");
            let sourceType = YigoDesignFuns.handleFieldNull(dataTable, PrintConstants.ATTR_SourceType);
            cell.setAttributeValue(PrintConstants.ATTR_Key, dataTable.getByKey(PrintConstants.ATTR_Key));
            let caption = YigoDesignFuns.handleFieldNull(dataTable, PrintConstants.ATTR_Caption);
            cell.setAttributeValue(PrintConstants.ATTR_Caption, caption, "");
            let child = cell.getChild("CellText");
            if (child == null && caption.length > 0) {
                let cellText = YigoDesignFuns.getChildNode(cell, "CellText");
                cellText.setCDATAValue(caption);
            } else if (child != null) {
                child.setCDATAValue(caption);
            }
            cell.setAttributeValue(PrintConstants.ATTR_Type, type, "Text");
            cell.setAttributeValue("IsSummary", YigoDesignFuns.handleFieldNull(dataTable, "IsSummary", "false"), "false");
            cell.setAttributeValue("IsPrimary", YigoDesignFuns.handleFieldNull(dataTable, "IsPrimary", "false"), "false");
            if (type == "Image") {
                cell.setAttributeValue("ImageSourceType", YigoDesignFuns.handleFieldNull(dataTable, "ImageSourceType", "Data"), "Data");
                cell.setAttributeValue("Path", YigoDesignFuns.handleFieldNull(dataTable, "Path"), "");
            }
            cell.removeAttribute("TableKey");
            cell.removeAttribute("FieldKey");
            cell.removeAttribute("Formula");
            cell.removeAttribute("PageNo");
            cell.removeAttribute("Impl");
            cell.removeAttribute("SystemContent");
            switch (sourceType) {
                case "Field":
                    let tableKey = YigoDesignFuns.handleFieldNull(dataTable, "TableKey");
                    if (tableKey == "") {
                        throw new Error("表标识不能为空");
                    }
                    let fieldKey = YigoDesignFuns.handleFieldNull(dataTable, "FieldKey");
                    if (fieldKey == "") {
                        throw new Error("字段域不能为空");
                    }
                    cell.setAttributeValue(PrintConstants.ATTR_SourceType, sourceType, "");
                    cell.setAttributeValue("TableKey", tableKey, "");
                    cell.setAttributeValue("FieldKey", fieldKey, "");
                    break;
                case "Formula":
                    let formula = YigoDesignFuns.handleFieldNull(dataTable, "Formula");
                    if (formula == "") {
                        throw new Error("公式不能为空");
                    }
                    cell.setAttributeValue(PrintConstants.ATTR_SourceType, sourceType, "");
                    cell.setAttributeValue("Formula", formula, "");
                    break;
                case "Interface":
                    let impl = YigoDesignFuns.handleFieldNull(dataTable, "Impl");
                    if (impl == "") {
                        throw new Error("接口不能为空");
                    }
                    cell.setAttributeValue(PrintConstants.ATTR_SourceType, sourceType, "");
                    cell.setAttributeValue("Impl", impl, "");
                    break;
                case "PageNo":
                    let pageNo = YigoDesignFuns.handleFieldNull(dataTable, "PageNo");
                    if (pageNo == "") {
                        throw new Error("页码不能为空");
                    }
                    cell.setAttributeValue(PrintConstants.ATTR_SourceType, sourceType, "");
                    cell.setAttributeValue("PageNo", pageNo, "");
                    break;
                case "System":
                    let systemContent = YigoDesignFuns.handleFieldNull(dataTable, "SystemContent");
                    if (systemContent == "") {
                        throw new Error("系统域不能为空");
                    }
                    cell.setAttributeValue(PrintConstants.ATTR_SourceType, sourceType, "");
                    cell.setAttributeValue("SystemContent", systemContent, "");
                    break;
                case "Const":
                    cell.setAttributeValue(PrintConstants.ATTR_SourceType, sourceType, "");
                    break;
            }
            let hasColumnExpand = YigoDesignFuns.handleFieldNull(dataTable, "HasColumnExpand", "false");
            cell.setAttributeValue("GroupType", YigoDesignFuns.handleFieldNull(dataTable, "GroupType", "None"), "None");
            cell.setAttributeValue("SortType", YigoDesignFuns.handleFieldNull(dataTable, "SortType", "None"), "None");
            cell.setAttributeValue("MergeDetail", YigoDesignFuns.handleFieldNull(dataTable, "MergeDetail", "false"), "false");
            cell.setAttributeValue("MergeTopGroup", YigoDesignFuns.handleFieldNull(dataTable, "MergeTopGroup", "false"), "false");
            cell.setAttributeValue("MergeBottomGroup", YigoDesignFuns.handleFieldNull(dataTable, "MergeBottomGroup", "false"), "false");
            cell.setAttributeValue("ColumnExpand", hasColumnExpand, "false");
            // ColumnExpand
            cell.clearChildren(WfConstants.NODE_ColumnExpand);
            if (hasColumnExpand == "true") {
                let columnExpandNode = new TagNode(WfConstants.NODE_ColumnExpand);
                columnExpandNode.setAttributeValue("ExpandType", YigoDesignFuns.handleFieldNull(dataTable, "ColumnExpandType"), "");
                columnExpandNode.setAttributeValue("SourceType", YigoDesignFuns.handleFieldNull(dataTable, "ColumnSourceType"), "");
                columnExpandNode.setAttributeValue("ColumnKey", YigoDesignFuns.handleFieldNull(dataTable, "ColumnKey"), "");
                let columnContent = YigoDesignFuns.handleFieldNull(dataTable, "ColumnContent");
                YigoDesignFuns.setCDataValue(columnExpandNode, columnContent);
                cell.addChild(columnExpandNode);
            }
            // rowGroup
            let rowTag = YigoDesignFuns.handleFieldNull(dataTable, "RowTag"),
                rowItemKey = YigoDesignFuns.handleFieldNull(dataTable, "RowItemKey"),
                rowContent = YigoDesignFuns.handleFieldNull(dataTable, "RowContent");
            cell.clearChildren(WfConstants.NODE_RowGroup);
            if (YigoDesignFuns.isNotEmpty(rowTag) || YigoDesignFuns.isNotEmpty(rowItemKey) || YigoDesignFuns.isNotEmpty(rowContent)) {
                let rowGroup = new TagNode(WfConstants.NODE_RowGroup);
                rowGroup.setAttributeValue("Tag", rowTag, "");
                rowGroup.setAttributeValue("ItemKey", rowItemKey, "");
                YigoDesignFuns.setCDataValue(rowGroup, rowContent);
                cell.addChild(rowGroup);
            }
            xmlEntity.update(cell, false);
        }
    }

    private saveColumnToXml(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var columnType = args[0];
        var columnWidth = args[1];
        var columnVisable = args[2];
        var extendKey = args[3];
        var isLock = args[4];
        var columnIndex = args[5];
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(xmlEntity).getSingleSeletionItem();
        let sectionNode = selectItem.getParent()!.getParent()!.getParent();
        let children = sectionNode!.getChildren();
        let columns = (<ITagNode>children[0]).getChildren();
        let columnNode = <ITagNode>columns[columnIndex];
        columnNode.setAttributeValue(WfConstants.ATTR_Type, columnType, 'Fix');
        columnNode.setAttributeValue(PrintConstants.ATTR_Width, columnWidth.toString(), '');
        columnNode.setAttributeValue(PrintConstants.ATTR_Visible, columnVisable, '');
        columnNode.setAttributeValue(PrintConstants.ATTR_ExpandKey, extendKey, '');
        columnNode.setAttributeValue(PrintConstants.ATTR_Lock, isLock, 'false');
        xmlEntity.update(columnNode, false);
        wfWorkSpace.reloadSource();
    }

    private static getWorkspace(form: any): IWorkSpace | null {
        if (!form) return null;
        //var component = form.getComponent(YigoDesignFuns.workflowFieldKey);
        var compList = form.getComponentList();
        for (var i in compList) {
            var com = form.getComponentList()[i];
            if (com.type == 10000 && com.custom && com.custom.workspace) {
                return com.custom.workspace;
            } else if (com.type == 10000 && com.impl && com.impl.custom && com.impl.custom.workspace){
                return com.impl.custom.workspace;
            }
        }
        return YigoDesignFuns.getWorkspace(form.getParentForm());
        //if (!component || !component.custom) return YigoDesignFuns.getWorkspace(form.getParentForm());
        //return <WorkSpace> component.custom.workspace;
    }

    private getGridSelectedValues(evaluator: any, name: string, ctx: any, args: any[]): string {
        var form = ctx.form;
        var gridKey = args[0];
        var selectColKey = args[1];
        var valueColKey = args[2];
        var grid = form.getComponent(gridKey);

        var values = "";
        var count = grid.getRowCount();
        for (var i = 0; i < count; i++) {
            var isSelect = grid.getValueByKey(i, selectColKey);
            if (isSelect) {
                var tmpValue = grid.getValueByKey(i, valueColKey);
                values = (values ? (values += "," + tmpValue) : tmpValue);
            }
        }
        return values;
    }

    /*     private getDeployWorkflowOID(evaluator: any, name: string, ctx: any, args: any[]): any {
            var form = ctx.form;
            var oid = form.getOID();
            var itemKey = form.getDataObjectKey();
            var workflowKey = form.getValueByKey('WorkflowKey');
            var oid;
            var item = new YIUI.DictService(form).locate(itemKey, 'WorkflowKey', workflowKey, undefined, undefined, 1);
            if (item) {
                oid = item.oid;
            }
            return oid ? oid : 0;
        }
     */
    /**
     * 更新表格对应的节点信息
     * @param args[0] gridKey
     * @param args[1] 表格对应集合的TagName
     * @param args[2] 行对应的TagName
     * @param args[3] 更新内容所在列的序号
     */
    private updateNode(evaluator: any, name: string, ctx: any, args: any[]): void {
        var gridKey = args[0];
        var gridTagName = args[1];
        var rowTagName = args[2];
        var xmlCellKey = args[3];

        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        if (form && selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            var tagGrid = tagNode.ensureChild(gridTagName);
            var grid = form.getComponent(gridKey);
            var count = grid.getRowCount();
            tagGrid.clearChildren(rowTagName, true);
            for (var i = 0; i < count; i++) {
                var xml = grid.getValueByKey(i, xmlCellKey); //grid.getValueAt(i, colIndex);
                if (xml) {
                    var node: TagNode = <TagNode>XmlEntity.parseTagNode(xml);
                    if (node.isUserDefine()) {
                        tagGrid.addChild(node);
                    }
                }
            }
            wfWorkSpace.reloadSource();
        }
    }

    /**
     * 更新表格对应的字典节点信息
     * @param args[0] gridKey
     * @param args[1] gridTagName 表格对应集合的TagName
     * @param args[2] rowTagName 行对应的TagName
     * @param args[3] itemKey 字典标志
     * @param args[4] attrKey 行关键属性
     * @param args[5] attrValue 行关键值
     */
    private async updateDictionaryNode(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var gridKey = args[0];
        var gridTagName = args[1];
        var rowTagName = args[2];
        var itemKey = args[3];
        var attrKey = args[4];
        var attrValue = args[5];

        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        if (form && selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            var tagGrid = tagNode.ensureChild(gridTagName);
            var grid = form.getComponent(gridKey);
            var count = grid.getRowCount();
            tagGrid.clearChildren(rowTagName, false, attrKey, attrValue);
            if (count > 0) {
                var node = new DictionaryTagNode(itemKey);
                for (var i = 0; i < count; i++) {
                    var item = grid.getValueAt(i, 0);
                    var dictID = item ? item.oid : -1;
                    var code = await form.eval(`GetDictValue('${itemKey}', ${dictID}, 'Code')`, ctx, args);
                    if (code) {
                        node.addCode(code);
                    }
                }
                node.hasData() && tagGrid.addChild(node);
            }
            wfWorkSpace.reloadSource();
        }
    }

    private parseToOperationXML(evaluator: any, name: string, ctx: any, args: any[]): string {
        var code = args[0];
        var caption = args[1];
        if (GlobalVariable.G_DevelopCode == code) {
            return "";
        }
        var item = new OperationTagNode(code, caption);
        item.setAction(RunDictFormula.parseToRunDictFormulaStr(code));
        return item.toXml(true);
    }

    private parseToFormulaXML(evaluator: any, name: string, ctx: any, args: any[]): string {
        var tagName = args[0];
        var code = args[1];
        var item = new FormulaTagNode(tagName, code);
        item.setFormula(RunDictFormula.parseToRunDictFormulaStr(code));
        return item.toXml(true);
    }

    private parseToRunDictFormula(evaluator: any, name: string, ctx: any, args: any[]): string {
        var code = args[0];
        return RunDictFormula.parseToRunDictFormulaStr(code);
    }

    private updateVersionToDesign(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var version = args[0];
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        root.setAttributeValue(GlobalConstants.S_Version, version);
    }

    /**
     * 将xml中的部分信息更新到字典yigo表单界面上
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private updateWorkflowAttrToUI(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var workflowKeyField = args[0];
        var captionField = args[1];
        var xmlField = args[2];
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var xmlEntity = wfWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        var key = root.getAttributeValue(GlobalConstants.S_Key);
        var caption = root.getAttributeValue(GlobalConstants.S_Caption);
        var xml = xmlEntity.getXml(true);
        form.setComponentValue(workflowKeyField, key);
        form.setComponentValue(captionField, caption);
        form.setComponentValue(xmlField, xml);
    }

    private getDesignXml(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var xmlEntity = wfWorkSpace.getXmlEntity();
        return xmlEntity.getXml(true);
    }

    /**
     * 获取工作流配置根节点的属性值
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getWorkflowAttrValue(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var attrKey = args[0];
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var xmlEntity = wfWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        return root.getAttributeValue(attrKey);
    }

    /**
     * 获取报表选中段的xml
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getSelectSectionXML(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = <PrintWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        let sectionView = printWorkSpace.getGraphicView().getSectionViews()!;
        if (!sectionView) return printWorkSpace.toXml(false);
        return sectionView.getTagNode().toXml(false);
    }

    /**
     * 获取报表XML
     * @param name
     * @param ctx
     * @param args
     * @private
     */
    private getReportXML(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = <PrintWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        return printWorkSpace.toXml(false);
    }

    /**
     * 获取报表配置根节点的属性值
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getPrintAttrValue(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var attrKey = args[0];
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;

        var xmlEntity = printWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        return root.getAttributeValue(attrKey);
    }

    /**  * 获取Excel配置根节点的属性值
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getExcelAttrValue(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var attrKey = args[0];
        var excelWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!excelWorkSpace) return;

        var xmlEntity = excelWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        return root.getAttributeValue(attrKey);
    }

    /**
     * 获取Excel关联表单
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getExcelFormKey(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var attrKey = args[0];
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;

        var xmlEntity = printWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        return root.getAttributeValue("FormKey");
    }

    /**
     * 获取数据迁移key
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getSrcDataObjectKey(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        var xmlEntity = printWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        return root.getAttributeValue("SrcDataObjectKey");
    }

    /**
     * 获取数据迁移key
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getTagDataObjectKey(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        var xmlEntity = printWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        return root.getAttributeValue("TgtDataObjectKey");
    }

    /**
     * 获取数据迁移选择的字段key
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getFieldKey(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        var xmlEntity = printWorkSpace.getXmlEntity();
        let tagNode = xmlEntity.getSelectionModel().getSingleSeletionItem()?.getTagNode();
        if (tagNode?.getTagName() == "SourceField") {
            return tagNode?.getAttributeValue(DataMigrationConstants.Attr_Key, "");
        } else if (tagNode?.getTagName() == "TargetField") {
            return tagNode?.getAttributeValue("FieldKey", "");
        }
    }

    /**
     * 获取数据迁移选择的线的tablekey
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getTagTableKeyByLin(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        var xmlEntity = printWorkSpace.getXmlEntity();
        let tagNode = xmlEntity.getSelectionModel().getSingleSeletionItem()?.getTagNode();
        return tagNode?.getAttributeValue("TargetTableKey", "");
    }
    /**
     * 获取数据迁移选择的线的Filedkey
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getTagFieldKeyByLin(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        var xmlEntity = printWorkSpace.getXmlEntity();
        let tagNode = xmlEntity.getSelectionModel().getSingleSeletionItem()?.getTagNode();
        return tagNode?.getAttributeValue("TargetFieldKey", "");
    }

    //获取数据迁移选择字段的tablekey
    private getDataMigrationTableKey(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var printWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!printWorkSpace) return;
        var xmlEntity = printWorkSpace.getXmlEntity();
        let tagNode = xmlEntity.getSelectionModel().getSingleSeletionItem()?.getTagNode();
        if (tagNode?.getTagName() == "SourceField") {
            return tagNode.getParent()?.getAttributeValue(DataMigrationConstants.Attr_Key, "");
        } else if (tagNode?.getTagName() == "TargetField") {
            return tagNode.getParent()?.getAttributeValue("TableKey", "");
        } else if (tagNode?.getTagName() == DataMigrationConstants.NODE_SourceTable) {
            return tagNode?.getAttributeValue(DataMigrationConstants.Attr_Key, "");
        }
        return tagNode?.getAttributeValue("TableKey", "");
    }

    /**
     *
     * @param ctx
     * @private
     */
    private static getSelectionItem(context: any) : ISelectable | undefined{
        var workSpace = YigoDesignFuns.getWorkspace(context.form);
        if (!workSpace) return;
        var xmlEntity = workSpace.getXmlEntity();
        return xmlEntity.getSelectionModel().getSingleSeletionItem();
    }

    /**
     * 获取报表配置根节点的属性值
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getDataMapRootAttrValue(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var attrKey = args[0];
        var workSpace = <DataMapWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!workSpace) return;
        if(attrKey == CommonConstant.NODE_SrcFormKey){
            return workSpace.getGraphicView().getSrcFormKey();
        }else if(attrKey == CommonConstant.NODE_TgtFormKey){
            return workSpace.getGraphicView().getTgtFormKey();
        }else if(attrKey == CommonConstant.NODE_SrcDataObjectKey){
            return workSpace.getGraphicView().getSrcDataObjectKey();
        }else if(attrKey == CommonConstant.NODE_TgtDataObjectKey){
            return workSpace.getGraphicView().getTgtDataObjectKey();
        }
    }

    private getFeedbackFormKey(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        let workSpace = YigoDesignFuns.getWorkspace(form);
        if (!workSpace) return;
        let xmlEntity = workSpace.getXmlEntity();
        let children = xmlEntity.getTagRoot().getChildren();
        for(let child of children){
            if((<ITagNode>child).getTagName() == CommonConstant.NODE_FeedbackCollection){
                let feedbackObject = (<ITagNode>child).getChildren();
                for (let object of feedbackObject){

                    let find = (<ITagNode>object).find(CommonConstant.NODE_FeedbackTable,CommonConstant.ATTR_TableKey,args[0]);
                    if(find){
                        return (<ITagNode>object).getAttributeValue(CommonConstant.NODE_FormKey);
                    }
                }
            }
        }
    }

    private getDataMapFormKeyByField(evaluator: any, name: string, ctx: any, args: any[]){
        let selectionItem = YigoDesignFuns.getSelectionItem(ctx);
        let tagNode = selectionItem?.getTagNode();
        if (tagNode?.getTagName() == CommonConstant.NODE_SourceField) {
            return tagNode.getParent()!.getParent()!.getParent()!.getAttributeValue(CommonConstant.NODE_SrcFormKey, "");
        }else if(tagNode?.getTagName() == CommonConstant.NODE_TargetField){
            return tagNode.getParent()!.getParent()!.getParent()!.getAttributeValue(CommonConstant.NODE_TgtFormKey, "");
        }else if(tagNode?.getTagName() == CommonConstant.NODE_FeedbackField){
            return tagNode.getParent()!.getParent()!.getAttributeValue(CommonConstant.NODE_FormKey, "");
        }
    }

    private getDataMapTableKey(evaluator: any, name: string, ctx: any, args: any[]) {
        let selectionItem = YigoDesignFuns.getSelectionItem(ctx);
        let tagNode = selectionItem?.getTagNode();
        if (tagNode?.getTagName() == "SourceField" || tagNode?.getTagName() == "TargetField") {
            return tagNode.getParent()?.getAttributeValue("Key", "");
        } else if(tagNode?.getTagName() == CommonConstant.NODE_FeedbackField) {
            return tagNode.getParent()?.getAttributeValue(CommonConstant.ATTR_TableKey, "");
        }else{
            return tagNode?.getAttributeValue("Key", "");
        }
    }

    private getDataMapFieldKey(evaluator: any, name: string, ctx: any, args: any[]) {
        let selectionItem = YigoDesignFuns.getSelectionItem(ctx);
        let tagNode = selectionItem?.getTagNode();
        let fieldKey;
        if( tagNode?.getTagName() == CommonConstant.NODE_SourceField && !tagNode?.hasAttribute(CommonConstant.NODE_Definition)){
            fieldKey = tagNode?.getAttributeValue(CommonConstant.S_Key);
        }else{
            fieldKey = tagNode?.getAttributeValue(CommonConstant.NODE_Definition, "")
        }
        return fieldKey;
    }

    private getDataMapXML(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var workSpace = YigoDesignFuns.getWorkspace(form);
        if (!workSpace) return;

        if( args[0]) {
            return (<ITagNode>XmlEntityUtil.getSelectionModel(workSpace.getXmlEntity()).getSingleSeletionItem()).toXml(false);
        } else {
            var xmlEntity = workSpace.getXmlEntity();
            return xmlEntity.getXml(false);
        }


    }

    private setSourceFieldToDataMap(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        // 从doc里获取数据
        var doc = form.document;
        var wfWorkSpace = <DataMapWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        let dataTable = doc.getByKey("ED_DataMapFieldDtl");
        wfWorkSpace.getGraphicView().addSourceFieldsCmd(dataTable, xmlEntity, wfWorkSpace);
    };

    private setTargetFieldToDataMap(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        // 从doc里获取数据
        var doc = form.document;
        var wfWorkSpace = <DataMapWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        let dataTable = doc.getByKey("ED_DataMapFieldDtl");
        wfWorkSpace.getGraphicView().addTargetFieldsCmd(dataTable, xmlEntity, wfWorkSpace);
    };

    private setFeedBackFieldToDataMap(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        let formKey = form.getPara("FormKey");
        // 从doc里获取数据
        var doc = form.document;
        var wfWorkSpace = <DataMapWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        let dataTable = doc.getByKey("ED_DataMapFieldDtl");
        wfWorkSpace.getGraphicView().addFeedBackFieldsCmd(dataTable, xmlEntity, wfWorkSpace,formKey);
    };

    private hasFeedBackCollection(evaluator: any, name: string, ctx: any, args: any[]) : Boolean{
        var form = ctx.form;
        var wfWorkSpace = <DataMapWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        var xmlEntity = wfWorkSpace.getXmlEntity();
        let root = <ITagNode>xmlEntity.getTagRoot();
        if(root.getChild(CommonConstant.NODE_FeedbackCollection)) return true;
        return false;
    }

    private hasAttrDefinition(evaluator: any, name: string, ctx: any, args: any[]){
        let form = ctx.form;
        let wfWorkSpace = <DataMapWorkSpace>YigoDesignFuns.getWorkspace(form)!;
        let selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        let field = <ITagNode>selectItem;
        if(field.getTagName() != CommonConstant.NODE_SourceField) return false;
        let fields = field.getParent()!.getChildren();
        if(field.hasAttribute(CommonConstant.NODE_Definition)){
            return true;
        }else {
            let flag = false;
            for (let i = 0 ; i < fields.length; i++){
                let findField = <ITagNode>fields[i];
                if(findField.hasAttribute(CommonConstant.NODE_Definition)
                    && findField.getAttributeValue(CommonConstant.NODE_Definition) == field.getAttributeValue(CommonConstant.S_Key)){
                    flag = true;
                    break;
                }
            }
            return flag;
        }
    }


    private getTargetTableList (evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var workSpace = YigoDesignFuns.getWorkspace(form);
        if (!workSpace) return;

        var xmlEntity = workSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        let find = root.find(CommonConstant.NODE_TargetTableCollection, "", "")!;
        let children = find.getChildren();
        let res = "";
        for (let child of children) {
            if (child instanceof TagNode){
                let c = <TagNode> child;
                let tableKey = c.getAttributeValue(CommonConstant.S_Key);
                res = res + tableKey + "," + tableKey + ";";
            }
        }
        return res;
    }

    private getPrimaryTableKey(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var workSpace = <DataMapWorkSpace> YigoDesignFuns.getWorkspace(form);
        if (!workSpace) return;

        var xmlEntity = workSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        let find = root.find(CommonConstant.NODE_SourceTableCollection, "", "")!;
        let table = find.find(CommonConstant.NODE_SourceTable, CommonConstant.ATTR_IsPrimary, "true");
        if(!table) return "";
        let tableKey = table.getAttributeValue(CommonConstant.S_Key);
        return tableKey;
    }

    private async addFeedBackForm(evaluator: any, name: string, ctx: any, args: any[]) {
        let form = ctx.form;
        let workSpace = <DataMapWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!workSpace) return;
        let xmlEntity = workSpace.getXmlEntity();
        let root = xmlEntity.getTagRoot();
        let formKey = args[0];
        if (!formKey) return;

        let operationDispatcher = workSpace.getOperationDispatcher();
        // 1.获取feedbackCollection
        let fc = YigoDesignFuns.getChildNode(root, CommonConstant.NODE_FeedbackCollection);
        // 2. 尝试添加feedObject 如果存在提示
        let find = fc.find(CommonConstant.NODE_FeedbackObject, CommonConstant.ATTR_FormKey, formKey);
        if (find) {
            // @ts-ignore
            layer.msg("当前选中反填表单:" + formKey + "已经存在,请重新选择", {
                time: 1500
            });
            return;
        }
        // 3. 不存在 再feedbackCollection 中 添加 feedObject
        // 3.1 获取dataObjectKey 和 formCpation
        let res = await operationDispatcher.eval(`Macro_GetFormInfo('${formKey}')`);
        let formInfo = JSON.parse(res);
        // 3.2 获取最后一个feedObject的 y 向下便宜 如果没有 则用 tgtTable 的 x 向右偏移
        let X;
        let Y;
        let offset = 100;
        let children = fc.getChildren();
        if (children.length > 0) {
            let iNode = <TagNode>children[children.length - 1];
            Y = Number.parseInt(iNode.getAttributeValue(CommonConstant.ATTR_Y)) + Number.parseInt(iNode.getAttributeValue(CommonConstant.ATTR_Height)) + offset;
            X = Number.parseInt(iNode.getAttributeValue(CommonConstant.ATTR_X))
        } else {
            let ttc = root.find(CommonConstant.NODE_TargetTableCollection, "", "")!;
            X = "800";
            Y = Number.parseInt(ttc.getAttributeValue(CommonConstant.ATTR_Y));
        }
        let feedObject = new TagNode(CommonConstant.NODE_FeedbackObject);
        // 3.3 width 是标签的长度 最小256
        let formCaption = formInfo['Caption'];
        let dom = document.createElement('span');
        dom.style.display = 'inline-block';
        dom.textContent = "(反填 )" + formKey + " " + formCaption;
        dom.style.fontSize = "14px"
        dom.style.fontWeight = "bold"
        document.body.appendChild(dom);
        let width = (dom.clientWidth || dom.offsetWidth || dom.scrollWidth) + 6;
        document.body.removeChild(dom);
        width = width > 256 ? width : 256;

        feedObject.setAttributeValue(CommonConstant.ATTR_FormKey, formKey);
        feedObject.setAttributeValue(CommonConstant.ATTR_ObjectKey, formInfo['DataObject']['Key']);
        feedObject.setAttributeValue(CommonConstant.ATTR_Width, width.toString());
        // 初始高度设置为60
        feedObject.setAttributeValue(CommonConstant.ATTR_Height, '60');
        feedObject.setAttributeValue(CommonConstant.ATTR_X, X.toString());
        feedObject.setAttributeValue(CommonConstant.ATTR_Y, Y.toString());

        fc.addChild(feedObject);
        CommonFunction.GetAllFields(root, operationDispatcher, workSpace.getGraphicView(), xmlEntity, form.entryPath);
    }

    /**
     * 设置工作流根节点属性
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private setWorkflowAttrValue(evaluator: any, name: string, ctx: any, args: any[]) {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var attrKey = args[0];
        var attrValue = args[1];

        var xmlEntity = wfWorkSpace.getXmlEntity();
        var root = xmlEntity.getTagRoot();
        root.setAttributeValue(attrKey, attrValue);
        XmlEntityUtil.refreshSelection(xmlEntity);
        wfWorkSpace.reloadSource()
    }

    private listWorkflowNodes(evaluator: any, name: string, ctx: any, args: any[]): any[] {
        var form = ctx.form;
        var workSpace = YigoDesignFuns.getWorkspace(form);
        var items: any[] = [{text: '', value: ''}];
        if (!workSpace) return [];

        var selectItem = workSpace.getSelectionModel()?.getSingleSeletionItem();
        if (selectItem instanceof TagNode) {
            var wfWorkSpace = <BPMNWorkSpace>workSpace;
            var view = wfWorkSpace.getGraphicView();
            for (let node of view.getNodes()) {
                if (node.getTagNode() != selectItem) {
                    var item = {text: node.getCaption(), value: node.getKey()};
                    items.push(item);
                }
            }
        }
        return items;
    }

    /**
     * 获取当前选中节点的属性值
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getPropertyValue(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var propertyKey = args[0];
        var defaultValue = args[1];

        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        if (selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            return tagNode.getAttributeValue(propertyKey, defaultValue);
        }
        return '';
    }

    private getPropertyValueByCondition(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var propertyKey = args[0];
        var defaultValue = args[1];
        let root = wfWorkSpace.getXmlEntity().getTagRoot()
        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        if (selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            let tableKey = tagNode.getAttributeValue(CommonConstant.ATTR_TableKey);
            let fieldKey = tagNode.getAttributeValue(CommonConstant.ATTR_FieldKey);
            let child = root.getChildren();
            for (let i = 0; i < child.length; i++){
                let tag = <ITagNode>child[i];
                if(tag.getTagName() == CommonConstant.NODE_SourceTableCollection){
                    let findTable = tag.find(CommonConstant.NODE_SourceTable, CommonConstant.S_Key, tableKey);
                    let findField = findTable!.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key,fieldKey);
                    if(findField) {
                        return findField!.getAttributeValue(propertyKey, defaultValue);
                    }else{
                        findField = findTable!.find(CommonConstant.NODE_SourceField, CommonConstant.NODE_Definition,fieldKey);
                        return findField!.getAttributeValue(propertyKey, defaultValue);
                    }
                }
            }
        }
        return defaultValue;
    }



    /**
     * 获取当前选中节点的属性值
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getSectionValue(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var propertyKey = args[0];
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        let sectionNode = selectItem.getParent()!.getParent()!.getParent();
        if (sectionNode instanceof TagNode) {
            var tagNode = <ITagNode>sectionNode;
            return tagNode.getAttributeValue(propertyKey);
        }
        return '';
    }

    /**
     * 获取当前选中节点的属性值
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getColumnIndex(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        let rowNode = selectItem.getParent()!;
        if (rowNode instanceof TagNode) {
            var tagNode = <ITagNode>rowNode;
            let children = tagNode.getChildren();
            return children.indexOf(selectItem);
        }
        return '';
    }

    private isField(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        let singleSeletionItem = wfWorkSpace.getXmlEntity().getSelectionModel().getSingleSeletionItem();
        let value = singleSeletionItem?.getTagNode().getAttributeValue("Type", "Field");
        return value;
    }

    private getIsPrimaryTableKey(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        let singleSeletionItem = wfWorkSpace.getXmlEntity().getSelectionModel().getSingleSeletionItem();
         let parent = singleSeletionItem?.getTagNode().getParent()?.getParent();
         let find = parent?.find("SourceTable","IsPrimary","true");
         let value = "";
         if (find){
             value = find.getAttributeValue(DataMigrationConstants.Attr_Key,"");
         }
        //getAttributeValue("IsPrimary", "false");
        return value;


    }
    private isMainTable(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        let singleSeletionItem = wfWorkSpace.getXmlEntity().getSelectionModel().getSingleSeletionItem();
        let value = singleSeletionItem?.getTagNode().getParent()?.getAttributeValue("IsPrimary", "false");
        return value;

    }

    private getRowType(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = <ExcelWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        let selectSheetViewName = wfWorkSpace.getGraphicView().getSelectSheetViewName();
        let sheetNode = wfWorkSpace.getXmlEntity().find("Sheet", "Name", selectSheetViewName);
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        let rowNode = null;
        if (selectItem.getParent() && sheetNode) {
            rowNode = sheetNode.find("Row", "RowIndex", selectItem.getParent()!.getAttributeValue(ExcelConstants.ATTR_RowIndex));
        } else if (sheetNode) {
            rowNode = sheetNode!.find("Row", "RowIndex", (selectItem.getAttributeValueInt("rowindex", 0) + 1).toString());
        }
        if (rowNode) {
            return rowNode.getAttributeValue(BaseConstants.ATTR_Type, "Fix");
        } else {
            return "Fix";
        }
    }

    private getPrintRowType(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = <PrintWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        let rowNode = selectItem.getParent();
        if (rowNode) {
            return rowNode.getAttributeValue(BaseConstants.ATTR_Type, "Fix");
        } else {
            return "Fix";
        }
    }

    private getPrintCellTableKey(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = <PrintWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        return selectItem.getAttributeValue(BaseConstants.ATTR_TableKey);
    }

    /**
     * 获取当前选中节点的属性值
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getExcelTableKey(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        let rowNode = selectItem.getParent()!;
        if (rowNode) {
            return rowNode.getAttributeValue("TableKey", "");
        } else {
            let rowIndex = selectItem.getAttributeValueInt(ExcelConstants.ATTR_rowindex, 0) + 1;
            let wfWorkSpace1 = <ExcelWorkSpace>wfWorkSpace;
            let selectSheetViewName = wfWorkSpace1.getGraphicView().getSelectSheetViewName();
            let tagRoot = wfWorkSpace1.getXmlEntity().getTagRoot();
            let children = tagRoot.getChildren();
            let sheetNode = tagRoot;
            for (let child of children) {
                let sheet = <ITagNode>child;
                let key = sheet.getAttributeValue(BaseConstants.ATTR_Name);
                if (key == selectSheetViewName) {
                    sheetNode = sheet;
                    break;
                }
            }
            let rowsNode = <ITagNode>sheetNode.getChildren()[0];
            let rows = rowsNode!.getChildren();
            for (let row of rows) {
                let rownode = <ITagNode>row;
                let currnentIndex = Number(rownode.getAttributeValue("RowIndex"));
                if (currnentIndex == rowIndex) {
                    return rownode.getAttributeValue("TableKey", "");
                }
            }
        }

        return '';
    }

    private getSheetXML(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = <ExcelWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        let sheetView = <SheetView>wfWorkSpace.getGraphicView().getSelectSheetView()!;
        return sheetView.getTagNode().toXml(false);
    }

    private getExcelRowIndex(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        var rowindex;
        if (selectItem.hasAttribute("rowindex")) {
            rowindex = parseInt(selectItem.getAttributeValue("rowindex")) + 1;
        } else {
            var rowNode = <ITagNode>selectItem.getParent()!;
            rowindex = parseInt(rowNode.getAttributeValue("RowIndex"));
        }
        return rowindex;
    }

    private getExcelColumnIndex(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        var colindex
        if (selectItem.hasAttribute("colindex")) {
            colindex = parseInt(selectItem.getAttributeValue("colindex")) + 1;
        } else {
            colindex = selectItem.getAttributeValue("CellIndex");
        }
        return colindex;
    }

    private getRowItem(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;
        var selectItem = <ITagNode>XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        var rowNode = selectItem.getParent()!;
        if (rowNode instanceof TagNode) {
            var tagNode = <ITagNode>rowNode;
            let rows = (<ITagNode>tagNode.getParent()!).getChildren();
            return rows.indexOf(tagNode);
        }
        return selectItem;
    }

    private setPropertyValue(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var propertyKey = args[0];
        var value = args[1];
        var bRoot = false;
        if (args.length > 2) {
            bRoot = Boolean(args[2]);
        }
        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        if (selectItem || bRoot) {
            wfWorkSpace.getPropertyPlugin().setPropertyValue(propertyKey, value, value);
            wfWorkSpace.reloadSource();
        }
    }

    private setExcelCellValue(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = <ExcelWorkSpace>YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var propertyKey = args[0];
        var value = args[1];
        var bRoot = false;
        if (args.length > 2) {
            bRoot = Boolean(args[2]);
        }
        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        if (selectItem || bRoot) {
            wfWorkSpace.getPropertyPlugin().setPropertyValue(propertyKey, value, value);


            // let inputElement = <InputElement> wfWorkSpace.getDomElement().getChildAt(0).getChildAt(0).getChildAt(1).getChildAt(1).getChildAt(2).getChildAt(1);
            // inputElement.setValue(value);
            try {
                wfWorkSpace.imageValue(value, ""); // 刚进入页面可能未选择节点
            } catch (e) {
            }
        }
    }

    /**
     * 获取工作流根节点FormKey属性值
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private getWorkflowFormKey(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var rootTag = wfWorkSpace.getXmlEntity().getTagRoot();
        var formKey = rootTag.getAttributeValue(GlobalConstants.S_FormKey);
        return formKey ? formKey : '';
    }

    /**
     * 通过Code设置公式
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private setPropertyFormulaCode(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var propertyKey = args[0];
        var code = args[1];
        var text = args[2];

        var selectItem = wfWorkSpace.getSelectionModel()?.getSingleSeletionItem();
        if (selectItem instanceof TagNode) {
            var tagNode = <TagNode>selectItem;
            wfWorkSpace.getPropertyPlugin().setPropertyValue(propertyKey, RunDictFormula.parseToRunDictFormulaStr(code), text);
            wfWorkSpace.getXmlEntity().update(tagNode, false);
            XmlEntityUtil.refreshSelection(wfWorkSpace.getXmlEntity());
            wfWorkSpace.reloadSource();
        }
    }

    /**
     * 获取表格中满足某个特定条件的某个单元值
     * @param name
     * @param ctx
     * @param args[0] 表格标识
     * @param args[1] 返回值所在单元格标识
     * @param args[2] 过滤值所在的单元格标识
     * @param args[3] 过滤值
     * @returns
     */
    private async getCellValuesByFilter(evaluator: any, name: string, ctx: any, args: any[]): Promise<any> {
        var form = ctx.form;
        var gridKey = args[0];
        var resultCellKey = args[1];
        var filter;
        if (args.length > 2) {
            filter = args[2];
        }
        var grid = form.getComponent(gridKey);

        filter && await form.eval(`SetGridFilter("${gridKey}", "${filter}")`, ctx);
        var count = grid.getRowCount();
        var result = "";
        for (var i = 0; i < count; i++) {
            var value = grid.getValueByKey(i, resultCellKey);
            if (value == null) value = '';
            result = (i == 0) ? value : (result + "," + value);
        }
        return result;
    }

    /**
     * 更新选中节点的权限
     *
     * @param name
     * @param ctx
     * @param args
     * @returns
     */
    private updatePermNode(evaluator: any, name: string, ctx: any, args: any[]): void {
        var form = ctx.form;
        var workSpace = YigoDesignFuns.getWorkspace(form);
        if (!workSpace) return;
        var wfWorkSpace = <BPMNWorkSpace>workSpace;

        var optPerms = args[0];
        var compVisiblePerms = args[1];
        var compEnablePerms = args[2];
        var gridEnablePerms = args[3];

        var selectItem = wfWorkSpace.getSelectionModel()?.getSingleSeletionItem();
        var permNode = WfNodeUtil.ensurePermNode(wfWorkSpace.getXmlEntity(), selectItem);
        YigoDesignFuns._fillPermNode(optPerms, compVisiblePerms, compEnablePerms, gridEnablePerms, permNode);
        XmlEntityUtil.refreshSelection(wfWorkSpace.getXmlEntity());
        wfWorkSpace.reloadSource();
    }

    private getPermShowText(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return "";

        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        var permNode = WfNodeUtil.ensurePermNode(wfWorkSpace.getXmlEntity(), selectItem);
        return YigoDesignFuns._getPermShowText(permNode);
    }

    private getPermShowTextFromXml(evaluator: any, name: string, ctx: any, args: any[]): any {
        var permXmlString = args[0];
        if (!permXmlString) return "未设置";
        var permNode = XmlEntity.parseTagNode(permXmlString);
        return YigoDesignFuns._getPermShowText(permNode);
    }

    private getCollectionShowText(evaluator: any, name: string, ctx: any, args: any[]): string {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return "";
        var tagName = args[0];

        var xmlEntity = wfWorkSpace.getXmlEntity();
        var selectItem = xmlEntity.getSelectionModel().getSingleSeletionItem();

        var curTagNode = (selectItem instanceof TagNode) ? <TagNode>selectItem : xmlEntity.getTagRoot();
        var collection = curTagNode.getChild(tagName);
        return (!collection || collection.getChildren().length == 0) ? "未设置" : "已设置";

    }

    private isWFUserMode(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = <BPMNWorkSpace><unknown>YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return true;
        return EDesignMode.User == wfWorkSpace.getMode();
    }

    private getOptPermKeys(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        var permNode = WfNodeUtil.ensurePermNode(wfWorkSpace.getXmlEntity(), selectItem);
        return YigoDesignFuns._getTypePermItemKeys(permNode, WfConstants.NODE_OptPerm);
    }

    private getOptPermKeysFromXml(evaluator: any, name: string, ctx: any, args: any[]): any {
        var permXmlString = args[0];
        if (!permXmlString) return "";
        var permNode = XmlEntity.parseTagNode(permXmlString);
        return YigoDesignFuns._getTypePermItemKeys(permNode, WfConstants.NODE_OptPerm);
    }

    private getEnablePermKeys(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        var permNode = WfNodeUtil.ensurePermNode(wfWorkSpace.getXmlEntity(), selectItem);
        return YigoDesignFuns._getTypePermItemKeys(permNode, WfConstants.NODE_EnablePerm);
    }

    private getEnablePermKeysFromXml(evaluator: any, name: string, ctx: any, args: any[]): any {
        var permXmlString = args[0];
        if (!permXmlString) return "";

        var permNode = XmlEntity.parseTagNode(permXmlString);
        return YigoDesignFuns._getTypePermItemKeys(permNode, WfConstants.NODE_EnablePerm);
    }

    private getVisiblePermKeys(evaluator: any, name: string, ctx: any, args: any[]): any {
        var form = ctx.form;
        var wfWorkSpace = YigoDesignFuns.getWorkspace(form);
        if (!wfWorkSpace) return;

        var selectItem = XmlEntityUtil.getSelectionModel(wfWorkSpace.getXmlEntity()).getSingleSeletionItem();
        var permNode = WfNodeUtil.ensurePermNode(wfWorkSpace.getXmlEntity(), selectItem);
        return YigoDesignFuns._getTypePermItemKeys(permNode, WfConstants.NODE_VisiblePerm);
    }

    private getVisiblePermKeysFromXml(evaluator: any, name: string, ctx: any, args: any[]): any {
        var permXmlString = args[0];
        if (!permXmlString) return "";
        var permNode = XmlEntity.parseTagNode(permXmlString);
        return YigoDesignFuns._getTypePermItemKeys(permNode, WfConstants.NODE_VisiblePerm);
    }

    private convertPermToXml(evaluator: any, name: string, ctx: any, args: any[]): string {
        var optPerms = args[0];
        var compVisiblePerms = args[1];
        var compEnablePerms = args[2];
        var gridEnablePerms = args[3];
        if (!optPerms && !compVisiblePerms && !compEnablePerms && !gridEnablePerms) {
            return "";
        }

        var permNode = new TagNode(WfConstants.NODE_Perm);
        YigoDesignFuns._fillPermNode(optPerms, compVisiblePerms, compEnablePerms, gridEnablePerms, permNode);
        return permNode.toXml(true);
    }

    private static _fillPermNode(optPerms: string, compVisiblePerms: string, compEnablePerms: string, gridEnablePerms: string, permNode: ITagNode) {
        var optPermNode = permNode.ensureChild(WfConstants.NODE_OptPerm);
        YigoDesignFuns._setTypePermItemKeys(optPerms, optPermNode, WfConstants.NODE_OptPermItem, true);
        var visiblePermNode = permNode.ensureChild(WfConstants.NODE_VisiblePerm);
        YigoDesignFuns._setTypePermItemKeys(compVisiblePerms, visiblePermNode, WfConstants.NODE_VisiblePermItem, true);
        var enablePermNode = permNode.ensureChild(WfConstants.NODE_EnablePerm);
        YigoDesignFuns._setTypePermItemKeys(compEnablePerms, enablePermNode, WfConstants.NODE_EnablePermItem, true);
        YigoDesignFuns._setTypePermItemKeys(gridEnablePerms, enablePermNode, WfConstants.NODE_EnablePermItem, false);
    }

    private static _getTypePermItemKeys(permNode: ITagNode, typeTagName: string): string {
        var keys = "";
        var optTag = permNode.getChild(typeTagName);
        if (optTag) {
            var nodes = optTag.getChildren();
            for (let node of nodes) {
                var key = (<TagNode>node).getAttributeValue(GlobalConstants.S_Key);
                if (keys) {
                    keys += "," + key;
                } else {
                    keys = key;
                }
            }
        }
        return keys;
    }

    private static _getPermShowText(permNode: ITagNode): string {
        var optPermNode = permNode.getChild(WfConstants.NODE_OptPerm);
        var visiblePermNode = permNode.getChild(WfConstants.NODE_VisiblePerm);
        var enablePermNode = permNode.getChild(WfConstants.NODE_EnablePerm);
        if ((optPermNode && optPermNode.getChildren().length > 0)
            || (visiblePermNode && visiblePermNode.getChildren().length > 0)
            || (enablePermNode && enablePermNode.getChildren().length > 0)) {
            return "已设置";
        } else {
            return "未设置";
        }
    }

    private static _setTypePermItemKeys(keys: string, typePermNode: ITagNode, permTagName: string, bClearOrg: boolean): void {
        bClearOrg && typePermNode.clearChildren();
        if (!keys) return;
        var arrKey = keys.split(",");
        for (let key of arrKey) {
            var node = <TagNode>typePermNode.addChild(new TagNode(permTagName));
            node.setAttributeValue(GlobalConstants.S_Key, key);
        }
    }

    private static _getPropertyItem(nodeType: string, propKey: string): IPropertyItem | undefined {
        var groups = WfDevPropertyDefine.getInstance().getPropertyDefines(nodeType);
        if (groups) {
            for (let group of groups) {
                for (let prop of group.properties) {
                    if (prop.key == propKey) {
                        return prop;
                    }
                }
            }
        }
        return undefined;
    }
}
//propertyForm.eval('LoadData();', cxt, null);			
//setTimeout(function () {
//    propertyForm.eval('RefreshERPPropertyUI();', cxt, null);
//}, 200);