import GlobalVariable from "../../../design/GlobalVariable";

export default abstract class AbstractYigoFuns {

    private inited: boolean = false;

    constructor() {
        if (!GlobalVariable.isInIFrame()) {
            this.initFunctions();
        }
    }

    protected setInited(): void {
        this.inited = true;
    }

    protected isInited(): boolean {
        return this.inited;
    }

    protected addFun(name: string, fun: (evaluator: any, name: string, cxt: Object, args: []) => any): void {
        YIUI.FuncMap.get().put(name, fun);
        //View.FuncMap.put(name, fun);
    }

    protected abstract initFunctions(): void
}