import ContainerPanel from "../../../common/component/container/panel/ContainerPanel";
import Custom from "../../../common/component/control/Custom";
import ActionNames from "../../../common/event/ActionNames";
import Paras from "../../../common/struct/Paras";
import SizeInfo from "../../../common/struct/SizeInfo";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import AbstractGraphicView from "../../base/AbstractGraphicView";
import AbstractPropertyDefine from "../../plugin/property/base/AbstractPropertyDefine";
import PrintPropertyDefine from "../base/PrintPropertyDefine";
import PrintOptStateDelegate from "../state/PrintOptStateDelegate";
import ImgElement from './../../../common/dom/element/ImgElement';
import BorderPanel from './../../../common/component/container/panel/BorderPanel';
import PrintConstants from './../base/PrintConstants';
import Menu from "../../../common/component/menu/Menu";
import ITagNode from "../../../common/xml/node/ITagNode";
import SectionView from "./element/SectionView";
import H5VFlexPanel from "../../../common/component/container/panel/H5VFlexPanel";
import GlobalSetting from './../../../common/GlobalSetting';
import AbstractDomElement from "../../../common/dom/AbstractDomElement";
import IPrintElementView from "./element/IPrintElementView";
import JComponent from "../../../common/component/JComponent";
import DomUtil from "../../../common/dom/DomUtil";
import PrintActionUtil from "../util/PrintActionUtil";
import Events from "../../../common/event/Events";
import P18N from "../base/P18N";
import SelectionModel from "../../../common/selection/SelectionModel";
import CmdQueue from "../../../common/cmd/CmdQueue";
import PrintToolbar from "./PrintToolbar";
import PrintCombobox from "./PrintCombobox";
import {CellView} from "./element/CellView";
import NewRowElementCmd from "../cmd/NewRowElementCmd";
import NewColumnElementCmd from "../cmd/NewColumnElementCmd";
import NewSectionElementCmd from "../cmd/NewSectionElementCmd";
import DeleteElementCmd from "../cmd/DeleteElementCmd";
import Toolbar from "../../../common/component/toolbar/Toolbar";
import InputCellCmd from "../cmd/InputCellCmd";
import PRINT from "../base/PRINT";
import {ExcelCellView} from "../../excel/view/element/ExcelCellView";
import DragStateCmd from "../cmd/DragStateCmd";
import {TextEmbedView} from "./element/embed/TextEmbedView";

// private MetaReportDataSource reportDataSource = null;
// private MetaReportGrid grid = null;
// private MetaReportEmbed embed = null;
// private MetaReportWaterprint waterprint = null;

export default class PrintGraphicView extends AbstractGraphicView<PrintOptStateDelegate> implements IPrintElementView {

    public static TOOLBOX_WIDTH = 50;

    private xmlEntity!: IXmlEntity;

    private boardContainer: ContainerPanel;

    //打印设计窗口(含尺码)
    private designView: BorderPanel;
    //单元格右键操作列表
    private toolBar: Menu;
    //单元格右键页面操作列表
    private pageOpt: Menu;
    //打印模板视图
    private innerTemplateView: H5VFlexPanel;
    private printToolbar: PrintToolbar;
    private selectSectionView: SectionView | undefined;
    private selectSheetViewName: string = "";
    // 标尺
    private vRuler: JComponent<any>;
    private hRuler: JComponent<any>;
    private selectExcelViews?: CellView;
    // 视图元素集合
    private viewElements: IPrintElementView[] = [];
    private sheetViews: Map<string, IPrintElementView> = new Map<string, IPrintElementView>()


    constructor() {
        // super(PrintGraphicView.TOOLBOX_WIDTH, 0, 0, 0);
        super(0, 0, 64, 0);
        //var toolbox = new PrintToolbox();
        // this.setLeft(toolbox);
        // toolbox.bindGraphicView(this);
        this.boardContainer = new ContainerPanel();
        this.setCenter(this.boardContainer);
        this.printToolbar = new PrintToolbar();
        this.printToolbar.initGrid(
            [SizeInfo.valueOfPX(32), SizeInfo.valueOfPX(32)],
            [SizeInfo.valueOfPX(380), SizeInfo.AUTO_SIZE, SizeInfo.AUTO_SIZE, SizeInfo.AUTO_SIZE],
            null, null
        );
        this.printToolbar.setHeight(SizeInfo.valueOfPX(66))
        var printSkin = this.styleFactory.getPrintSkin();

        this.setTop(this.printToolbar);
        //打印设计窗口容器
        var board = new ContainerPanel();
        board.setStyle("overflow", "hidden");
        board.addClass(printSkin.print_board);
        this.boardContainer.addComponent(board);
        board.setStyle('padding', '24px');

        //打印设计窗口(含尺码)
        this.designView = new BorderPanel(15, 0, 15, 0);
        this.designView.setStyle('background', 'white');
        board.addComponent(this.designView);

        // 纵向尺码
        this.vRuler = new Custom(new ImgElement());
        this.vRuler.addClass('v_ruler');
        this.vRuler.getDomElement().setAttr('src', PRINT.PREFIX + '/css/img/ruler.v.svg');
        this.designView.setLeft(this.vRuler);

        // 横向尺码
        this.hRuler = new Custom(new ImgElement());
        this.hRuler.addClass('h_ruler');
        this.hRuler.getDomElement().setAttr('src', PRINT.PREFIX + '/css/img/ruler.h.svg');
        this.designView.setTop(this.hRuler);

        //右键工具栏
        window.oncontextmenu = function () {
            return false
        }//禁用页面右键
        this.pageOpt = new Menu();
        this.pageOpt.setStyle("font-size", "12px");
        this.toolBar = new Menu();

        // 打印元素容器
        this.innerTemplateView = new H5VFlexPanel();
        this.innerTemplateView.addClass('printarea');
        this.innerTemplateView.setStyle('position',"relative");
        this.designView.setCenter(this.innerTemplateView);
        // 浮动式打印元素

        // 初始化设计模板鼠标事件
        //this.initViewMouseEvent(this.innerTemplateView.getDomElement());
        this.initoncontextmune(this.innerTemplateView.getDomElement())
    }

    isEmbed(): boolean {
        return false;
    }

    getViewElements(): IPrintElementView[] {
        return this.viewElements;
    }

    getSelectSheetView(): IPrintElementView | undefined {
        return this.sheetViews.get(this.selectSheetViewName);
    }

    getSelectSheetViewName(): string {
        return this.selectSheetViewName;
    }

    getSelectCellView(): CellView | undefined {
        return this.selectExcelViews;
    }

    SelectCellView(cellView: CellView): void {
        this.selectExcelViews = cellView;
    }

    getSectionViews(): SectionView | undefined {
        return this.selectSectionView;
    }

    setSectionView(sectionView: SectionView): void {
        this.selectSectionView = sectionView;
    }

    getTagNode(): ITagNode {
        return this.getXmlEntity().getTagRoot();
    }

    containPoint(x: number, y: number): boolean {
        return true;
    }

    findChildNode(tagNode: ITagNode): IPrintElementView | null {
        for (let element of this.viewElements) {
            if (element.getTagNode() == tagNode) {
                return element;
            }
        }
        return null;
    }

    updateView(): void {
        let width = this.checkDesignViewSize();
        let height = this.checkDesignViewHeight();
        let PageID = this.getXmlEntity().getTagRoot().getAttributeValue(PrintConstants.ATTR_PageID);

        var templateHeight = this.getPaperHeight(),
            templateWidth = this.getPaperWidth();
        let MM = 210;

        switch (PageID) {
            case "Custom":
                MM = (210 / 595) * templateWidth;
                break;
            case "A0":
                MM = 841;
                break;
            case "A1":
                MM = 594;
                break;
            case "A2":
                MM = 420;
                break;
            case "A3":
                MM = 297;
                break;
            case "A4":
                MM = 210;
                break;
            case "A5":
                MM = 148;
                break;
            case "A6":
                MM = 105;
                break;
            case "Designated Long":
                MM = 210;
                break;
            case "Letter":
                MM = 215.9;
                break;
            case "Legal":
                MM = 213.36;
                break;
            case "Tabloid":
                MM = 279.4;
                break;
            case "Executive":
                MM = 184.15;
                break;
            case "8x10":
                MM = 203.2;
                break;
            case "Monarch Envelope":
                MM = 98.298;
                break;
            case "Number 10 Envelope":
                MM = 104.775;
                break;
            case "C":
                MM = 431.8;
                break;
            case "B4":
                MM = 257;
                break;
            case "B5":
                MM = 182;
                break;
            case "B6":
                MM = 128;
                break;
            case "Japanese Postcard":
                MM = 100;
                break;
        }
        var ratio = SizeInfo.getDPIRatio(templateWidth, MM);
        if (templateWidth < width) {
            templateWidth = width;
        }
        if (templateHeight < height) {
            templateHeight = height;
        }
        this.designView.setWidth(SizeInfo.valueOfPX(templateWidth + 17));
        this.designView.setHeight(SizeInfo.valueOfPX(templateHeight + 17));
        this.vRuler.setStyle('width', (400 * ratio) + 'mm');
        this.hRuler.setStyle('width', (400 * ratio) + 'mm');
        this.innerTemplateView.setWidth(SizeInfo.valueOfPX(templateWidth));
        this.innerTemplateView.setHeight(SizeInfo.valueOfPX(templateHeight));
        this.innerTemplateView.setStyle('padding-left', SizeInfo.valueOfPX(this.getLeftMargin() + 4));
        this.innerTemplateView.setStyle('padding-right', SizeInfo.valueOfPX(this.getRightMargin()));
        this.innerTemplateView.setStyle('padding-top', SizeInfo.valueOfPX(this.getTopMargin()));
        this.innerTemplateView.setStyle('padding-bottom', SizeInfo.valueOfPX(this.getBottomMargin()));
    }

    getPaperWidth(): number {
        return this.getTagNode().getAttributeValueInt(PrintConstants.ATTR_PaperWidth, GlobalSetting.META_A4_WIDTH);
    }

    getPaperHeight(): number {
        return this.getTagNode().getAttributeValueInt(PrintConstants.ATTR_PaperHeight, GlobalSetting.META_A4_HEIGHT);
    }

    getLeftMargin(): number {
        return this.getTagNode().getAttributeValueInt(PrintConstants.ATTR_LeftMargin, 0);
    }

    getRightMargin(): number {
        return this.getTagNode().getAttributeValueInt(PrintConstants.ATTR_RightMargin, 0);
    }

    getTopMargin(): number {
        return this.getTagNode().getAttributeValueInt(PrintConstants.ATTR_TopMargin, 0);
    }

    getBottomMargin(): number {
        return this.getTagNode().getAttributeValueInt(PrintConstants.ATTR_BottomMargin, 0);
    }

    checkDesignViewSize(): number {
        let xmlEntity = this.getXmlEntity();
        let reportNode = xmlEntity.getTagRoot();
        let gridNode = <ITagNode>reportNode.getChild(PrintConstants.NODE_Grid);
        let sections = gridNode.getChildren();
        let maxLength: number = 542;
        for (let section of sections!) {
            let sectionNode = <ITagNode>section;
            if (sectionNode.getNodeType() ==  'tag'){
                let column = <ITagNode>sectionNode.getChild(PrintConstants.NODE_Columns);
                if (!column) {
                    return maxLength;
                }
                let columns = column.getChildren();
                let length: number = 0;
                for (let column1 of columns) {
                    let col = <ITagNode>column1;
                    let attributeValue = col.getAttributeValueInt("Width", 80);
                    length = length + attributeValue;
                }
                if (maxLength < length) {
                    maxLength = length;
                }
            }

        }
        return maxLength;
    }

    checkDesignViewHeight(): number {
        let xmlEntity = this.getXmlEntity();
        let reportNode = xmlEntity.getTagRoot();
        let gridNode = <ITagNode>reportNode.getChild(PrintConstants.NODE_Grid);
        let sections = gridNode.getChildren();
        let maxLength: number = 542;
        let length: number = 0;
        for (let section of sections!) {
            let sectionNode = <ITagNode>section;
            if (sectionNode.getNodeType() == 'tag') {
                let rows = <ITagNode>sectionNode.getChild(PrintConstants.NODE_Rows);
                if (!rows) {
                    return maxLength;
                }
                let rowchild = rows.getChildren();
                for (let column1 of rowchild) {
                    let col = <ITagNode>column1;
                    let attributeValue = col.getAttributeValueInt("Height", 30);
                    length = length + attributeValue;
                }
                if (maxLength < length) {
                    maxLength = length;
                }
            }

        }
        return maxLength;
    }

    /*/**
     * 初始化设计模板鼠标事件
    private initViewMouseEvent(domEl: AbstractDomElement): void {
        domEl.addEventListener('mousedown', (e: MouseEvent) => this.getOptStateDelegate().getCurrentState().mousedown(e));
        domEl.addEventListener('mousemove', (e: MouseEvent) => this.getOptStateDelegate().getCurrentState().mousemove(e));
        domEl.addEventListener('mouseup', (e: MouseEvent) => this.getOptStateDelegate().getCurrentState().mouseup(e));
    }*/

    /**
     * 初始化设计模板右键菜单事件
     */
    private initoncontextmune(domEl: AbstractDomElement): void {
        //右键菜单
        var content = this;
        this.getDomElement().setOncontextmenu(function (e: any) {
            var el = <HTMLElement>e.target;
            if (  el.className == "print-embed-comp"||el.className == "embed-text"){
                return;
            }
            var {
                offsetBodyLeft,
                offsetBodyTop
            } = DomUtil.offsetBodyPosition(content.getOptStateDelegate().getCurrentState().getViewEl());
            var x = e.clientX - offsetBodyLeft;
            var y = e.clientY - offsetBodyTop;
            var top = content.boardContainer.getDomElement().getScrollTop();
            var left = content.boardContainer.getDomElement().getScrollLeft();
            var height = content.getDomElement().getHtmlClientHeight();
            var tagNode = content.getOptStateDelegate().getCurrentState().getView()
                .hitTagNode(x, y, Number(el.getAttribute("rowindex")), Number(el.getAttribute("colindex")));
            if (!tagNode) {
                let className = el.className;
                if (className && className.indexOf("print-board") >= 0) {
                    content.pageOpt.hide();
                    content.toolBar.hide();
                    return false;
                } else if (className && className.indexOf("printarea") >= 0) {
                    content.toolBar.hide();
                    let attributeValue = content.getXmlEntity().getTagRoot().getAttributeValue("VirtualPage",'false');
                    if (attributeValue== "true"){
                        content.pageOpt.show(x + 50 - left, y + 100 - top, 110, 55, content.boardContainer.getEl());
                    }else {
                        content.pageOpt.show(x + 50 - left, y + 100 - top, 110, 23, content.boardContainer.getEl());
                    }
                }
            } else {
                if (el.className != "col-resize-ltr" && el.className != "row-resize-ltr" && el.tagName == "SPAN" || el.className.indexOf("selected")!=-1) {
                    content.pageOpt.hide();
                    y = y - top;
                    if ((y + 560) > height) {
                        y = y - (y + 560 - height);
                    }
                    content.toolBar.show(x + 50 - left, y + 100 - top, 110, 315, content.boardContainer.getEl());
                    content.toolBar.getEl().focus();
                }
            }
        });
    }


    /**
     * 通过xml模型载入视图
     */
    load(xmlEntity: IXmlEntity): void {
        this.viewElements = [];
        this.innerTemplateView.removeAll();
        this.xmlEntity = xmlEntity;
        // 更新视图
        this.updateView();
        var root = xmlEntity.getTagRoot();
        var tagGrid = root.getChild(PrintConstants.NODE_Grid);
        var tagEmbed = root.getChild(PrintConstants.NODE_Embed);
        if (!tagGrid) return;
        for (let tmp of tagGrid.getChildren()) {
            var tagSection = <ITagNode>tmp;
            if (tagSection.getNodeType() != "tag"){
                continue;
            }
            var sectionView = new SectionView(tagSection);
            for (let i = 0; i <= sectionView.getLastColumnIndex(); i++) {
                for (let j = 0; j <= sectionView.getLastRowIndex(); j++) {
                    var childNode = sectionView.getChildCell(j, i);
                    var rowindex = childNode.getEl().getAttribute("rowindex");
                    var colindex = childNode.getEl().getAttribute("colindex");
                    var textEditor = childNode.getTextEditor();
                    textEditor.setAttr("rowindex", rowindex);
                    textEditor.setAttr("colindex", colindex);
                    var sefl = this;
                    textEditor.addEventListener("blur", (e: any) => {
                        console.log("失去")
                        var target = <HTMLElement>e.target;
                        target.style.backgroundColor = "#DDDDDD";
                        sefl.initInputState(sefl, e);
                        setTimeout(function () {
                            sefl.getOptStateDelegate().setNormalState();
                        }, 100)

                    });
                    textEditor.addEventListener("focus", (e: any) => {
                        console.log("获取")
                        sefl.getOptStateDelegate().setInputState();
                    });
                }
            }
            this.innerTemplateView.addComponent(sectionView);
            this.viewElements.push(sectionView);

            var name = tagSection.getAttributeValue("Key");
            if (this.selectSheetViewName === "") {
                this.selectSheetViewName = name;
            }
            this.sheetViews.set(name, sectionView);
        }
        if (tagEmbed){
            let children = tagEmbed.getChildren();
            for (let child of children) {
                let node = <ITagNode>child;
                if (node.getNodeType() == "tag"){
                    let nodeName = node.getTagName();
                    if (nodeName == "Text"){
                        var textEle =  new TextEmbedView(node);
                        this.innerTemplateView.addComponent(textEle);
                        this.viewElements.push(textEle);
                    }
                }
            }
        }
        this.innerTemplateView.display();
    }

    initInputState(sefl: PrintGraphicView, e: any) {
        var cmd = new InputCellCmd(sefl, e);
        this.getCmdQueue().doCmd(cmd);

    }
    initDragState(sefl: PrintGraphicView, startNode: ITagNode,newValue:number,oldValue:number,flag:boolean,isHeight:boolean) {
        var cmd = new DragStateCmd(sefl,startNode,newValue,oldValue,flag,isHeight);
        this.getCmdQueue().doCmd(cmd);
    }

    getTemplateView(): JComponent<any> {
        return this.innerTemplateView;
    }

    getXmlEntity(): IXmlEntity {
        return this.xmlEntity;
    }

    getToolBar(): Menu {
        return this.toolBar;
    }

    getPageOpt() : Menu{
        return this.pageOpt;
    }

    getPrintToolBar(): PrintToolbar {
        return this.printToolbar;
    }

    getSelectionModel(): SelectionModel {
        return this.xmlEntity.getSelectionModel();
    }

    createOptStateDelegate() {
        return new PrintOptStateDelegate(this);
    }

    getPropertyDefine(): AbstractPropertyDefine {
        return PrintPropertyDefine.getInstance()
    }

    getCmdQueue(): CmdQueue {
        return this.xmlEntity.getCmdQueue();
    }

    undoCmd(): void {
        this.getCmdQueue().undoCmd();
    }

    //删除
    public doDeleteElementCmd(action: string): any {
        var cmd = new DeleteElementCmd(this, this.getSelectionModel().doCacheTagNodes(), action);
        this.getCmdQueue().doCmd(cmd);
    }

    //新增段
    public doAddNewSectionElementCmd(action: string): any {
        var cmd = new NewSectionElementCmd(this, this.getSelectionModel().doCacheTagNodes(), action);
        this.getCmdQueue().doCmd(cmd);
    }

    //新增行
    public doAddNewRowElementCmd(action: string): any {
        var cmd = new NewRowElementCmd(this, this.getSelectionModel().doCacheTagNodes(), action);
        this.getCmdQueue().doCmd(cmd);
    }

    //新增行
    doAddNewColumnElementCmd(action: string): any {
        var cmd = new NewColumnElementCmd(this, this.getSelectionModel().doCacheTagNodes(), action);
        this.getCmdQueue().doCmd(cmd);
    }

    /**
     * 根据鼠标的点击位置获取到该位置对应的TagNode
     */
    hitTagNode(x: number, y: number, rowindex: number, colindex: number): ITagNode | null {


        for (let element of this.viewElements) {
            if (!element.isEmbed() && element.containPoint(x, y)) {
                var sectionView = <SectionView>element;
                var cellView = sectionView.locCell(rowindex, colindex);
                if (cellView) return cellView.getTagNode();
                return element.getTagNode();
            }
        }
        return null;
    }


    hitMultiTagNode(x: number, y: number): CellView | null {
        for (let element of this.viewElements) {
            if (!element.isEmbed() && element.containPoint(x, y)) {
                var sectionView = <SectionView>element;
                var sectionOffset = DomUtil.offsetParent(sectionView.getEl());
                var offsetX = x - sectionOffset.offsetLeft;
                var offsetY = y - sectionOffset.offsetTop;
                var cellView = sectionView.locMultiCell(offsetX, offsetY);
                //单元格宽度过小时，点击时得到的x会有误差，需要扩大定位的范围
                if(!cellView)  cellView = sectionView.locMultiCell(offsetX+1, offsetY);
                if(!cellView)  cellView = sectionView.locMultiCell(offsetX-1, offsetY);
                if (cellView) {
                    return cellView;
                }
            }
        }
        return null;
    }

    /**
     * 根据鼠标的点击位置获取到该位置对应的区域
     */
    getSectionView(x: number, y: number): SectionView | undefined {
        for (let element of this.viewElements) {
            if (!element.isEmbed() && element.containPoint(x, y)) {
                var sectionView = <SectionView>element;
                var sectionOffset = DomUtil.offsetParent(sectionView.getEl());
                var offsetX = x - sectionOffset.offsetLeft;
                var offsetY = y - sectionOffset.offsetTop;
                var cellView = sectionView.locMultiCell(offsetX, offsetY);
                //单元格宽度过小时，点击时得到的x会有误差，需要扩大定位的范围
                if(!cellView)  cellView = sectionView.locMultiCell(offsetX+1, offsetY);
                if(!cellView)  cellView = sectionView.locMultiCell(offsetX-1, offsetY);
                if (cellView) {
                    return sectionView;
                }
            }
        }
        return undefined;
    }

    // 根据xml模型中的变化事件，更新界面显示
    notifyEvent(cmd: string, paras: Paras): void {
        this.hideToolbar();
        var node = paras.getElement();
        switch (cmd) {
            case ActionNames.model_node_add:
                this.update(node);
                break;
            case ActionNames.model_node_remove:
                this.removePrintNode(node);
                break;
            case ActionNames.model_node_update:
                this.update(node);
                break;
            case ActionNames.model_node_update_select:
                this.update(node);
                break;
            case ActionNames.model_node_update_multi_select:
                this.update(node);
                break;
        }
    }

    private removePrintNode(tagNode: ITagNode) {
        this.load(this.xmlEntity);  //暂时做整个View刷新测试效果，后面看情况改进
    }


    /*    remove(tagNode:ITagNode | undefined):void{
            if (!tagNode) return undefined;
            this.load(this.xmlEntity);
            var tagStack: ITagNode[] = [];

        }*/

    /**
     * 更新节点视图,前提:tagNode必须已经在xmlEntity中存在
     */
    update(tagNode: ITagNode | undefined): void {
        if (!this.getSelectionModel().getBMultiSelection()) {
            this.load(this.xmlEntity);
        }
        if (!tagNode) return undefined;
        if (tagNode.getTagName() == PrintConstants.NODE_Grid) {
            var selected = tagNode.isSelected();
            var tagStack: ITagNode[] = [];
            let children = tagNode.getChildren();
            if (children.length > 0) {
                for (let child of children) {
                    tagStack.push(<ITagNode>child);
                }
            }
        } else {
            var selected = tagNode.isSelected();
            var tagStack: ITagNode[] = [];
            while (tagNode) {
                tagStack.push(tagNode);
                tagNode.setSelected(selected);
                if (tagNode == this.getTagNode()) break;
                tagNode = tagNode.getParent();
            }
            var rootTag = tagStack.pop();
            if (rootTag!.getTagName() != "" &&rootTag != this.getTagNode()) {
                throw new Error("未知的根节点");
            }
        }
        var stackNode;
        /*         if (tagStack.length >= 4) {
                    console.log("dddddddddddddddddddddddddd");
                } */
        var view: IPrintElementView = this;
        while (stackNode = tagStack.pop()) {
            var tmpView = view.findChildNode(stackNode);
            if (tmpView) {
                tmpView.updateView();
                view = tmpView;
            }
            if (tagStack.length == 0) break;
        }
    }

    public hideToolbar() {
        this.toolBar.hide();
        this.pageOpt.hide();
    }

}
