import ISelectable from "../../../common/selection/ISelectable";
import GlobalConstants from "../../../common/struct/GlobalConstants";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import PrintConstants from "../base/PrintConstants";
import SectionView from "../view/element/SectionView";
import {CellView} from "../view/element/CellView";
import {node} from "webpack";


export default class PrintNodeUtil {

    static createSetionNode(xmlEntity: IXmlEntity, type: string,): ITagNode {
        var sectionNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Section);
        sectionNode.setAttributeValue(GlobalConstants.S_Type, type);
        var columnsNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Columns);
        columnsNode.setParent(sectionNode);
        for (let i: number = 0; i < 4; i++) {
            var columnNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Column);
            columnNode.setAttributeValue(PrintConstants.ATTR_Width, "80");
            columnNode.setParent(columnsNode);
            columnsNode.addChild(columnNode);
        }
        var rowsNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Rows);
        rowsNode.setParent(sectionNode)
        for (let i: number = 0; i < 3; i++) {
            var rowNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Row);
            rowNode.setParent(rowsNode);
            rowNode.setAttributeValue(PrintConstants.ATTR_Height, "30")
            for (let i: number = 0; i < 4; i++) {
                var cellNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
                cellNode.setParent(rowNode);
                rowNode.addChild(cellNode);
            }
            rowsNode.addChild(rowNode);
        }

        sectionNode.addChild(columnsNode);
        sectionNode.addChild(rowsNode);
        return sectionNode;
    }

    static createRowNode(xmlEntity: IXmlEntity, type: string, rowLength: number): ITagNode {
        var rowNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Row);
        rowNode.setAttributeValue(PrintConstants.ATTR_Height, "30")

        for (let i: number = 0; i < rowLength; i++) {
            var cellNode = xmlEntity.getNodeFactory().createTagNode(PrintConstants.NODE_Cell);
            cellNode.setParent(rowNode);
            rowNode.addChild(cellNode);
        }
        return rowNode;
    }

    static reloadReport(xmlEntity: ITagNode): void {
        var children = xmlEntity.getChild("Grid")!.getChildren();
        for (let i = 0; i < children.length; i++) {
            var iNode = <ITagNode>children[i];
            var children1 = iNode.getChildren();
            for (let j = 0; j < children1.length; j++) {
                var iNode1 = <ITagNode>children1[j];
                if (iNode1.getTagName() == "Rows") {
                    this.reloadSpan(iNode1)
                }
            }
        }


    }


    static reloadSpan(rowsNode: ITagNode): ITagNode {
        let rows = rowsNode.getChildren();
        for (let i = 0; i < rows.length; i++) {
            let rowNode = <ITagNode>rows[i];
            let cells = rowNode.getChildren();
            for (let j = 0; j < cells.length; j++) {
                let cellNode = <ITagNode>cells[j];
                let isHead = cellNode.getAttributeValue(PrintConstants.ATTR_IsMergedHead, "false");
                if (isHead == "true") {
                    let columnSpan = cellNode.getAttributeValueInt(PrintConstants.ATTR_MergedColumnSpan, 0);
                    let rowSpan = cellNode.getAttributeValueInt(PrintConstants.ATTR_MergedRowSpan, 0);
                    let rowIndex = 1;
                    let itemp = i;
                    let flag = false;
                    for (let k = 0; k < rowSpan; k++) {
                        let currRowNode = <ITagNode>rows[i];
                        i++;
                        let clls = currRowNode.getChildren();
                        let columnNdex = 1;
                        let index = j
                        let head = true;
                        for (let l = 0; l < columnSpan - 1; l++) {
                            if (!flag) {
                                index++;
                                let cll = <ITagNode>clls[index];
                                cll.setAttributeValue(PrintConstants.ATTR_IsMerged, "true")
                                cll.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan, columnNdex.toString())
                                cll.removeAttribute(PrintConstants.ATTR_MergedRowSpan);
                                columnNdex++;
                            } else {
                                let cll = <ITagNode>clls[index];
                                index++;
                                if (head) {
                                    cll.setAttributeValue(PrintConstants.ATTR_MergedRowSpan, rowIndex.toString())
                                } else {
                                    cll.setAttributeValue(PrintConstants.ATTR_IsMerged, "true")
                                    cll.setAttributeValue(PrintConstants.ATTR_MergedRowSpan, rowIndex.toString())
                                    cll.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan, columnNdex.toString())
                                    if (l >= columnSpan - 2) {
                                        let cll1 = <ITagNode>clls[index];
                                        cll1.setAttributeValue(PrintConstants.ATTR_IsMerged, "true")
                                        cll1.setAttributeValue(PrintConstants.ATTR_MergedRowSpan, rowIndex.toString())
                                        cll1.setAttributeValue(PrintConstants.ATTR_MergedColumnSpan, (columnNdex + 1).toString())
                                    }
                                    columnNdex++;
                                }

                                head = false;
                            }
                        }
                        if (k >= rowSpan - 1) {
                            j = index;
                        }
                        if (flag) {
                            rowIndex++
                        }
                        flag = true;
                    }
                    i= itemp;
                }
            }
        }
        return rowsNode;
    }

    public static getCellViewByTagNode(sectionView: SectionView, tagNode: ITagNode): CellView | null {
        var lastRowIndex = sectionView!.getLastRowIndex();
        var lastColumnIndex = sectionView!.getLastColumnIndex();
        for (let j = 0; j <= lastColumnIndex; j++) {
            for (let i = 0; i <= lastRowIndex; i++) {
                var cellView = sectionView!.locCell(i, j);
                if (cellView && cellView.getTagNode()) {
                    if (cellView.getTagNode() == tagNode) {
                        return cellView;
                    }
                }
            }
        }
        return null;
    }

}