import AbstractPrintOptState from "./AbstractPrintOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import BaseConstants from "../../base/BaseConstants";
import SectionView from "../view/element/SectionView";
import MoveNodeCmd from "../../bpm/cmd/MoveNodeCmd";
import DragStateCmd from "../cmd/DragStateCmd";
import XmlEntity from "../../../common/xml/XmlEntity";

export default class ResizeState extends AbstractPrintOptState {

    private start: number = -1;
    private tagNode?: ITagNode;
    private column?: ITagNode;
    private el: any;
    private startX = 0;
    private startY = 0;
    private startWidth? :number;
    private endWidth? :number;

    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        var hitMultiTagNode = this.getView().hitMultiTagNode(x - 2, y);
        this.tagNode = hitMultiTagNode?.getTagNode();
        let cells =  this.tagNode!.getParent()!.getChildren();
        let index = cells.indexOf( this.tagNode!);
        let section =  this.tagNode!.getParent()!.getParent()!.getParent();
        let colums = <ITagNode>section!.getChildren()[0];
        let columNodes = colums.getChildren();
        let column = <ITagNode>columNodes[index];
        this.startWidth = column.getAttributeValueInt(BaseConstants.ATTR_Width,0);
        this.column = column;
        this.start = x;
        this.startX = x;
        this.startY = y;
    }

    mousemove(e: MouseEvent): void {
        let ele = <HTMLElement>e.target;
        if (e.button == 0 && e.buttons == 1) {
            var {x, y} = this.getPosition(e);
            let cell = this.tagNode!;
            let length: number = this.start - x;
            let number = Math.abs(length);
            let cells = cell.getParent()!.getChildren();
            let index = cells.indexOf(cell);
            let section = cell.getParent()!.getParent()!.getParent();
            let colums = <ITagNode>section!.getChildren()[0];
            let columNodes = colums.getChildren();
            let column = <ITagNode>columNodes[index];
            let width = column.getAttributeValue(BaseConstants.ATTR_Width);
            let orgLength = Number(width);
            if (length > 0) {//缩小
                if ((orgLength - number) > 10) {
                    let newLength = orgLength - number;
                    this.getView().initDragState(this.getView(),this.column!,newLength,0,false,false)
                   // column.setAttributeValue(BaseConstants.ATTR_Width, newLength.toString());
                  //  this.getView().getXmlEntity().update(column, true);
                    this.start = x
                    this.endWidth = newLength;
                }
            } else {//拉大
                let newLength = orgLength + number;
                this.getView().initDragState(this.getView(),this.column!,newLength,0,false,false)
              //  column.setAttributeValue(BaseConstants.ATTR_Width, newLength.toString());
               // this.getView().getXmlEntity().update(column, true);
                this.start = x
                this.endWidth = newLength;
            }
        } else if (ele.className.indexOf("row-resize-ltr") != -1 && e.buttons != 1) {
            this.getDelegate().setRowReszieState();
            // this.getDelegate().setNormalState();
        } else if (ele.className.indexOf("col-resize-ltr") < 0 && e.button == 0 && e.buttons != 1) {
            this.getDelegate().setNormalState();
        }
    }

    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        this.getView().initDragState(this.getView(),this.column!,this.endWidth!,this.startWidth!,true,false)

    }


    getTagNode(): any {
        return this.tagNode;
    }

    seTagNode(value: any) {
        this.tagNode = value;
    }


    getEl(): any {
        return this.el;
    }

    setEl(value: any) {
        this.el = value;
    }

    getStart(): any {
        return this.start;
    }

    setStart(value: any) {
        this.start = value;
    }
}

