import IXmlEntity from "../../../common/xml/IXmlEntity";
import IPropertyItem from "../../plugin/property/base/PropertyDefine";
import PropertyIO from "../../plugin/property/base/PropertyIO";
import PrintGraphicView from "../view/PrintGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import {XMLElementType} from "../../../common/enum/Enums";
import ExcelConstants from "../../excel/base/ExcelConstants";
import PrintPropertyDefine from "../base/PrintPropertyDefine";
import PrintConstants from "../base/PrintConstants";
import BaseConstants from "../../base/BaseConstants";

export class PrintPropertyIO extends PropertyIO {
    private printGraphicView: PrintGraphicView
    private xmlEntity: IXmlEntity

    constructor(xmlEntity: IXmlEntity, printGraphicView: PrintGraphicView) {
        super(xmlEntity);
        this.xmlEntity = xmlEntity;
        this.printGraphicView = printGraphicView
    }

    setValue(propertyItem: IPropertyItem, propertyValue: any): void {


        var proertyNode = this.ensureProertyNode(propertyItem, <ITagNode>this.curTagNode);
        if (proertyNode) {
            var oldValue = "";
            if (propertyItem.type === "CDATA") {
                var child = proertyNode.getChild(propertyItem.key);
                if (child == null) {
                    oldValue = '无属性';
                } else {
                    oldValue = child.getCDATAValue();
                }
            } else {
                oldValue = proertyNode!.getAttributeValue(propertyItem.key, '无属性')
            }
            if (oldValue === "无属性") {
                if (propertyItem.defaultvalue === propertyValue) {
                    return;
                }
            } else {
                if (oldValue === propertyValue) {
                    return;
                }
            }
            var tagNode = PropertyIO.setPropertyValue(proertyNode, propertyItem, propertyValue);
            tagNode && this.xmlEntity.update(tagNode, propertyItem.updateAttributeOnly);
        } else {
            if (propertyItem.key == "Padding" && propertyValue){
             let newValue = propertyValue.toString();
             let strings = newValue.split(",");
             if (strings.length<4){
                 for (let i = 1; i <= 4-strings.length; i++) {
                     newValue = newValue +",0";
                 }
             }
             propertyValue = newValue;
            }else if (propertyItem.key == "Type"){
                let newValue = propertyValue.toString();
                if (newValue == "Text"){
                   this.curTagNode?.removeAttribute("Path");
                   this.curTagNode?.removeAttribute("ImageSourceType");
                }
            }else if (propertyItem.key == "SourceType"){
                let newValue = propertyValue.toString();
                switch (newValue){
                    case "Field":
                        this.curTagNode?.removeAttribute("Formula");
                        this.curTagNode?.removeAttribute("Impl");
                        this.curTagNode?.removeAttribute("PageNo");
                        this.curTagNode?.removeAttribute("SystemContent");
                        break;
                    case "Formula":
                        this.curTagNode?.removeAttribute("TableKey");
                        this.curTagNode?.removeAttribute("FieldKey");
                        this.curTagNode?.removeAttribute("Impl");
                        this.curTagNode?.removeAttribute("PageNo");
                        this.curTagNode?.removeAttribute("SystemContent");
                        break;
                    case "Interface":
                        this.curTagNode?.removeAttribute("TableKey");
                        this.curTagNode?.removeAttribute("FieldKey");
                        this.curTagNode?.removeAttribute("Formula");
                        this.curTagNode?.removeAttribute("PageNo");
                        this.curTagNode?.removeAttribute("SystemContent");
                        break;
                    case "PageNo":
                        this.curTagNode?.removeAttribute("TableKey");
                        this.curTagNode?.removeAttribute("FieldKey");
                        this.curTagNode?.removeAttribute("Formula");
                        this.curTagNode?.removeAttribute("Impl");
                        this.curTagNode?.removeAttribute("SystemContent");
                        break;
                    case "System":
                        this.curTagNode?.removeAttribute("TableKey");
                        this.curTagNode?.removeAttribute("FieldKey");
                        this.curTagNode?.removeAttribute("Formula");
                        this.curTagNode?.removeAttribute("Impl");
                        this.curTagNode?.removeAttribute("PageNo");
                        break;
                        case "Const":
                        this.curTagNode?.removeAttribute("TableKey");
                        this.curTagNode?.removeAttribute("FieldKey");
                        this.curTagNode?.removeAttribute("Formula");
                        this.curTagNode?.removeAttribute("Impl");
                        this.curTagNode?.removeAttribute("PageNo");
                        this.curTagNode?.removeAttribute("SystemContent");
                        break;
                }
            }
            var oldValue = "";
            if (propertyItem.type === "CDATA") {
                var child = this.curTagNode!.getChild(propertyItem.key);
                if (child == null) {
                    oldValue = '无属性';
                } else {
                    oldValue = child.getCDATAValue();
                }
            } else {
                oldValue = this.curTagNode!.getAttributeValue(propertyItem.key, '无属性')
            }
            if (oldValue === "无属性") {
                if (propertyItem.defaultvalue === propertyValue) {
                    return;
                }
            } else {
                if (oldValue === propertyValue) {
                    return;
                }
            }
            super.setValue(propertyItem, propertyValue);
        }
    }

    getValue(propertyItem: IPropertyItem): any {
        var tagNode = this.ensureProertyNode(propertyItem, <ITagNode>this.curTagNode);
        if (tagNode) {
            var text = tagNode.getAttributeValue(propertyItem.textAttributeKey);
            switch (propertyItem.type) {
                case XMLElementType.ATTRIBUTE:
                    if (tagNode.hasAttribute(propertyItem.key)) {
                        return tagNode.getAttributeValue(propertyItem.key);
                    } else {
                        if (!text) {
                            return propertyItem.defaultvalue ? propertyItem.defaultvalue : "";
                        } else {
                            return text;
                        }
                    }
                case XMLElementType.CDATA:
                    var tmpNode = tagNode.getChild(propertyItem.key);
                    return tmpNode ? tmpNode.getCDATAValue() : "";
                case XMLElementType.COLLECTION:
                    var collection = tagNode.ensureChild(propertyItem.key);
                    return collection;
            }
        } else {
            return super.getValue(propertyItem);

        }
    }

    getPrintGraphicView(): PrintGraphicView {
        return this.printGraphicView;
    }

    private ensureProertyNode(propertyItem: IPropertyItem, curTagNode: ITagNode): ITagNode | null {
        var tagNode = null;
        if (propertyItem.tag != curTagNode.getTagName() && propertyItem.tag == ExcelConstants.NODE_Column && curTagNode.getTagName() == ExcelConstants.NODE_Cell) {//列处理
            if (curTagNode.getParent()) {//说明界面存在的且Xml也存在的节点
                var child = curTagNode.getParent()!.getParent()!.getParent()?.getChild(ExcelConstants.ATTR_Columns);
                if (child) {//Print//找列
                    var colIndex = curTagNode.getParent()!.getChildren().indexOf(curTagNode);
                    for (let i = 0; i < child.getChildren().length; i++) {
                        if (colIndex == i) {
                            var child1 = child.getChildren()[i];
                            if (child1) tagNode = <ITagNode>child1;
                            break;
                        } else {
                            continue;
                        }
                    }
                }
            }

        }
        if (propertyItem.tag == PrintConstants.NODE_Row) {
            tagNode = <ITagNode>curTagNode.getParent();
        }
        if (propertyItem.tag == PrintConstants.NODE_Section) {
            tagNode = <ITagNode>curTagNode.getParent()!.getParent()!.getParent();
        }
        return tagNode;
    }

}