import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export default class SetBorderColorCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private xmlEntity: IXmlEntity;
    private alignmentValue: string;
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private alignmentType: string[];
    private tagName: string;

    constructor(tagName: string, xmlEntity: IXmlEntity, tagNode: ITagNode[], alignmentValue: string, alignmentType: string[]) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.alignmentValue = alignmentValue;
        this.alignmentType = alignmentType;
        this.tagName = tagName;
    }

    do(): boolean {
        if (this.iTagNodes.length==0){
            return true;
        }
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            if (!tagNode.getParent()) {
                continue;
            }
            if (this.tagName == "" || tagNode.getTagName() != "Cell") {
            } else {
                var split = this.tagName.split(";");
                if (tagNode!.getChild(split[0]) && tagNode!.getChild(split[0])!.getChild(split[1])) {
                    this.oldITagNodes = this.oldITagNodes || []
                    this.newITagNodes = this.newITagNodes || []
                    var child = <ITagNode>tagNode!.getChild(split[0])!.getChild(split[1]);
                    var attributes = child!.getAttributes();
                    for (let j = 0; j < attributes!.length; j++) {
                        this.oldITagNodes.push(child);
                        var iAttribute = attributes[j];
                        var isModify = false;
                        //"BottomStyle", "LeftStyle", "RightStyle", "TopStyle"
                        switch (String(iAttribute.getKey())) {
                            case "TopStyle" :
                                child?.setAttributeValue(this.alignmentType[0], this.alignmentValue);
                                isModify = true;
                                break;
                            case "BottomStyle" :
                                child?.setAttributeValue(this.alignmentType[1], this.alignmentValue);
                                isModify = true;
                                break;
                            case "LeftStyle" :
                                child?.setAttributeValue(this.alignmentType[2], this.alignmentValue);
                                isModify = true;
                                break;
                            case "RightStyle" :
                                child?.setAttributeValue(this.alignmentType[3], this.alignmentValue);
                                isModify = true;
                                break;
                        }
                        this.newITagNodes.push(child);
                        if (!isModify) {
                            this.newITagNodes.pop()
                            this.oldITagNodes.pop()
                        }

                    }

                } else {
                    continue;
                }

            }
        }
        if (this.oldITagNodes) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
        return true;
    }

    undo(): void {
        if (this.iTagNodes.length <= 0 || !this.oldITagNodes || this.oldITagNodes.length <= 0) {
            return;
        }
        for (let i = 0; i < this!.newITagNodes!.length; i++) {

            var attributes = this!.newITagNodes![i]!.getAttributes();
            attributes.length = 0;
            for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                attributes.push(this.oldITagNodes[i].getAttributes()[j]);
            }
        }
        if (this.oldITagNodes && this.oldITagNodes!.length > 0) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}