import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export default class SetAlignmentCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private xmlEntity: IXmlEntity;
    private alignmentValue: string;
    private alignmentOldValue: string[];
    private alignmentType: string;
    private tagName: string;
    private defaultValue: string ;

    constructor(tagName: string, xmlEntity: IXmlEntity, tagNode: ITagNode[], alignmentValue: string, alignmentOldValue: string[], alignmentType: string,defaultValue?:string) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.alignmentValue = alignmentValue;
        this.alignmentType = alignmentType;
        this.alignmentOldValue = alignmentOldValue;
        this.tagName = tagName;
        if (!defaultValue){
            this.defaultValue = "";
        }else {
            this.defaultValue = defaultValue;
        }
    }

    do(): boolean {
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            if (this.tagName == "" || tagNode.getTagName() != "Cell") {
            } else {
                var split = this.tagName.split(";");
                for (let j = 0; j < split.length; j++) {
                    tagNode = tagNode!.ensureChild(split[j]);
                }
            }
            this.alignmentOldValue[i] = tagNode!.getAttributeValue(this.alignmentType);
            tagNode!.setAttributeValue(this.alignmentType, this.alignmentValue,this.defaultValue);
        }
        if (this.alignmentOldValue.length > 0) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
        return true;
    }

    undo(): void {
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            if (this.tagName == "" || tagNode.getTagName() != "Cell") {
            } else {
                var split = this.tagName.split(";");
                for (let j = 0; j < split.length; j++) {
                    tagNode = tagNode!.ensureChild(split[j]);
                }
            }
            tagNode!.setAttributeValue(this.alignmentType, this.alignmentOldValue[i]);
        }
        if (this.alignmentOldValue.length > 0) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}