import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import PrintGraphicView from "../view/PrintGraphicView";
import PrintConstants from "../base/PrintConstants";
import PrintNodeUtil from "../util/PrintNodeUtil";
import XmlEntityUtil from "../../../common/xml/util/XmlEntityUtil";
import Var from "../../../common/struct/Var";

export default class NewSectionElementCmd implements ICmd {

    private tagNodes: ITagNode;


    private view: PrintGraphicView;

    private cmd: String;

    private tagNode?: ITagNode;


    constructor(view: PrintGraphicView, tagNodes: ITagNode[], cmd: String) {
        this.view = view;
        this.tagNodes = tagNodes[tagNodes.length - 1];
        this.cmd = cmd;
    }

    do(): boolean {
        var xmlEntity = this.view.getXmlEntity();
        let tagNode = this.tagNodes;
        var newNode = PrintNodeUtil.createSetionNode(xmlEntity, PrintConstants.NODE_Paragraph);
        this.tagNode = newNode;
        let sectionNode = tagNode!.getParent()!.getParent()!.getParent()!;
        let gridNode = tagNode!.getParent()!.getParent()!.getParent()!.getParent();
        let children = gridNode!.getChildren();
        let index: number = children.indexOf(sectionNode);
        newNode.setParent(<ITagNode>gridNode);

        var num = 1;
        while (gridNode!.find(PrintConstants.NODE_Section, PrintConstants.ATTR_Key, PrintConstants.NODE_Section + String(num))) {
            num++;
        }
        newNode.setAttributeValue(PrintConstants.ATTR_Key, PrintConstants.NODE_Section + String(num));
        if (PrintConstants.NODE_AddParagraph_Before == this.cmd) {
            children.splice(index, 0, newNode);
        } else if (PrintConstants.NODE_AddParagraph_After == this.cmd) {
            children.splice(index + 1, 0, newNode);
        }
        xmlEntity?.update(gridNode, true)
        xmlEntity?.update(this.tagNode, true)
        xmlEntity.getTagRoot().resetLineIndex(new Var(0));//源代码的定位需要startLinde和endLine所以需要去对新加的Sectionc重新reload进行计算
        return true;
    }


    undo(): void {
        var xmlEntity = this.view.getXmlEntity();
        xmlEntity?.removeNode(<ITagNode>this.tagNode);
        xmlEntity.getTagRoot().resetLineIndex(new Var(0));
    }

}