import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import TagNode from "../../../common/xml/node/TagNode";
import Var from "../../../common/struct/Var";
import PrintGraphicView from "../view/PrintGraphicView";

export default class InputCellCmd implements ICmd {
    private iTagNode?: ITagNode;
    private oldValue?: string;

    private sefl: PrintGraphicView
    private e: any

    constructor(sefl: PrintGraphicView, e: any) {
        this.sefl = sefl;
        this.e = e;
    }

    do(): boolean {
        var e = this.e;
        var sefl = this.sefl;
        var view2 = sefl.getSectionViews();
        var el = <HTMLElement>this.e.target;
        var offsetParent = el.parentElement;
        var startX = Number(offsetParent!.getAttribute("rowindex"))
        var startY = Number(offsetParent!.getAttribute("colindex"))
        var childNode1 = view2!.getChildNode(startX, startY);
        var tagNode1 = childNode1?.getTagNode();


        var value = String($(e.target).val());
        var oldValue = tagNode1?.getAttributeValue("Caption", "");
        this.oldValue = oldValue;
        this.iTagNode = tagNode1;
        tagNode1?.setAttributeValue("Caption", value, "");

        //this.sefl.getXmlEntity().update(this.sefl.getXmlEntity().getTagRoot(), false);
        if (this.oldValue) {
            this.sefl.getXmlEntity().getSelectionModel().select(this.iTagNode);
        }
        return true;
    }

    undo(): void {
        if (this.oldValue) {
            this.iTagNode!.setAttributeValue("Caption", this.oldValue);
            this.sefl.getXmlEntity().getSelectionModel().select(this.iTagNode);
        }

        /*if (this.iTagNodes.length <= 0) {
            return;
        }
        if (this.oldITagNodes && this.oldITagNodes!.length > 0) {
            for (let i = 0; i < this!.newITagNodes!.length; i++) {

                var attributes = this!.newITagNodes![i]!.getAttributes();
                attributes.length = 0;
                for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                    attributes.push(this.oldITagNodes[i].getAttributes()[j]);
                }
            }
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            for (let i = 0; i < this.iTagNodes.length; i++) {
                selectionModel.MultiSelection(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    */
    }
}