import PropertyUIControl from "../PropertyUIControl";
import PropertyUIPanel from "../PropertyUIPanel";
import AbstractPropertyState from "./AbstractPropertyState";

export default class ResizeState extends AbstractPropertyState {

    private startX: number = -1;

    private orgRatio = -1;

    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        this.startX = x;
        this.orgRatio = this.view.getRatio();
    }

    mousemove(e: MouseEvent): void {
        if (!this.isLeftMouseButtonDowning()) return;
        var {x, y} = this.getPosition(e);
        var offsetX = x - this.startX;
        var totalWidth = this.getView().getEl().clientWidth;;
        var leftWidth = totalWidth * this.orgRatio;
        var rightWidth = totalWidth * (1 - this.orgRatio);
        leftWidth += offsetX;
        rightWidth -= offsetX;
        if (leftWidth < 10) return;
        if (leftWidth > (totalWidth - 10)) return;
        var newRatio = leftWidth / totalWidth;
        this.view.setRatio(newRatio);
    }
    
    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        this.getDelegate().setNormalState();
    }
}

