import IXElement from "../../../../../common/dom/xelement/IXElement";
import AbstractOptState from "../../../../../common/state/AbstractOptState";
import IPropertyView from "../IPropertyView";
import PropertyStateDelegate from "./PropertyStateDelegate";

export default abstract class AbstractPropertyState extends AbstractOptState<IPropertyView, PropertyStateDelegate> {

    protected view: IPropertyView;

    constructor(delegate: PropertyStateDelegate) {
        super(delegate);
        this.view = delegate.getView();
    }

    getView(): IPropertyView {
        return this.view;
    }

    getViewEl(): HTMLElement {
        return this.view.getEl();
    }
}