import { IPropertyGroup, IPropertyIO, IPropertyPlugin } from "./base/PropertyDefine";
import DomUtil from "../../../common/dom/DomUtil";
import PropertyUIPanel from "./ui/PropertyUIPanel";
import PropertyUIControl from "./ui/PropertyUIControl";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";

export default class PropertyPlugin implements IPropertyPlugin {

    private propertyPanel?: PropertyUIPanel;

    private mapProperties: any = {};

    protected optDispatcher?: OperationDispatcher;

    constructor(optDispatcher?: OperationDispatcher) {
        this.optDispatcher = optDispatcher;
    }

    register(componentName: string, propertyDefine: IPropertyGroup[]): void {
        this.mapProperties[componentName] = propertyDefine;
    }

    getPropertyGroupArray(componentName: string) : IPropertyGroup[] {
        return this.mapProperties[componentName];
    }

    commit(): void {
        if (this.propertyPanel) {
            this.propertyPanel.unfocus();
        }
    }

    setPropertyValue(key: string, value: any, text?: string): void {
        this.propertyPanel?.setPropertyValue(key, value, text);
    }

    setFocus(key: string): void {
        this.propertyPanel?.setFocus(key);
    }

    display(componentName: string, callback: IPropertyIO, parent: HTMLElement): void {
        var len = parent.childNodes.length;
        for (var i=len-1; i>=0; i--){
            var child = parent.childNodes[i];
            if (child.nodeType == 1) {
                parent.removeChild(child);
            }
        }
        var propertyGroups: IPropertyGroup[] = this.getPropertyGroupArray(componentName);
        this.propertyPanel = new PropertyUIPanel(propertyGroups, callback, this.optDispatcher);
        parent.appendChild(this.propertyPanel.getEl());
        this.propertyPanel.resize(parent.clientWidth, parent.clientHeight);
        window.addEventListener("resize", (e: any) => {
            this.propertyPanel?.resize(parent.clientWidth, parent.clientHeight);
        });

        window.addEventListener("click", (e: any) => {
            var el: HTMLElement | null =  DomUtil.findParentElByClassName(e.target, "property-control-line");

            if (!this.isModalDialog()) {
                var propertyLine: PropertyUIControl | null = <PropertyUIControl> this.propertyPanel?.findElement(el);
                if (!propertyLine && !DomUtil.isInDialog(e.target)) {
                    this.propertyPanel?.unfocus();
                    return;
                }
            }
        }, true);
    }

    protected isModalDialog(): boolean {
        return false;
    }
}
