import AbstractGraphicView from "../../base/AbstractGraphicView";
import ExcelOptStateDelegate from "../state/ExcelOptStateDelegate";
import ITagNode from "../../../common/xml/node/ITagNode";
import Paras from "../../../common/struct/Paras";
import AbstractPropertyDefine from "../../plugin/property/base/AbstractPropertyDefine";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import IExcelElementView from "./element/IExcelElementView";
import SizeInfo from "../../../common/struct/SizeInfo";
import PrintConstants from "../../print/base/PrintConstants";
import AbstractDomElement from "../../../common/dom/AbstractDomElement";
import DomUtil from "../../../common/dom/DomUtil";
import JComponent from "../../../common/component/JComponent";
import Menu from "../../../common/component/menu/Menu";
import SelectionModel from "../../../common/selection/SelectionModel";
import CmdQueue from "../../../common/cmd/CmdQueue";
import ActionNames from "../../../common/event/ActionNames";
import ContainerPanel from "../../../common/component/container/panel/ContainerPanel";
import BorderPanel from "../../../common/component/container/panel/BorderPanel";
import H5VFlexPanel from "../../../common/component/container/panel/H5VFlexPanel";
import ExcelPropertyDefine from "../base/ExcelPropertyDefine";
import P18N from "../../print/base/P18N";
import SheetView from "./element/SheetView";
import Button from "../../../common/component/control/Button";
import {ExcelCellView} from "./element/ExcelCellView";
import TagNode from "../../../common/xml/node/TagNode";
import InputCellCmd from "../cmd/InputCellCmd";
import ExcelConstants from "../base/ExcelConstants";
import ExcelToolbar from "./ExcelToolbar";
import EXCEL from "../base/EXCEL";
import TextEditor from "../../../common/component/control/TextEditor";
import InputSheetCmd from "../cmd/InputSheetCmd";
import DeleteSheetCmd from "../cmd/DeleteSheetCmd";
import DomElement from "../../../common/dom/element/DomElement";
import DragStateCmd from "../cmd/DragStateCmd";
import ExcelTablePanelHead from "./ExcelTablePanelHead";
import ExcelButtonBox from "./ExcelButtonBox";
import Var from "../../../common/struct/Var";


export default class ExcelGraphicView extends AbstractGraphicView<ExcelOptStateDelegate> implements IExcelElementView {
    private xmlEntity!: IXmlEntity;

    private boardContainer: ContainerPanel;

    //打印设计窗口(含尺码)
    private designView: BorderPanel;
    //单元格右键操作列表
    private toolBar: Menu;
    //单元格右键页面操作列表
    private pageOpt: Menu;
    //打印模板视图
    private innerTemplateView: H5VFlexPanel;
    private innerTemplateTableView!: ExcelTablePanelHead;
    private excelToolbar: ExcelToolbar;
    private selectSheetViewName: string = "";
    private selectExcelViews: ExcelCellView[] = [];

    // 视图元素集合

    private sheetViews: Map<string, IExcelElementView> = new Map<string, IExcelElementView>()
    private tableButtonViewElements: Map<string, Button> = new Map<string, Button>()

    constructor() {
        // super(PrintGraphicView.TOOLBOX_WIDTH, 0, 0, 0);
        super(0, 0, 96, 30);
        //var toolbox = new PrintToolbox();
        // this.setLeft(toolbox);
        // toolbox.bindGraphicView(this);
        this.boardContainer = new ContainerPanel();
        this.boardContainer.addClass("excel-desgin")
        this.setCenter(this.boardContainer);

        this.excelToolbar = new ExcelToolbar()
        this.excelToolbar.setHeight(SizeInfo.valueOfPX(96));
        this.excelToolbar.initGrid(
            [SizeInfo.valueOfPX(32), SizeInfo.valueOfPX(32), SizeInfo.valueOfPX(32)],
            [SizeInfo.valueOfPX(380), SizeInfo.AUTO_SIZE, SizeInfo.AUTO_SIZE, SizeInfo.AUTO_SIZE],
            null, null
        );
        this.setTop(this.excelToolbar);

        this.innerTemplateTableView = new ExcelTablePanelHead();
        this.innerTemplateTableView.addClass('excelTable');
        this.setBottom(this.innerTemplateTableView);
        var excelSkin = this.styleFactory.getExcelSkin();

        //打印设计窗口容器
        var board = new ContainerPanel();
        board.addClass(excelSkin.excel_board);
        this.boardContainer.addComponent(board);
        //board.setStyle('padding', '24px');

        this.designView = new BorderPanel(0, 0, 0, 0);
        this.designView.setStyle('background', 'white');
        board.addComponent(this.designView);
        //右键工具栏
        window.oncontextmenu = function () {
            return false
        }//禁用页面右键
        this.pageOpt = new Menu();
        this.pageOpt.addMenuItem(ExcelConstants.Node_Page_Opt, P18N.getString(PrintConstants.Node_Page_Opt));
        this.toolBar = new Menu();

        // 打印元素容器
        this.innerTemplateView = new H5VFlexPanel();
        this.innerTemplateView.addClass('excelarea');
        this.designView.setCenter(this.innerTemplateView);

        /*   this.initViewMouseEvent(this.innerTemplateView.getDomElement());*/
        this.initoncontextmune(this.innerTemplateView.getDomElement())
    }

    selectExcelView(excelCellView: ExcelCellView): void {
        this.selectExcelViews.push(excelCellView);
    }

    reloadSelectExcelView(): void {
        this.selectExcelViews = []
    }

    initInnerTemplateTableView(xmlEntity: IXmlEntity): void {
        this.innerTemplateTableView.removeAll();
        this.tableButtonViewElements.clear();
        var root = xmlEntity.getTagRoot();
        var tagSheets = root.getChildren();
        for (let i = 0; i < tagSheets.length; i++) {
            var iNode = <ITagNode>tagSheets[i];
            var name = iNode.getAttributeValue("Name");
            var sefl = this;
            // sheet页按钮
            var sheetButton = new Button(name);

            sheetButton.addClass("excel-button");
            sheetButton.setValue(name);
            sheetButton.setStyle("position", "relative")
            sheetButton.setOnClickListener((e: MouseEvent) => {
                var target = <HTMLElement>e.target;
                // 此处innerText获取的值会将空格截去
                var innerHTML = target.innerHTML.replace(/<.+?>/gim, '');
                var button12 = this.tableButtonViewElements.get(innerHTML);
                if (e.button == 0 && this.getSelectSheetViewName() == innerHTML && button12!.getDomElement().hasClass("selected")
                    && e.clientX != 0 && e.clientY != 0) {
                    let value = button12!.getValue();
                    button12!.setText("");
                    //   button12!.setStyle("padding", "0 6px")

                    var textEditor1 = new TextEditor();
                    textEditor1.setStyle("display", "block");
                    textEditor1.setStyle("width", "60px");
                    textEditor1.setStyle("height", "100%")
                    textEditor1.setStyle("disabled", "true");
                    textEditor1.addEventListener("blur", (e: any) => {
                        sefl.getOptStateDelegate().setNormalState();
                        sefl.initInputSheetState(sefl, button12!, e);
                    });
                    textEditor1.addEventListener("focus", (e: any) => {
                        sefl.getOptStateDelegate().setInputState();
                    });

                    button12!.getDomElement().addChild(textEditor1.getDomElement());
                    setTimeout(function () {
                        textEditor1.setValue(value);
                        textEditor1.getEl().focus();
                    }, 10);
                } else if (button12 && button12.getValue()) {
                    this.selectSheetViewName = innerHTML;
                    button12!.addClass("selected");
                    sefl.loadSheetView(sefl.xmlEntity);
                } else if (target.tagName == "IMG") {
                    sefl.initDeletSheetView(sefl, e);
                }
            });
            this.innerTemplateTableView.addOneComponent(sheetButton, SizeInfo.valueOfPX(60));
            this.tableButtonViewElements.set(name, sheetButton);
        }
        var button2 = new Button("+");
        button2.addClass("excel-button");
        button2.setOnClickListener((e: MouseEvent) => {
            var size = 1;
            var newStr = "Sheet";
            while (this.tableButtonViewElements.get(newStr + size)) {
                size++;
            }
            this.selectSheetViewName = newStr + size;
            var tagNode = new TagNode("Sheet");
            tagNode.addChild(new TagNode("Rows"));
            tagNode.setAttributeValue('Name', this.selectSheetViewName);
            this.xmlEntity.getTagRoot().addChild(tagNode);
            this.xmlEntity.update(tagNode, false)
        });
        // Pull down
        var button3 = new ExcelButtonBox("更多", SizeInfo.AUTO_SIZE, SizeInfo.AUTO_SIZE);
        var self = button3;
        var self_this = this;
        button3.addEventListener("click", function (event: any) {
            event = event || window.event;
            var buttonContainerItems = button3.buttonContainer.getButtonContainerItems();
            if (buttonContainerItems) {
                button3.buttonContainer.initButtonContainerItems(buttonContainerItems);
            }
            if (self.getDomElement().getChildCount() > 2) {
                self.getDomElement().removeChild(self.buttonContainer);
            } else {
                self.getDomElement().addChild(self.buttonContainer);
                self.buttonContainer.getEl().focus();
            }
            var selectSheetViewName = self_this.selectSheetViewName;
            var buttonContainerItem = self.buttonContainer.getButtonContainerItem(selectSheetViewName);
            if (buttonContainerItem) {
                buttonContainerItem.setStyle("background-color", "rgb(104 113 120)");
            }
            var width = $(self.buttonContainer.getEl()).width();
            var height = $(self.buttonContainer.getEl()).height();
            self.buttonContainer.setStyle('margin-top', '-' + String(Number(height) + 40) + 'px');
            self.buttonContainer.setStyle('margin-left', '-' + String(Number(width) - 40 + 'px'));
        }, true);
        button3.buttonContainer.addEventListener("mousedown", (e: any) => {
            var el = e.target;
            var item = <AbstractDomElement>self.buttonContainer.findElement(el);
            var attribute = item.getEl().getAttribute("value");
            if (attribute) {
                var button1 = <Button>this.tableButtonViewElements.get(attribute);
                self.getDomElement().removeChild(self.buttonContainer);
                button1.getEl().click();
            }
        }, true);
        button3.buttonContainer.addEventListener("blur", (e: any) => {
            var el = e.target;
            setTimeout(function () {
                self.getDomElement().removeChild(self.buttonContainer);
            }, 1)
        }, true);
        button3.addClass("table-hide");
        button3.addClass("excel-button");
        button3.setStyle("background", "rgb(222, 236, 249)");
        this.innerTemplateTableView.addOneComponent(button2, SizeInfo.valueOfPX(20));
        this.innerTemplateTableView.addOneComponent(button3, SizeInfo.valueOfPX(20));
        this.tableButtonViewElements.set("+", button2);
        this.innerTemplateTableView.displays(this.tableButtonViewElements, button3);

    }

    getSelectViewElements(): ExcelCellView[] {
        return this.selectExcelViews;
    }

    getSelectSheetViewName(): string {
        return this.selectSheetViewName;
    }

    setSelectSheetViewName(selectSheetViewName: string): string {
        return this.selectSheetViewName = selectSheetViewName;
    }

    getSelectExcelView(): ExcelCellView {
        return this.selectExcelViews[0];
    }

    isEmbed(): boolean {
        return false;
    }

    getSheetViews(): Map<string, IExcelElementView> {
        return this.sheetViews;
    }

    getSheetView(name: string): IExcelElementView | undefined {
        return this.sheetViews.get(name);
    }

    getTagNode(): ITagNode {
        return this.getXmlEntity().getTagRoot();
    }

    getInnerTemplateTableView(): ExcelTablePanelHead {
        return this.innerTemplateTableView;
    }

    containPoint(x: number, y: number): boolean {
        return true;
    }


    hitTagNode(rowindex: number, colindex: number): ExcelCellView | null {
        var sheetView = <SheetView>this.getSelectSheetView();
        return sheetView.getChildNode(rowindex, colindex);

    }

    initDragState(sefl: ExcelGraphicView, startNode: ITagNode, endNode: ITagNode) {
        var cmd = new DragStateCmd(sefl, startNode, endNode);
        this.getCmdQueue().doCmd(cmd);
    }

    /**
     * 根据鼠标的点击位置获取到该位置对应的TagNode
     */
    hitMultiTagNode(x: number, y: number): ExcelCellView | null {
        var selectSheetView = <SheetView>this.getSelectSheetView();
        if (!selectSheetView.isEmbed() && selectSheetView.containPoint(x, y)) {
            var sectionOffset = DomUtil.offsetParent(selectSheetView.getEl());
            var offsetX = x - sectionOffset.offsetLeft;
            var offsetY = y - sectionOffset.offsetTop - EXCEL.D_TH_COLUMN_WIDTH;
            var cellView = selectSheetView.locMultiCell(offsetX, offsetY);
            if (cellView) {
                return cellView;
            }
        }

        return null;
    }

    updateView(excelGraphicView: ExcelGraphicView): void {
        this.designView.getDomElement().setStyle("width", "max-content");
        this.designView.getDomElement().setStyle("height", "max-content");
        this.innerTemplateView.getDomElement().setStyle("width", "max-content");
        this.innerTemplateView.getDomElement().setStyle("height", "max-content");
    }

    updateMultiView(excelGraphicView: ExcelGraphicView): void {

        this.updateView(excelGraphicView);
    }

    /*    /!**
         * 初始化设计模板鼠标事件
         *!/
        private initViewMouseEvent(domEl: AbstractDomElement): void {
            domEl.addEventListener('mousedown', (e: MouseEvent) => this.getOptStateDelegate().getCurrentState().mousedown(e));
            domEl.addEventListener('mousemove', (e: MouseEvent) => this.getOptStateDelegate().getCurrentState().mousemove(e));
            domEl.addEventListener('mouseup', (e: MouseEvent) => this.getOptStateDelegate().getCurrentState().mouseup(e));
        }*/

    /**
     * 初始化设计模板右键菜单事件
     */
    private initoncontextmune(domEl: AbstractDomElement): void {
        //右键菜单
        var content = this;
        this.getDomElement().setOncontextmenu(function (e: any) {
            var el = <HTMLElement>e.target;
            var {
                offsetBodyLeft,
                offsetBodyTop
            } = DomUtil.offsetBodyPosition(content.getOptStateDelegate().getCurrentState().getViewEl());
            var x = e.clientX;
            var y = e.clientY;
            if (offsetBodyLeft > 0) {
                x = e.clientX - offsetBodyLeft;
            }
            if (offsetBodyTop > 0) {
                y = e.clientY - offsetBodyTop + 100;
            }
            var top = content.boardContainer.getDomElement().getScrollTop();
            var left = content.boardContainer.getDomElement().getScrollLeft();
            var height = content.getDomElement().getHtmlClientHeight();
            var tagNode = content.getOptStateDelegate().getCurrentState().getView();
            if (!tagNode) {
                let className = el.className;
                if (className && className.indexOf("excle-board") >= 0) {
                    content.pageOpt.hide();
                    return false;
                } else if (className && className.indexOf("printarea") >= 0) {
                    content.pageOpt.show(x + 50 - left, y - top, 110, 30, content.boardContainer.getEl());
                }
            } else if (el.tagName == "TD" || (<HTMLElement>el.parentNode).tagName == "TD") {
                content.pageOpt.hide();
                y = y - top;
                if ((y + 260) > height) {
                    y = y - (y + 260 - height);
                }
                setTimeout(function () {
                    content.toolBar.show(x + 50 - left, y, 110, 260, content.boardContainer.getEl())
                    content.toolBar.getEl().focus();
                }, 100)
            }
        });
    }

    loadSheetView(xmlEntity: IXmlEntity): void {
        // 更新视图
        this.updateView(this);
        var root = xmlEntity.getTagRoot();
        this.xmlEntity = xmlEntity;
        var find = root.find(ExcelConstants.NODE_Sheet, ExcelConstants.ATTR_Name, this.selectSheetViewName);
        if (find) {
            var innerTemplateView = this.innerTemplateView;
            innerTemplateView.removeAll();
            var sheetView = <SheetView>this.sheetViews.get(this.selectSheetViewName);
            var sectionView;
            if (sheetView) {
                sectionView = new SheetView(find, sheetView.getMaxRow(), sheetView.getMaxCol(), this, true);
            } else {
                sectionView = new SheetView(find, 0, 0, this, true);
            }
            this.innerTemplateView.addComponent(sectionView);
            this.sheetViews.set(this.selectSheetViewName, sectionView);
            this.innerTemplateView.display();
            this.initInnerTemplateTableView(this.xmlEntity);
            var button = this.tableButtonViewElements.get(this.selectSheetViewName);
            //样式调整
            button!.addClass("selected");
            var image = new DomElement(new Image(8, 8));
            image.setAttr("src", EXCEL.PREFIX + "/css/img/delete-sheet.png");
            image.setStyle("position", "absolute");
            image.setStyle("right", "2px");
            image.setStyle("top", "8px");
            button!.getDomElement().addChild(image)


            //处理滚动条
            var offsetBodyPosition = DomUtil.offsetBodyPosition(button!.getEl());
            var tableElement = $(".excelTable")[0];
            if (tableElement) {
                var scrollLeft = tableElement.scrollLeft;
                var bodyLeft = offsetBodyPosition.offsetBodyLeft;
                var MaxWidth = Number($(this.getEl()).width());
                if (bodyLeft > MaxWidth || bodyLeft - Number($(".mainLeft").width()) < 0) {
                    tableElement.scrollTo(bodyLeft + scrollLeft - MaxWidth + MaxWidth / 2, 0);
                }
            }
            xmlEntity.getTagRoot().resetLineIndex(new Var(0));
        } else {
            console.error("更新SheetView失败");
        }


    }

    /**
     * 通过xml模型载入视图
     */
    load(xmlEntity: IXmlEntity): void {
        // this.sheetViews = new Map<string, IExcelElementView>();
        //this.tableButtonViewElements = new Map<string, Button>();
        this.innerTemplateView.removeAll();
        var perSelectSheetViewName = this.selectSheetViewName;
        this.xmlEntity = xmlEntity;
        // 更新视图
        this.updateView(this);
        var root = xmlEntity.getTagRoot();
        var tagSheets = root.getChildren();
        var iNode = <ITagNode>tagSheets[0];
        var name = iNode.getAttributeValue("Name");
        var sectionView;
        var sheetView = <SheetView>this.sheetViews.get(name);
        if (sheetView) {
            sectionView = new SheetView(iNode, sheetView.getMaxRow(), sheetView.getMaxCol(), this, true);
        } else {
            sectionView = new SheetView(iNode, 0, 0, this, true);
        }
        if (perSelectSheetViewName === "") {
            this.selectSheetViewName = name;
        }
        sectionView.setStyle("display", "block")
        this.innerTemplateView.addComponent(sectionView);
        this.sheetViews.set(name, sectionView);

        this.initInnerTemplateTableView(xmlEntity);
        var button1 = <Button>this.tableButtonViewElements.get(this.selectSheetViewName);
        button1.getEl().click();
        this.innerTemplateView.display();
        button1!.addClass("selected");
    }

    initInputState(sefl: ExcelGraphicView, e: any) {
        var cmd = new InputCellCmd(sefl, e);
        this.getCmdQueue().doCmd(cmd);

    }

    initInputSheetState(sefl: ExcelGraphicView, button: Button, e: any) {
        var cmd = new InputSheetCmd(sefl, button, e);
        this.getCmdQueue().doCmd(cmd);

    }

    initDeletSheetView(sefl: ExcelGraphicView, e: any) {
        var cmd = new DeleteSheetCmd(sefl, e);
        this.getCmdQueue().doCmd(cmd);

    }

    getSelectSheetView(): IExcelElementView | undefined {
        return this.sheetViews.get(this.selectSheetViewName);
    }

    getTemplateView(): JComponent<any> {
        return this.innerTemplateView;
    }

    getXmlEntity(): IXmlEntity {
        return this.xmlEntity;
    }

    getToolBar(): Menu {
        return this.toolBar;
    }

    getInnerTemplateView(): H5VFlexPanel {
        return this.innerTemplateView;
    }

    getTableButtonViewElements(): Map<string, Button> {
        return this.tableButtonViewElements;
    }

    getExcelToolbar(): ExcelToolbar {
        return this.excelToolbar;
    }

    getSelectionModel(): SelectionModel {
        return this.xmlEntity.getSelectionModel();
    }

    createOptStateDelegate() {
        return new ExcelOptStateDelegate(this);
    }

    getPropertyDefine(): AbstractPropertyDefine {
        return ExcelPropertyDefine.getInstance()
    }

    getCmdQueue(): CmdQueue {
        return this.xmlEntity.getCmdQueue();
    }

    undoCmd(): void {
        this.getCmdQueue().undoCmd();
    }


    // 根据xml模型中的变化事件，更新界面显示
    notifyEvent(cmd: string, paras: Paras): void {
        var node = paras.getElement();
        switch (cmd) {
            case ActionNames.model_node_add:
                this.load(this.xmlEntity);
                break;
            case ActionNames.model_node_remove:
                this.removePrintNode(node);
                break;
            case ActionNames.model_node_update:
                this.update(node);
                break;
            case ActionNames.model_node_update_select:
                this.update(node);
                break;
            case ActionNames.model_node_update_multi_select:
                this.updateMulti(node);
                break;
        }
    }

    private removePrintNode(tagNode: ITagNode) {
        this.load(this.xmlEntity);  //暂时做整个View刷新测试效果，后面看情况改进
    }

    /**
     * 更新节点视图,前提:tagNode必须已经在xmlEntity中存在
     */
    updateMulti(tagNode: ITagNode | undefined): void {
        if (!tagNode) return undefined;
        if (!this.getSelectionModel().getBMultiSelection()) {
            if (!this.tableButtonViewElements.get(this.selectSheetViewName)) {
                this.load(this.xmlEntity)
            } else {
                this.loadSheetView(this.xmlEntity);

            }
        }
        var selected = tagNode.isSelected();
        var tagStack: ITagNode[] = [];
        while (tagNode) {
            tagStack.push(tagNode);
            tagNode.setSelected(selected);
            if (tagNode == this.getTagNode()) break;
            tagNode = tagNode.getParent();
        }
        var rootTag = tagStack.pop();
        if (rootTag != this.getTagNode()) {

            var stackNode;

            var view: IExcelElementView = this;
            while (stackNode = tagStack.pop()) {
                var tmpView = view.findChildNode(stackNode);
                if (tmpView) {
                    tmpView.updateMultiView(this);
                    view = tmpView;
                }
                if (tagStack.length == 0) break;
            }

            if (rootTag) {
                var findChildNode1 = view.findChildNode(rootTag);
                if (!findChildNode1) return;
                var findChildNode2 = <ExcelCellView>findChildNode1!.findChildNode(rootTag);
                if (findChildNode2) {

                    findChildNode2.getTagNode()?.setSelected(selected);
                    findChildNode2!.updateMultiView(this);
                }
            }
            return;
        }
        var stackNode;

        var view: IExcelElementView = this;
        while (stackNode = tagStack.pop()) {
            var tmpView = view.findChildNode(stackNode);
            if (tmpView) {
                tmpView.updateMultiView(this);
                view = tmpView;
            }
            if (tagStack.length == 0) break;
        }


    }

    /**
     * 更新节点视图,前提:tagNode必须已经在xmlEntity中存在
     */
    update(tagNode: ITagNode | undefined): void {
        if (!tagNode) return undefined;
        if (!this.getSelectionModel().getBMultiSelection()) {
            if (!this.tableButtonViewElements.get(this.selectSheetViewName)) {
                this.load(this.xmlEntity)
            } else {
                if (tagNode.getTagName() == "Sheet") {
                    this.loadSheetView(this.xmlEntity);
                    return;
                }
            }
        }
        var selected = tagNode.isSelected();
        var tagStack: ITagNode[] = [];
        while (tagNode) {
            tagStack.push(tagNode);
            if (tagNode.getTagName() != "Rows" && tagNode.getTagName() != "Sheet" && tagNode.getTagName() != "Workbook") {
                tagNode.setSelected(selected);
            }
            if (tagNode == this.getTagNode()) break;
            tagNode = tagNode.getParent();
        }
        var rootTag = tagStack.pop();
        if (rootTag != this.getTagNode()) {

            var stackNode;

            var view: IExcelElementView = this;
            while (stackNode = tagStack.pop()) {
                var tmpView = view.findChildNode(stackNode);
                if (tmpView) {
                    tmpView.updateView(this);
                    view = tmpView;
                }
                if (tagStack.length == 0) break;
            }

            if (rootTag) {
                var findChildNode1 = view.findChildNode(rootTag);
                if (!findChildNode1) return;
                var findChildNode2 = <ExcelCellView>findChildNode1!.findChildNode(rootTag);
                if (findChildNode2) {
                    findChildNode2.getTagNode()?.setSelected(selected);
                    findChildNode2!.updateView(this);
                }
            }
            return;
        }
        var stackNode;

        var view: IExcelElementView = this;
        while (stackNode = tagStack.pop()) {
            var tmpView = view.findChildNode(stackNode);
            if (tmpView) {
                tmpView.updateView(this);
                view = tmpView;
            }
            if (tagStack.length == 0) break;
        }


    }


    findChildNode(tagNode: ITagNode): IExcelElementView | undefined {
        return this.getSelectSheetView();
    }
}