import AbstractDesignView from "../../base/AbstractDesignView";
import DevPropertyPlugin from "../../bpm/property/DevPropertyPlugin";
import ComplexDesignView from "../../base/ComplexDesignView";
import PrintToolbar from "../../print/view/PrintToolbar";
import PropertyPlugin from "../../plugin/property/PropertyPlugin";
import ExcelGraphicView from "./ExcelGraphicView";
import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import DesignVariable from "../../base/DesignVariable";
import PropertyUIContainer from "../../plugin/property/ui/PropertyUIContainer";
import PrintConstants from "../../print/base/PrintConstants";
import SizeInfo from "../../../common/struct/SizeInfo";
import ExcelPropertyDefine from "../base/ExcelPropertyDefine";
import ExcelConstants from "../base/ExcelConstants";

export default class ExcelDesignView extends AbstractDesignView<DevPropertyPlugin> {
    private viewContainer: ComplexDesignView<ExcelGraphicView, PrintToolbar>;

    private propertyPlugin: PropertyPlugin;

    constructor(viewContainer: ComplexDesignView<ExcelGraphicView, PrintToolbar>, optDispatcher: OperationDispatcher) {
        super(DesignVariable.D_PROPERTY_WIDTH, new PropertyUIContainer(new DevPropertyPlugin(optDispatcher)));
        this.viewContainer = viewContainer;
        this.propertyPlugin = this.propertyUIContainer.getPropertyPlugin();

        this.propertyUIContainer.setStyle('float', 'right');
        this.setCenter(viewContainer);
        this.setRight(this.propertyUIContainer);

        var PD = ExcelPropertyDefine.getInstance();
        this.propertyPlugin.register(ExcelConstants.NODE_Workbook, PD.getPropertyDefines(ExcelConstants.NODE_Workbook));
        this.propertyPlugin.register(ExcelConstants.NODE_Sheet, PD.getPropertyDefines((ExcelConstants.NODE_Sheet)));
        this.propertyPlugin.register(ExcelConstants.NODE_Column, PD.getPropertyDefines(ExcelConstants.NODE_Column));
        this.propertyPlugin.register(ExcelConstants.NODE_Row, PD.getPropertyDefines(ExcelConstants.NODE_Row));

        var cellPropertyGroups = PD.getPropertyDefinesByTypes([ExcelConstants.NODE_Cell, ExcelConstants.NODE_Row, ExcelConstants.NODE_Column, ExcelConstants.NODE_Sheet]);
        this.propertyPlugin.register(ExcelConstants.NODE_Cell, cellPropertyGroups);
    }

    resize(parentWidth: number, parentHeight: number) {
        var width = parentWidth -  DesignVariable.D_PROPERTY_WIDTH;
        this.viewContainer.resize(width, parentHeight);
        this.propertyUIContainer.setHeight(SizeInfo.valueOfPX(parentHeight));
    }
}