import AbstractExcelOptState from "./AbstractExcelOptState";
import SheetView from "../view/element/SheetView";
import {ExcelCellView} from "../view/element/ExcelCellView";

export default class ExcelThEventState extends AbstractExcelOptState {
    private startX = 0;
    private startY = 0;
    private el: any;

    mousedown(e: MouseEvent): void {
        super.mousedown(e);

        this.el = <HTMLElement>e.target;
        this.startX = Number(this.el.getAttribute("rowindex"))
        this.startY = Number(this.el.getAttribute("colindex"));
        this.getView().getXmlEntity().getSelectionModel().setBMultiSelection(true);
        this.getView().getXmlEntity().getSelectionModel().unMultiSelection();
        this.getView().getXmlEntity().getSelectionModel().setBMultiSelection(false);
        this.getView().getXmlEntity().getSelectionModel().selectRoot();
        var selectSheetView = <SheetView>this.getView().getSelectSheetView();
        this.getView().reloadSelectExcelView();
        if (this.el.getAttribute("rowindex") == null && this.el.getAttribute("colindex") == null) {
            this.getView().getXmlEntity().getSelectionModel().select(this.getView().getXmlEntity().getTagRoot());
        } else if (this.el.getAttribute("rowindex") == null) {//
            var nodes = selectSheetView.getChildColgroupNodes();
            //处理多选
            for (let i = 0; i < nodes.length; i++) {
                nodes[i].removeClass("selectedTH");
            }
            var childNode1 = selectSheetView.getChildNode(0, this.startY - 1);
            this.getView().selectExcelView(<ExcelCellView>childNode1);

            this.getView().getXmlEntity().getSelectionModel().select(childNode1?.getTagNode());
            this.getView().getXmlEntity().getSelectionModel().setBMultiSelection(true);
            var colChildNode = selectSheetView.getColChildNode(this.startY - 1);
            for (let i = 1; i < colChildNode.length; i++) {
                this.getView().getXmlEntity().getSelectionModel().select(colChildNode[i].getContent().getTagNode());

            }
            this.getView().getXmlEntity().getSelectionModel().setBMultiSelection(false);
        } else if (this.el.getAttribute("colindex") == null) {

            var childNode1 = selectSheetView.getChildNode(this.startX, 0);
            this.getView().selectExcelView(<ExcelCellView>childNode1);

            this.getView().getXmlEntity().getSelectionModel().select(childNode1?.getTagNode());
            selectSheetView = <SheetView>this.getView().getSelectSheetView();
            var rowChildNode = selectSheetView.getRowChildNode(this.startX);
            this.getView().getXmlEntity().getSelectionModel().setBMultiSelection(true);
            for (let i = 1; i < rowChildNode.length; i++) {
                this.getView().getXmlEntity().getSelectionModel().select(rowChildNode[i].getContent().getTagNode());
            }
            this.getView().getXmlEntity().getSelectionModel().setBMultiSelection(false);
        }
    }

    mousemove(e: MouseEvent): void {
        var target = <HTMLElement>e.target;
        if (target.className == "excel-dragRow") {
            this.getDelegate().setRragRowState();
        } else if (target.className == "excel-dragColumn") {
            this.getDelegate().setDragColumnState();
        } else if (target.nodeName != "TH" && target.nodeName != "SPAN") {
            this.getDelegate().setNormalState();
        }
    }


    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        var {x, y} = this.getPosition(e);
        console.log("你点击了图片")
    }
}