import AbstractLink from "../link/AbstractLink";
import IGTable from "../../../../../common/ui/graphic/IGTable";
import WfDefines from "../../../../bpm/base/WfDefines";
import RectBound from "../../../../../common/struct/RectBound";
import WfConstants from "../../../../bpm/base/WfConstants";
import AbstractMigrationElement from "../AbstractMigrationElement";


export default class ShadowLink extends AbstractLink {

    private shadowLine: IGTable | undefined;

    private static style = {stroke: WfDefines.G_COLOR_STROKE_NORMAL, 'fill-opacity': '0.5', 'strokeWidth': 1, 'stroke-dasharray': '5,3'};

    constructor() {
        super();
    }

    public drawGraphic(): IGTable {
        this.shadowLine = this.gSection.path("");
        return this.shadowLine;
    }

    public drawShadowToLink(toRect: RectBound): void {
        if (this.fromEvent) {
            var pos = this.getPos(this.fromEvent, toRect);
            this.shadowLine && this.shadowLine.attr({"path": pos.linestr}).attr(ShadowLink.style);
        }
    }

    public drawShadowFromLink(fromRect: RectBound): void {
        if (this.toNode) {
            var pos = this.getPos(fromRect, this.toNode.getBounds());
            this.shadowLine && this.shadowLine.attr({"path": pos.linestr}).attr(ShadowLink.style);
        }
    }

    public getType(): string {
        return WfConstants.NODE_Flow_Sequence;
    }

    protected getDefaultCaption(): string {
        return '';
    }

    public newInstance(): AbstractMigrationElement {
        return new ShadowLink();
    }

    getSelectSymbo(): IGTable | undefined {
        return undefined;
    }

}
