import JComponent from "../../../../common/component/JComponent";
import DomUtil from "../../../../common/dom/DomUtil";
import SpanElement from "../../../../common/dom/element/SpanElement";
import TableLayout from "../../../../common/dom/element/TableLayout";
import SizeInfo from "../../../../common/struct/SizeInfo";
import INode from "../../../../common/xml/node/INode";
import ITagNode from "../../../../common/xml/node/ITagNode";
import BaseConstants from "../../../base/BaseConstants";
import TableCellLocation from "../../../../common/struct/TableCellLocation";
import {ExcelCellView} from "../../../excel/view/element/ExcelCellView";
import IDataMigrationElementView from "./IDataMigrationElementView";
import DataMigrationTableLayout from "../DataMigrationTableLayout";
import DataMigrationConstants from "../../base/DataMigrationConstants";
import {FieldView} from "../FieldView";
import Span from "../../../../common/component/control/Span";
import InputElement from "../../../../common/dom/element/InputElement";
import {CellView} from "../../../print/view/element/CellView";
import IGTable from "../../../../common/ui/graphic/IGTable";
import DataMigrationGraphicView from "../DataMigrationGraphicView";
import TextEditor from "../../../../common/component/control/TextEditor";
import Menu from "../../../../common/component/menu/Menu";
import DATAMIGRATION from "../../base/DATAMIGRATION";
import {CommonConstant} from "../../../datamap/base/CommonConstant";

export default class TargetTableView extends JComponent<DataMigrationTableLayout> implements IDataMigrationElementView {
    get isSource(): boolean {
        return this._isSource;
    }

    private tagNode: ITagNode;
    private tableElement: DataMigrationTableLayout;
    private menu: Menu = new Menu();
    private addicon: Span | undefined;

    private addItemInput: TextEditor | undefined;
    private addItemButton: Span | undefined;
    private tableName: string | undefined;

    private inputButton: InputElement | undefined;

    private isFirst: boolean = false;

    private _isSource: boolean = false;


    constructor(tagNode: ITagNode, isFirst: boolean, map: Map<string, any>, dataMigrationGraphicView: DataMigrationGraphicView) {
        super(new DataMigrationTableLayout(0, 0));
        this.tagNode = tagNode;
        this.tableElement = this.getDomElement();
        if (tagNode.getTagName() == "TargetTable") {
            this.tableElement.init(DATAMIGRATION.D_ROW_HEIGHT, tagNode.getParent()!.getAttributeValueInt(BaseConstants.ATTR_Width, 0));

        } else {
            this.tableElement.init(DATAMIGRATION.D_ROW_HEIGHT, tagNode.getAttributeValueInt(BaseConstants.ATTR_Width, 0));
        }
        this.tableElement.addClass('layout');
        if (isFirst) {
            this.isFirst = true;
            this.buildFirstTable(map, dataMigrationGraphicView);
        } else {
            this.buildTable(map, dataMigrationGraphicView);
        }

    }

    getMenu(): Menu {
        return this.menu;
    }

    line(x1: number, y1: number, x2: number, y2: number): IGTable {
        throw new Error("Method not implemented.");
    }

    table(x: number, y: number, width: number, height: number): IGTable {
        throw new Error("Method not implemented.");
    }

    clear(): void {
        throw new Error("Method not implemented.");
    }

    attr(params: { [attr: string]: any; }): IGTable {
        throw new Error("Method not implemented.");
    }

    getHtmlElement(): HTMLElement {
        throw new Error("Method not implemented.");
    }

    section(varargs?: any): IGTable {
        throw new Error("Method not implemented.");
    }

    findChildNode(tagNode: ITagNode): IDataMigrationElementView | null {
        throw new Error("Method not implemented.");
    }

    updateView(): void {
        //更新选中状态
        this.getTagNode().isSelected() ? this.addClass('selected') : this.removeClass('selected');
    }

    /* findChildNode(tagNode: ITagNode): IPrintElementView | null {
         for (var row=0; row<=this.tableElement.getLastRowIndex(); row++) {
             for (var col=0; col<=this.tableElement.getLastColumnIndex(); col++) {
                 var cell = this.tableElement.getCellAt(row, col);
                 var cellView = <CellView> cell.getContent();
                 if (cellView && cellView.getTagNode() == tagNode) {
                     return cellView;
                 }
             }
         }
         return null;
     }*/
    getAddItemInput(): TextEditor | undefined {
        return this.addItemInput;
    }

    getInputButton(): InputElement | undefined {
        return this.inputButton;
    }

    isEmbed(): boolean {
        return false;
    }

    getAddItemButton(): Span | undefined {
        return this.addItemButton;
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }

    buildTable(map: Map<string, any>, dataMigrationGraphicView: DataMigrationGraphicView) {
        var tagRow = this.tagNode;
        var firstTitle = this.tableElement.addField("target");
        let itemTd = this.tableElement.addSpan();
        this.addicon = itemTd.getIcon();
        this.inputButton = itemTd.getInputButton();
        this.addItemButton = itemTd.getAddItemButton();
        this.addItemInput = itemTd.getAddItemInput();
        var firstView = new FieldView(this.tagNode);
        firstTitle.addChild(firstView)

        firstTitle.addClass("tablehead");
        let Field = map.get(this.tagNode.getAttributeValue(DataMigrationConstants.NODE_FieldKey));
        firstView.updateView("", dataMigrationGraphicView, Field?.DataType, "");
        var mapNode = this.tagNode.getParent()!.getParent()!;
        let targetDataObjectKey = mapNode.getAttributeValue("TgtDataObjectKey");
        let tableKey = this.tagNode.getAttributeValue("TableKey");
        this.tableName = targetDataObjectKey + "|" + tableKey;
        this.addicon.getDomElement().setAttr("tableName", targetDataObjectKey + "|" + tableKey);
        this.addItemButton.getDomElement().setAttr("tableName", targetDataObjectKey + "|" + tableKey);
        this.inputButton.setAttr("tableName", targetDataObjectKey + "|" + tableKey)
        let attributeValue = this.tagNode.getAttributeValue(BaseConstants.ATTR_TableKey);
        let field1 = map.get(attributeValue);
        firstView.setText("(表" + field1?.index + ")    " + attributeValue
            + " " + field1?.Caption);
        firstView.setStyle('font-size', '14px');
        firstView.setStyle('font-weight', 'bold');
        var tagCells = tagRow.getChildren();
        for (var colindex = 0; colindex < tagCells.length; colindex++) {
            var field = this.tableElement.addField("target");
            var tagField = <ITagNode>tagCells[colindex];
            var cellView = new FieldView(tagField);
            field.addChild(cellView);
            let field2 = map.get(tagField.getAttributeValue(DataMigrationConstants.NODE_FieldKey));
            let type = tagField.getAttributeValue(CommonConstant.NODE_Type);
            cellView.updateView(field2?.Caption+" <"+field2?.RoupType+">", dataMigrationGraphicView, field2?.DataType, type);

        }
    }

    buildFirstTable(map: Map<string, any>, dataMigrationGraphicView: DataMigrationGraphicView) {
        let firstTitle = this.tableElement.addField("target");
        var firstView = new FieldView(this.tagNode);
        firstTitle.addChild(firstView)
        let iTagNode = this.tagNode.getParent()!;
        let attributeValue = iTagNode.getAttributeValue("TgtDataObjectKey");
        this.tableName = attributeValue;
        firstView.buildFirstView(map.get(attributeValue)?.Caption);
        let itemTd = this.tableElement.addSpan();

        firstTitle.addClass("tablehead");
        this.addicon = itemTd.getIcon();
        this.inputButton = itemTd.getInputButton();
        this.addItemInput = itemTd.getAddItemInput();
        this.addItemButton = itemTd.getAddItemButton();
        this.addicon.getDomElement().setAttr("tableName", attributeValue);
        this.inputButton.setAttr("tableName", attributeValue);
        this.addItemButton?.getDomElement().setAttr("tableName", attributeValue);
    }

    createCellSpan(tagCell: ITagNode): SpanElement {
        var span = new SpanElement(tagCell.getAttributeValue(BaseConstants.ATTR_Caption));
        return span;
    }

    getWidth(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableElement.getWidth()!);
    }

    getHeight(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableElement.getHeight()!);
    }

    getAddIcon(): Span {
        return this.addicon!;
    }

    getIsFirst(): boolean {
        return this.isFirst;
    }

    getTableName(): string {
        return this.tableName!;
    }

    containPoint(x: number, y: number): boolean {
        var offset = DomUtil.offsetParent(this.getEl());
        var top = offset.offsetTop;
        var left = offset.offsetLeft;
        var width = this.getDomElement().getHtmlClientWidth();
        var height = this.getDomElement().getHtmlClientHeight();
        return x >= left && x <= (left + width)
            && y >= top && y <= (top + height);
    }

    locCell(x: number, y: number): FieldView | null {
        var cellLocation = this.tableElement.hitCell(x, y);
        if (cellLocation) {
            var cell = this.tableElement.getCell(cellLocation);
            return <FieldView>cell.getContent();
        } else if (cellLocation == 0) {
            var cell = this.tableElement.getCell(0);
            return <FieldView>cell.getContent();
        }
        return null;
    }


}